/* egaset.c (emx+gcc) -- Copyright (c) 1994 by Steffen Haecker */

#include <stdlib.h>
#include <sys/hw.h>
#include "graph2.h"
#include "ega.h"


void _ega_set (unsigned x, unsigned y, int color)
{
  volatile unsigned char *p;

  if (x >= _g_clipx0 && x <= _g_clipx1 && y >= _g_clipy0 && y <= _g_clipy1)
    {
      GLOCK;
      p = _g_mem + y * 80 + x / 8;
      OUT2 (0x205, (0x8000 >> (x & 7)) | 8);
      *p; *p = (unsigned char)color;
      OUT2 (0xff00, 0x0005);
      GUNLOCK;
    }
}
