/* Installation script for PM DCopy.
 * - J.R.Shannon 1992, 1993.
 */

CALL rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
CALL sysloadfuncs

SAY 'Please enter the full pathname of the directory into which you'
SAY 'would like PM DCopy to be installed (eg. C:\FILES\APPS\PMDCOPY)'
PULL DestDir

IF DestDir = "" THEN
  DestDir = 'C:\OS2\APPS'

rc = SysFileTree(DestDir, 'Dirs', 'D')

IF Dirs.0 = 0 THEN
  CALL SysMkDir DestDir

SAY 'Do you want a PM DCopy program object created on the desktop? (Y/N)'
PULL response

IF response = "Y" THEN
  folder = '<WP_DESKTOP>'
ELSE
DO
  say 'You will have to add' destdir 'to your PATH in config.sys then.'
  folder = ''
END

'@copy pmdcopy.exe' destdir
'@copy pmdcopy.hlp' destdir

IF folder = "" THEN nop; ELSE
DO
  SAY 'Creating program object...'

  Type='WPProgram'
  Title='PM DCopy'
  Parms='MINWIN=DESKTOP;PROGTYPE=PM;EXENAME='DestDir'\PMDcopy.exe;STARTUPDIR='DestDir';OBJECTID=<PMDCOPY>;NOPRINT=YES'
        
  rc = SysCreateObject(Type, Title, Folder, Parms)

  IF rc = 1 THEN
    SAY 'Desktop object created...'
  ELSE
    SAY 'Desktop creation failed - rc =' rc
END

SAY 'Installation complete...'


