/****	SNMP interface code	****/

/*	Copyright (C) 1990, 1991 Massachusetts Institute of Technology
 *		Right to copy granted under the terms described
 *		in the file Copyright accompanying this distribution.
 */

/*	Based on code by J. Davin
 *	Copyright 1988, 1989, Massachusetts Institute of Technology
 *	Distributed as part of the SNMP datakit, see that distribution
 *	(file notice.h) for original restrictions (more liberal).
 */


/* This is the SNMP interface code for the LCS Interactive Network Map.
 * For now this is incredibly simplistic just to get something in.
 */


#ifdef EDIT_HISTORY

Nbr Date	Author		Description
--- ----	------		-----------
 5  12-Jun-90	M. A. Patton	First version incorporated from prior work
				by Chuck Davin.
 5A 13-Jun-90	M. A. Patton	Moved selectIPAddr to main program where it is
				useful for other things.
 5B 14-Jun-90	M. A. Patton	Split the externally visible functions and
				moved the command interpretor part to the main
				file.  Also now right justify fields that are
				generally numbers (looks better).
 5C 15-Jun-90	M. A. Patton	Made protocol retry on timeouts.  Also made
				printValue take a width rather than a format
				string to enhance error handling.  Added IP
				address dump.  Various cleanup.  Made table
				for symbolic OIDs.  Fixed up all references.
 5D 21-Jun-90	M. A. Patton	Added SNMP Neighbors command.
 5E 10-Aug-90	M. A. Patton	Added type to routes and speed in interfaces.
				Changed which types were acceptable to
				"SNMP Neighbors" command (was only Remote, now
				any but Direct).
 5F  1-Jan-91	Havard Eidnes	Clean up type clash in call to inet_ntoa.
		Mike Patton	Don't need the SNMP debug.h, but do need local
				one.  This used to work due to -I. in cc, but
				that won't be reasonable in next version...
				Cleaned out other unrefed include files.
 5G 25-Apr-91	Mike Patton	Eliminated hard-coded array in "snmp neighbors"
				processing.  Now builds dynamically.

#endif
/**** Documentation ****/


#ifdef DOCUMENTATION


Needs to be written!!!!


#endif
/****	Compiler setup page	****/

#include	"map.h"

#include	"debug.h"

#include	<notice.h>
#include        <netdb.h>
#include        <signal.h>
#include	<errno.h>
extern int errno;

#include	<host.h>

/* to avoid "redefined" errors, these are set above... */
#undef TRUE
#undef FALSE
#include	<ctypes.h>
#include	<local.h>
#include	<udp.h>

#define cmdBufferSize		(2048)
#define cmdBindListSize		(20)
#define cmdTextSize		(256)

#define NBRTRIES	3	/* default number of attempts for poll */



typedef struct _oid_trans_ {
	struct _oid_trans_ *next;
	char *name;
	char *nbr;
    } oid_trans;
oid_trans *oid_base = NULL;


extern char *dflt_path[];
#define mib_path dflt_path
char *mib_ext[] = {
    "",
    ".mib",
    NULL };


/*
 *	Warning! This use of global data structures (among
 *	others) makes this code non-reentrant.
 */

static		ApsIdType		communityId;
static		CIntfType		timeout;
static		CIntfType		tries;
static		u_short			agentPort;
static		u_short			trapPort;
static		CIntfType		sock = -1;
static		enum { Waiting, Timeout, Done }	cmdState;
static		CBoolType		cmdBanner;
static		u_long			currentHost;
static		SmpStatusType		(*currentRtn)();
static		CByteType		origBuf [ cmdBufferSize ];
static		SmpBindType		origBindList [ cmdBindListSize ];
static		CByteType		retransBuf [ cmdBufferSize ];
static		SmpBindType		retransBindList [ cmdBindListSize ];
static		SmpRequestType		req;
static		SmpSequenceType		requestId;
/****	????	****/


void
snmpInit()
{   char *bp;
    struct servent *svp;
    extern char	*getOption();
    FILE *fd;

    aslInit();
    asnInit();
    apsInit();
    ap0Init();
    smpInit();

    bp = getOption("snmp.community");
    if (bp == NULL)
    {	bp = "public";
    }
    communityId = apsNew((ApsNameType) bp,
			 (ApsNameType) "trivial",
			 (ApsGoodiesType) 0);

    bp = getOption("snmp.requestId");
    if (bp == NULL)
    {	bp = "0";
    }
    requestId = (SmpSequenceType) atoi(bp);

    bp = getOption("snmp.timeout");
    if (bp == NULL)
    {	bp = "5";
    }
    timeout = atoi(bp);

    bp = getOption("snmp.agentPort");
    if (bp == NULL)
    {	svp = getservbyname("snmp", "udp");
	if (svp == (struct servent *) 0)
	{   fprintf(stderr, "%s: No such service: %s/%s\n",
                                "snmpInit", "snmp", "udp");
	    agentPort = (u_short) 161;
	    agentPort = htons(agentPort);
	}
	else
	{   agentPort = (u_short) svp->s_port;
	}
    }
    else
    {	agentPort = (u_short) atoi(bp);
	agentPort = htons(agentPort);
    }

    bp = getOption("snmp.trapPort");
    if (bp == NULL)
    {	svp = getservbyname("snmp-trap", "udp");
	if (svp == (struct servent *) 0)
	{   fprintf (stderr, "%s: No such service: %s/%s\n",
                                "snmpInit", "snmp-trap", "udp");
	    trapPort = (u_short) 162;
	    trapPort = htons(trapPort);
	}
	else
	{   trapPort = (u_short) svp->s_port;
	}
    }
    else
    {	trapPort = (u_short) atoi(bp);
	trapPort = htons(trapPort);
    }
    if ( (fd=find_file("mib",mib_path,mib_ext,NULL)) == NULL)
    {	fprintf(stderr, "Can't find symbolic MIB translations!\n");
	return;
    }
    while (bp=GetLine(fd))
    {	char *tp=index(bp,' ');
	oid_trans *p;
	if (tp==NULL)
	{   fprintf(stderr,"Ignoring bad line in OID file \"%s\".\n",bp);
	    continue;
	}
	*tp++ = '\0';
	p = (oid_trans *) malloc(sizeof(oid_trans));
	p->name = new_string(tp);
	p->nbr = new_string(bp);
	p->next = oid_base;
	oid_base = p;
    }
    fclose(fd);
}
/****	????	****/


static	int
snmpClientSocket ()
{   int		s;
    int		result;
    struct	sockaddr	salocal;
    struct	sockaddr_in	*sin;

    s = socket(AF_INET, SOCK_DGRAM, 0);
    if (s < 0)
    {	(void) perror("socket");
	return (s);
    }

    sin = (struct sockaddr_in *) & salocal;
    bzero ((char *) sin, sizeof (*sin));
    sin->sin_family = AF_INET;
    sin->sin_addr.s_addr = (u_long) 0;
    sin->sin_port = (u_short) 0;

    result = bind(s, & salocal, sizeof (*sin));
    if (result < 0)
    {	(void) perror("bind");
	close(s);
	return (-1);
    }
    return (s);
}


static	void
printValue (width, bind)
int		width;
SmpBindPtrType	bind;
{   char *bp;
    int len = width;

    if (len == 0) len = cmdBufferSize;
    bp = malloc(len+1);
    if (smxValueToText(bp, (CIntfType)len, bind) >= (CIntfType) 0)
    {	if (width) switch (bind->smpBindKind)
	{
	case smpKindInteger:
	case smpKindCounter:
	case smpKindGuage:
	case smpKindTimeTicks:
			printf("%*.*s ", width, width, bp);
			break;
	default:
			printf("%-*.*s ", width, width, bp);
	}
	else
	    fputs(bp, stdout);
    }
    else
    {	if (width > 7)
	    printf("%-*.*s ", width, width, "TOO BIG");
	else if (width == 0)
	    printf("Over %d bytes long!!!", len);
	else
	{   while (width--) putchar('?');
	    putchar(' ');
	}
    }
    free (bp);
}


static void
printOid(bind)
SmpBindPtrType	bind;
{   char buf[cmdBufferSize];

    if (smxValueToText(buf, (CIntfType)cmdBufferSize, bind) >= (CIntfType) 0)
    {	oid_trans *tr;
	MAPCAR(tr, oid_base)
	{   char *cp, *tp;
	    cp = tr->nbr;
	    tp = buf;
	    while (*cp!='\0'&&*cp==*tp) { cp++; tp++; }
	    if (*cp=='\0')
	    {	printf("%s%s",tr->name,tp);
		return;
	    }
	}
	printf("%s", buf);
	return;
    }
    printf("OID translation more than %d characters???\n",
	   (CIntfType)cmdBufferSize);
}


int
parseOid(bp,n,txt)
char *bp;			/* Output buffer */
int n;				/* Number of bytes available */
char *txt;			/* String to parse */
{   char buf[cmdBufferSize];
    oid_trans *tr;

    if (isdigit(*txt))
	return (smxTextToObjectId(bp,n,txt));
    MAPCAR(tr,oid_base)
    {	char *cp, *tp;
	cp = tr->name;
	tp = txt;
	while (*cp!='\0'&&upcase(*cp)==upcase(*tp)) { cp++; tp++; }
	if (*cp=='\0' && (*tp=='\0' || *tp=='.'))
	{   strcpy(buf,tr->nbr);
	    strcat(buf,tp);
	    return (smxTextToObjectId(bp,n,buf));
	}
    }
    return (-1);
}
/****	????	****/



static	char	*ifTableArgs [ ] = {
	"ifIndex",
	"ifDescr",
	"ifOperStatus",
	"ifMtu",
	"ifSpeed",
	"ifInOctets",
	"ifInNUcastPkts",
	"ifOutOctets",
	"ifOutNUcastPkts",
	NULL,
};

char *ifStatus[] = { "ZERO", " up", "down", "test" };


static  SmpStatusType
intfcUpCall (smp, rsp)
SmpIdType               smp;
SmpRequestPtrType       rsp;
{   int			cmp;
    CBytePtrType		bp;
    CIntfType			space;
    SmpIndexType		i;
    SmpBindPtrType		bind;
    SmpBindPtrType		orig;

    /* Our reply ? */
    if ((rsp->smpRequestCmd != smpCommandRsp) ||
	(rsp->smpRequestId != requestId))
    {	return (errOk);
    }

    /* Error? */
    smp = smp;
    if (rsp->smpRequestError != smpErrorNone)
    {	printf("Protocol Error: %s\n", smxErrorToText(rsp->smpRequestError));
	cmdState = Done;
	return (errOk);
    }

    /* Are we out of interfaces? */
    orig = origBindList;
    bind = rsp->smpRequestBinds;
    cmp = 0;
    for (i = rsp->smpRequestCount; (i != 0) &&
	 ((cmp = bcmp((char *) bind->smpBindName,
		      (char *) orig->smpBindName,
		      (int) orig->smpBindNameLen)) == 0); i--)
    {	orig++;
	bind++;
    }
    if (cmp != 0)
    {	cmdState = Done;
	return (errOk);
    }

    if (! cmdBanner)
    {	printf ("Ifc ");
	printf ("Description   ");
	printf ("Status");
	printf ("   Mtu");
	printf ("  Speed");
	printf ("  Bytes Rcv ");
	printf ("  Bdcst Rcv ");
	printf ("  Bytes Out ");
	printf ("  Bdcst Out");
	printf ("\n");
	cmdBanner = TRUE;
    }
    bind = rsp->smpRequestBinds;
    i = rsp->smpRequestCount;
    printValue(3, bind);
    bind++; i--;
    if (bind->smpBindKind != smpKindOctetString)
    {	fprintf(stderr, "ifDescr was not an OctetString type?\n");
	printValue(14, bind);
    }
    else
    {	if (bind->smpBindValueLen > 14)
	    printf("%-14.14s ", bind->smpBindValue);
	else
	{   printf("%-*.*s%-*.*s ",
		   bind->smpBindValueLen, bind->smpBindValueLen,
		   bind->smpBindValue,
		   14-bind->smpBindValueLen, 14-bind->smpBindValueLen,
		   "");
	}
    }
    bind++; i--;
    if (bind->smpBindKind != smpKindInteger)
    {	fprintf(stderr, "OperStatus was not an Integer type?\n");
	printValue(4, bind);
    }
    else if ( ((CUnslType) bind->smpBindNumber) >= array_sizeof(ifStatus) )
    {	fprintf(stderr, "OperStatus value (%d) is out of range.\n",
		(CUnslType) bind->smpBindNumber);
	printValue(4, bind);
    }
    else
    {	printf("%-4.4s ", ifStatus[(CUnslType) bind->smpBindNumber]);
    }
    bind++; i--;
    printValue(6, bind);
    bind++; i--;
    if (bind->smpBindKind != smpKindGuage)
    {	fprintf(stderr, "Speed was wrong type?\n");
	printValue(5, bind);
    }
    else
    {	CUnslType val = bind->smpBindNumber;
	char *lvl = " KMG";
	while ( val!=0 && 1000*((val)/1000)==val && lvl[1]!='\0' )
	{   lvl++;
	    val /= 1000;
	}
	if ( val > 1000 &&  lvl[1]!='\0' )
	{   int n = 3;
	    int w = val / 1000;
	    val -= w*1000;
	    while ( 10*((val)/10)==val)
	    {   --n;
		val /= 10;
	    }
	    printf("%*d.%0*.*d%c", 4-n, w, n, n, val, *++lvl);
	}
	else
	    printf("%5d%c", val, *lvl);
    }
    bind++; i--;
    while (i != 0)
    {	printValue(11, bind);
	bind++; i--;
    }
    printf("\n");

    /* Do it again */
    orig = retransBindList;
    bp = retransBuf;
    space = cmdBufferSize;
    bind = rsp->smpRequestBinds;
    i = rsp->smpRequestCount;
    for ( i = rsp->smpRequestCount; (i != 0); i--, orig++, bind++ )
    {	orig->smpBindNameLen = bind->smpBindNameLen;
	orig->smpBindName = (SmpNameType) bp;
	bp += bind->smpBindNameLen;
	space -= bind->smpBindNameLen;
	orig->smpBindKind = smpKindOctetString;
	orig->smpBindValue = (SmpValueType) 0;
	orig->smpBindValueLen = (SmpLengthType) 0;
	bcopy((char *) bind->smpBindName,
	       (char *) orig->smpBindName,
	       (int) orig->smpBindNameLen);
    }
    req.smpRequestId = ++requestId;
    req.smpRequestBinds = retransBindList;
    (void) smpRequest(smp, &req);
    tries = 0;
    return (errOk);
}


SNMPintfc(host)
Host *host;
{   int		addr;
    extern	int	findIPAddr();

    if ((addr = findIPAddr(host)) != 0)
	sndCommand ((u_long) addr, ifTableArgs, intfcUpCall);
    else
	Message("No IP address for SNMP query.\n");
}
/****	????	****/



static	char	*ipAddrTableArgs [ ] = {
	"ipAdEntIfIndex",
	"ipAdEntAddr",
	"ipAdEntNetMask",
	NULL,
};


static  SmpStatusType
ipAddrUpCall (smp, rsp)
SmpIdType               smp;
SmpRequestPtrType       rsp;
{   int			cmp;
    CBytePtrType		bp;
    CIntfType			space;
    SmpIndexType		i;
    SmpBindPtrType		bind;
    SmpBindPtrType		orig;

    /* Our reply ? */
    if ((rsp->smpRequestCmd != smpCommandRsp) ||
	(rsp->smpRequestId != requestId))
    {	return (errOk);
    }

    /* Error? */
    smp = smp;
    if (rsp->smpRequestError != smpErrorNone)
    {	printf("Protocol Error: %s\n", smxErrorToText(rsp->smpRequestError));
	cmdState = Done;
	return (errOk);
    }

    /* Are we out of interfaces? */
    orig = origBindList;
    bind = rsp->smpRequestBinds;
    cmp = 0;
    for (i = rsp->smpRequestCount; (i != 0) &&
	 ((cmp = bcmp((char *) bind->smpBindName,
		      (char *) orig->smpBindName,
		      (int) orig->smpBindNameLen)) == 0); i--)
    {	orig++;
	bind++;
    }
    if (cmp != 0)
    {	cmdState = Done;
	return (errOk);
    }

    if (! cmdBanner)
    {	printf("%3.3s ","Ifc");
	printf("%-15.15s ","Address");
	printf("%-15.15s ","Mask");
	printf("\n");
	cmdBanner = TRUE;
    }
    bind = rsp->smpRequestBinds;
    i = rsp->smpRequestCount;
    printValue(3, bind);
    bind++; i--;
    while (i>0)
    {	printValue(15, bind);
	bind++; i--;
    }
    printf("\n");

    /* Do it again */
    orig = retransBindList;
    bp = retransBuf;
    space = cmdBufferSize;
    bind = rsp->smpRequestBinds;
    i = rsp->smpRequestCount;
    for ( i = rsp->smpRequestCount; (i != 0); i--, orig++, bind++ )
    {	orig->smpBindNameLen = bind->smpBindNameLen;
	orig->smpBindName = (SmpNameType) bp;
	bp += bind->smpBindNameLen;
	space -= bind->smpBindNameLen;
	orig->smpBindKind = smpKindOctetString;
	orig->smpBindValue = (SmpValueType) 0;
	orig->smpBindValueLen = (SmpLengthType) 0;
	bcopy((char *) bind->smpBindName,
	       (char *) orig->smpBindName,
	       (int) orig->smpBindNameLen);
    }
    req.smpRequestId = ++requestId;
    req.smpRequestBinds = retransBindList;
    (void) smpRequest(smp, &req);
    tries = 0;
    return (errOk);
}


SNMPipAddr(host)
Host *host;
{   int		addr;
    extern	int	findIPAddr();

    if ((addr = findIPAddr(host)) != 0)
	sndCommand ((u_long) addr, ipAddrTableArgs, ipAddrUpCall);
    else
	Message("No IP address for SNMP query.\n");
}
/****	????	****/



static	char	*routeTableArgs [ ] = {
    "ipRouteDest",
    "ipRouteType",
    "ipRouteNextHop",
    NULL,
};

static char ipRouteType_codes [] = "?!#= ";
static char *ipRouteType_labels [] = {
    "? -> Illegal value",
    "! -> Unknown type (not in spec)",
    "# -> Invalidated route",
    "= -> Direct connected net",
    "blank -> Remote through router"
    };


static  SmpStatusType
routeUpCall (smp, rsp)
SmpIdType               smp;
SmpRequestPtrType       rsp;
{   int			cmp;
    CBytePtrType		bp;
    CIntfType			space;
    SmpIndexType		i;
    SmpBindPtrType		bind;
    SmpBindPtrType		orig;
    static int column;
    static int type_flags[array_sizeof(ipRouteType_labels)];

    /* Our reply ? */
    if ((rsp->smpRequestCmd != smpCommandRsp) ||
	(rsp->smpRequestId != requestId))
    {	return (errOk);
    }

    /* Error? */
    smp = smp;
    if (rsp->smpRequestError != smpErrorNone)
    {	printf("Protocol Error: %s\n", smxErrorToText(rsp->smpRequestError));
	cmdState = Done;
	return (errOk);
    }

    /* Are we out of interfaces? */
    orig = origBindList;
    bind = rsp->smpRequestBinds;
    cmp = 0;
    for (i = rsp->smpRequestCount; (i != 0) &&
	 ((cmp = bcmp((char *) bind->smpBindName,
		      (char *) orig->smpBindName,
		      (int) orig->smpBindNameLen)) == 0);
	 i--, orig++, bind++)
	;
    if (cmp != 0)
    {	cmdState = Done;
	if (cmdBanner && column!=0) printf("\n");
	for (i=0; i<array_sizeof(ipRouteType_labels); i++)
	    if (type_flags[i])
		printf("%s    ",ipRouteType_labels[i]);
	printf("\n-------- End of routing table --------\n");
	return (errOk);
    }

    if (! cmdBanner)
    {	printf("%-15.15s ", "Destination");
	printf(" %-15.15s ", "Next Hop");
	printf("%5s", "");	/* for gutter */
	printf("%-15.15s ", "Destination");
	printf(" %-15.15s ", "Next Hop");
	printf("%5s", "");	/* for gutter */
	printf("%-15.15s ", "Destination");
	printf(" %-15.15s\n", "Next Hop");
	cmdBanner = TRUE;
	column = 0;
	for (i=0; i<array_sizeof(ipRouteType_labels); i++)
	    type_flags[i] = FALSE;
    }
    bind = rsp->smpRequestBinds;
    i = rsp->smpRequestCount;
    printValue(15, bind);
    bind++; i--;
    if (bind->smpBindKind != smpKindInteger)
	cmp = 0;
    else if ((CUnslType)bind->smpBindNumber>=array_sizeof(ipRouteType_labels))
	cmp = 0;
    else
	cmp = (CUnslType) bind->smpBindNumber;
    type_flags[cmp] = TRUE;
    printf("%c", ipRouteType_codes[cmp]);
    bind++; i--;
    printValue(15, bind);
    bind++; i--;
    if (++column >= 3)
    {	printf("\n");
	column = 0;
    }
    else
	printf("     ");

    /* Do it again */
    orig = retransBindList;
    bp = retransBuf;
    space = cmdBufferSize;
    bind = rsp->smpRequestBinds;
    i = rsp->smpRequestCount;
    for ( i = rsp->smpRequestCount; (i != 0); i--, orig++, bind++ )
    {	orig->smpBindNameLen = bind->smpBindNameLen;
	orig->smpBindName = (SmpNameType) bp;
	bp += bind->smpBindNameLen;
	space -= bind->smpBindNameLen;
	orig->smpBindKind = smpKindOctetString;
	orig->smpBindValue = (SmpValueType) 0;
	orig->smpBindValueLen = (SmpLengthType) 0;
	bcopy((char *) bind->smpBindName,
	       (char *) orig->smpBindName,
	       (int) orig->smpBindNameLen);
    }
    req.smpRequestId = ++requestId;
    req.smpRequestBinds = retransBindList;
    (void) smpRequest(smp, &req);
    tries = 0;
    return (errOk);
}


SNMProute(host)
Host *host;
{   int		addr;
    extern	int	findIPAddr();

    if ((addr = findIPAddr(host)) != 0)
	sndCommand ((u_long) addr, routeTableArgs, routeUpCall);
    else
	Message("No IP address for SNMP query.\n");
}
/****	????	****/



static	char	*neighTableArgs [ ] = {
	"ipRouteType",
	"ipRouteNextHop",
	NULL,
};


static  SmpStatusType
neighUpCall (smp, rsp)
SmpIdType               smp;
SmpRequestPtrType       rsp;
{   int			cmp;
    CBytePtrType		bp;
    CIntfType			space;
    SmpIndexType		i;
    SmpBindPtrType		bind;
    SmpBindPtrType		orig;
    static int idx, t;
    static siz = -1;
    static CUnslType	new_addr;
    static CUnslType	*addrs=NULL;

    /* Our reply ? */
    if ((rsp->smpRequestCmd != smpCommandRsp) ||
	(rsp->smpRequestId != requestId))
    {	return (errOk);
    }

    /* Error? */
    smp = smp;
    if (rsp->smpRequestError != smpErrorNone)
    {	printf("Protocol Error: %s\n", smxErrorToText(rsp->smpRequestError));
	cmdState = Done;
	return (errOk);
    }

    /* Are we out of interfaces? */
    orig = origBindList;
    bind = rsp->smpRequestBinds;
    cmp = 0;
    for (i = rsp->smpRequestCount; (i != 0) &&
	 ((cmp = bcmp((char *) bind->smpBindName,
		      (char *) orig->smpBindName,
		      (int) orig->smpBindNameLen)) == 0);
	 i--, orig++, bind++)
	;
    if (cmp != 0)
    {	cmdState = Done;
	if ( cmdBanner && (idx % 5) != 0 )
	    printf("\n");
	return (errOk);
    }

    if (! cmdBanner)
    {	printf("Neighbor addresses shown in routing table:\n");
	cmdBanner = TRUE;
	idx = 0;
    }
    bind = rsp->smpRequestBinds;
    i = rsp->smpRequestCount;
    if (bind->smpBindKind != smpKindInteger)
    {	fprintf(stderr,"Route type not an integer?\n");
	cmdState = Done;
	if ( cmdBanner && (idx % 5) != 0 )
	    printf("\n");
	return (errOk);
    }
    cmp = (CUnslType) bind->smpBindNumber;
    bind++; i--;
    if (bind->smpBindKind != smpKindIPAddr)
    {	printf("  Not an IP addr?\n");
	cmdState = Done;
	if ( cmdBanner && (idx % 5) != 0 )
	    printf("\n");
	return (errOk);
    }
    if ((CIntfType)bind->smpBindValueLen != 4)
    {	printf("  Not 4 bytes?\n");
	cmdState = Done;
	if ( cmdBanner && (idx % 5) != 0 )
	    printf("\n");
	return (errOk);
    }
    if ( cmp != 3 )
    {	bcopy(bind->smpBindValue, &new_addr, 4);
	if (new_addr!=0)
	{   for (t=idx; --t>=0; )
		if (new_addr == addrs[t]) break;
	    if (t<0)
	    {	struct in_addr ina;
		if ( idx > siz )
		{   if (addrs==NULL)
		    {	siz = 9; /* !!!!MAGIC NUMBER!!!! */
			addrs=(CUnslType *)malloc(siz*sizeof(*addrs));
		    }
		    else
		    {	siz <<= 2;
			addrs=(CUnslType *)realloc(addrs,siz*sizeof(*addrs));
		    }
		    if (addrs==NULL)
		    {	fprintf(stderr,"Allocation error for address table.\n");
			siz = -1;
			cmdState = Done;
			if ( cmdBanner && (idx % 5) != 0 )
			    printf("\n");
			return (errOk);
		    }
		}
		addrs[idx++] = new_addr;
		ina.s_addr = new_addr;
		printf("%-15.15s%s", inet_ntoa(ina),
		       (idx % 5) == 0 ? "\n" : "     ");
		fflush(stdout);
	    }
	}
    }
    bind++; i--;

    /* Do it again */
    orig = retransBindList;
    bp = retransBuf;
    space = cmdBufferSize;
    bind = rsp->smpRequestBinds;
    i = rsp->smpRequestCount;
    for ( i = rsp->smpRequestCount; (i != 0); i--, orig++, bind++ )
    {	orig->smpBindNameLen = bind->smpBindNameLen;
	orig->smpBindName = (SmpNameType) bp;
	bp += bind->smpBindNameLen;
	space -= bind->smpBindNameLen;
	orig->smpBindKind = smpKindOctetString;
	orig->smpBindValue = (SmpValueType) 0;
	orig->smpBindValueLen = (SmpLengthType) 0;
	bcopy((char *) bind->smpBindName,
	       (char *) orig->smpBindName,
	       (int) orig->smpBindNameLen);
    }
    req.smpRequestId = ++requestId;
    req.smpRequestBinds = retransBindList;
    (void) smpRequest(smp, &req);
    tries = 0;
    return (errOk);
}


SNMPneigh(host)
Host *host;
{   int		addr;
    extern	int	findIPAddr();

    if ((addr = findIPAddr(host)) != 0)
	sndCommand ((u_long) addr, neighTableArgs, neighUpCall);
    else
	Message("No IP address for SNMP query.\n");
}
/****	????	****/



static	char	*sysinfTableArgs [ ] = {
	"sysObjectId",
	"sysUpTime",
	"sysDescr",
	"ipForwarding",
	"ifNumber",
	NULL,
};


struct tim_elt {
    int cnt;
    char *nam;
    } tim_tbl [] = {
	100, "centi-seconds",
	60,  "seconds",
	60,  "minutes",
	24,  "hours",
	7,   "days",
	999, "weeks",
    };

char *systyp[] = { "ZERO", "gateway", "host" };


static  SmpStatusType
sysinfUpCall (smp, rsp)
SmpIdType               smp;
SmpRequestPtrType       rsp;
{   SmpIndexType		i;
    SmpBindPtrType		bind;

    /* Our reply ? */
    if ((rsp->smpRequestCmd != smpCommandRsp) ||
	(rsp->smpRequestId != requestId))
    {	return (errOk);
    }

    /* Error? */
    smp = smp;
    if (rsp->smpRequestError != smpErrorNone)
    {	printf("Protocol Error: %s\n", smxErrorToText(rsp->smpRequestError));
	cmdState = Done;
	return (errOk);
    }

    bind = rsp->smpRequestBinds;
    i = rsp->smpRequestCount;
    printf("System type object ID: ");
    if (bind->smpBindKind != smpKindObjectId)
    {	fprintf(stderr,"Sys OID not type OID?\n");
	printValue(0, bind);
    }
    else
	printOid(bind);
    bind++; i--;
    if (bind->smpBindKind != smpKindTimeTicks)
    {	printf("\n----> Can't grok uptime?\n");
	fprintf(stderr,"System uptime was not a TimeTicks type?\n");
    }
    else
    {	int tim = (CUnslType) bind->smpBindNumber;
	int highpart = tim / 100;
	int lowpart = tim - (highpart*100);
	struct tim_elt *tp = tim_tbl;
	while (tim > 2*tp->cnt)
	{   tim = (tim+tp->cnt/2)/tp->cnt;
	    tp++;
	}
	printf(", uptime %d.%02d seconds (around %d %s).\n",
	       highpart, lowpart, tim, tp->nam);
    }
    bind++; i--;
    printf("%*.*s\n", bind->smpBindValueLen, bind->smpBindValueLen,
		      bind->smpBindValue);
    bind++; i--;
    if (bind->smpBindKind != smpKindInteger)
    {	fprintf(stderr,"ipForwarding flag is not an integer?\n");
	printValue(0, bind);
    }
    else if ((CUnslType) bind->smpBindNumber < 1 ||
	     (CUnslType) bind->smpBindNumber >= array_sizeof(systyp) )
    {	fprintf(stderr,"ipForwarding flag is out of range?\n");
	printValue(0, bind);
    }
    else
    {	printf("System is a %s with ",
	       systyp[(CUnslType) bind->smpBindNumber]);
    }
    bind++; i--;
    if (bind->smpBindKind != smpKindInteger)
    {	fprintf(stderr,"Number of interfaces is not an integer?\n");
	printValue(0, bind);
	printf(" interfaces.\n");
    }
    else
    {	printf("%d interfaces (use \"SNMP Interfaces\" command for detail).\n",
	       (CUnslType) bind->smpBindNumber);
    }
    bind++; i--;
    if (i != 0) fprintf(stdout,"There are %d excess values.\n",i);("\n");

    cmdState = Done;
    return (errOk);
}

SNMPsysinf(host)
Host *host;
{   int		addr;
    extern	int	findIPAddr();

    if ((addr = findIPAddr(host)) != 0)
	sndCommand ((u_long) addr, sysinfTableArgs, sysinfUpCall);
    else
	Message("No IP address for SNMP query.\n");
}
/****	????	****/


static	int
alarmHandler (sig, code, scp)
int			sig;
int			code;
struct	sigcontext	*scp;
{   sig = sig;
    code = code;
    scp = scp;
    if (++tries > NBRTRIES)
    {	printf("\n");
	fprintf(stderr, "Request Timed Out\n");
	(void) fflush(stderr);
	cmdState = Done;
    }
    else
    {	if (DBG_SNMP_P) fprintf(stderr,"Timeout...\n");
	cmdState = Timeout;
    }
}

static	int
sndCommand (fhost, argv, rtn)
u_long		fhost;
char		**argv;
SmpStatusType	(*rtn)();
{   int			salen;
    int			result;
    struct	sockaddr	saremote;
    struct	sockaddr_in	*sin;
    struct	sigvec		newSignalVector;

    CByteType			pkt[cmdBufferSize];
    CBytePtrType		bp;
    CBytePtrType		retransBp;
    SmpIndexType		bindCount;
    SmpIdType			smp;
    SmpSocketType		udp;
    SmpBindPtrType		bindp;
    SmpBindPtrType		retransBindp;
    CCharPtrType		cp;
    CBoolType			noerror;
    CIntfType			len;
    CIntfType			space;

    bp = origBuf;
    retransBp = retransBuf;
    space = cmdBufferSize;
    bindp = origBindList;
    retransBindp = retransBindList;
    bindCount = (SmpIndexType) 0;

    for (noerror = TRUE; (noerror) && (*argv != NULL); )
    {	if (bindCount >= cmdBindListSize)
	{   fprintf(stderr, "%s: Too many args\n", Argv[0]);
	    return (FALSE);
	}
	if ((len = parseOid(bp, space, *argv)) < (CIntfType) 0)
	{   noerror = FALSE;
	}
	else
	{   argv++;
	    bcopy(bp,retransBp,len);
	    bindp->smpBindName = (SmpNameType) bp;
	    retransBindp->smpBindName = (SmpNameType) retransBp;
	    bindp->smpBindNameLen = (SmpLengthType) len;
	    retransBindp->smpBindNameLen = (SmpLengthType) len;
	    bp += len;
	    retransBp += len;
	    space -= len;
	    bindp->smpBindKind = smpKindOctetString;
	    retransBindp->smpBindKind = smpKindOctetString;
	    bindp->smpBindValue = (SmpValueType) 0;
	    retransBindp->smpBindValue = (SmpValueType) 0;
	    bindp->smpBindValueLen = (SmpLengthType) 0;
	    retransBindp->smpBindValueLen = (SmpLengthType) 0;
	    bindp++;
	    retransBindp++;
	    bindCount++;
	}
    }

    if (! noerror)
    {	fprintf(stderr, "%s: Error parsing argument %s\n", Argv[0], *argv);
	return (FALSE);
    }

    if (sock < 0)
    {	sock = snmpClientSocket();
    }
    if (sock < 0)
    {	fprintf(stderr, "%s: Can't get socket.\n", Argv[0]);
	return (FALSE);
    }

    req.smpRequestCmd = smpCommandNext;
    req.smpRequestCommunity = communityId;
    req.smpRequestId = ++requestId;
    req.smpRequestError = smpErrorNone;
    req.smpRequestIndex = (SmpIndexType) 0;
    req.smpRequestCount = bindCount;
    req.smpRequestBinds = origBindList;

    currentHost = fhost;
    currentRtn = rtn;

    udp = udpNew(sock, fhost, agentPort);
    smp = smpNew(udp, udpSend, rtn);
    if (smp == (SmpIdType) 0)
    {	fprintf (stderr, "%s: Error creating protocol object\n", Argv[0]);
	udp = udpFree(udp);
	return (FALSE);
    }

    if (smpRequest(smp, & req) != errOk) {
	fprintf(stderr, "%s: Error sending protocol request\n", Argv[0]);
	smp = smpFree(smp);
	udp = udpFree(udp);
	return (FALSE);
    }
    smp = smpFree(smp);

    sin = (struct sockaddr_in *) & saremote;

    if (timeout != (unsigned) 0)
    {	newSignalVector.sv_handler = alarmHandler;
	newSignalVector.sv_mask = 0;
	newSignalVector.sv_flags = SV_INTERRUPT;
	if (sigvec (SIGALRM, & newSignalVector,	(struct sigvec *) 0) == -1)
	{   perror(Argv[0]);
	    udp = udpFree(udp);
	    return (FALSE);
	}
    }

    tries = 0;
    cmdBanner = FALSE;

    do
    {	if (timeout != (unsigned) 0)
	{   (void) alarm(timeout);
	}
	cmdState = Waiting;

	smp = smpNew(udp, udpSend, rtn);
	if (smp == (SmpIdType) 0)
	{   fprintf(stderr, "%s: Error creating protocol object\n", Argv[0]);
	    udp = udpFree(udp);
	    return (FALSE);
	}

	salen = sizeof(saremote);
	result = recvfrom(sock, (char *) pkt, (int) cmdBufferSize,
			  (int) 0, & saremote, & salen);
	if (cmdState == Timeout)
	{   if (DBG_SNMP_P) fprintf(stderr,"Retransmitting...\n");
	    if (smpRequest(smp, & req) != errOk)
		fprintf(stderr,
			"%s: Error sending protocol request\n", Argv[0]);
	    (void) alarm(timeout);
	}
	else
	    for (bp = pkt; ((result > 0) && (smpInput(smp,*bp++) == errOk)); )
		result--;

	smp = smpFree(smp);

    } while ((result >= 0 || errno == EINTR) && (cmdState != Done));

    alarm(0);
    udp = udpFree(udp);
    if (result < 0)
    {	close(sock);
	sock = -1;
    }
    return (TRUE);
}
