{TUG PDS CERT 1.01 (Pascal)

==========================================================================

                  TUG PUBLIC DOMAIN SOFTWARE CERTIFICATION

The Turbo User Group (TUG) is recognized by Borland International as the
official support organization for Turbo languages.  This file has been
compiled and verified by the TUG library staff.  We are reasonably certain
that the information contained in this file is public domain material, but
it is also subject to any restrictions applied by its author.

This diskette contains PROGRAMS and/or DATA determined to be in the PUBLIC
DOMAIN, provided as a service of TUG for the use of its members.  The
Turbo User Group will not be liable for any damages, including any lost
profits, lost savings or other incidental or consequential damages arising
out of the use of or inability to use the contents, even if TUG has been
advised of the possibility of such damages, or for any claim by any
other party.

To the best of our knowledge, the routines in this file compile and function
properly in accordance with the information described below.

If you discover an error in this file, we would appreciate it if you would
report it to us.  To report bugs, or to request information on membership
in TUG, please contact us at:

             Turbo User Group
             PO Box 1510
             Poulsbo, Washington USA  98370

--------------------------------------------------------------------------
                       F i l e    I n f o r m a t i o n

* DESCRIPTION
Demonstration program for TPPICK and TPDIR units.

* ASSOCIATED FILES
TPDIR.PAS
DEMO1.PAS
DEMO1.EXE
TPDIR.TPU
TPPICK.PAS
TPPICK.TPU

* CHECKED BY
DRM - 08/14/88

* KEYWORDS
TURBO PASCAL V4.0 PROGRAM DIRECTORY DEMO MENU

==========================================================================
}
{
Demonstration program for TPPick and TPDir units.

This program requires the use of units from the commercial product Turbo
Professional 4.0, by TurboPower Software. It demonstrates two new units,
supplied here. The TPPick unit offers general-purpose scrolling "pick"
windows, which allow the user to scroll though a list of strings and select
one to return to the calling program. The TPDir unit offers a popup directory
unit, useful wherever user entry of filenames is required.

Copyright (c) 1987 by TurboPower Software. May be freely used by and
distributed to owners of Turbo Professional 4.0.

Turbo Professional 4.0 is a library of 400 general purpose procedures and
functions especially optimized for Turbo Pascal 4.0. It costs $99 and includes
complete source code and a 450 page manual. Contact TurboPower Software at
408-438-8608 or on Compuserve [72457,2131] for more information.
}

{$R-,S-,I-,V-}

program Demo;
  {-Demonstrate TPPick and TPDir units}
uses
  Dos,
  TPString,
  TPCrt,
  TPWindow,
  TPPick,
  TPDir;
var
  Mask, Fname : string;
begin
  {Override default position of the pick window}
  if CurrentWidth < 80 then
    TPDir.XLow := 1
  else
    TPDir.XLow := 15;
  TPDir.YHigh := CurrentHeight;

  WriteLn('Press Ctrl-Break to quit');

  repeat
    Write('Enter a filename mask: ');
    ReadLn(Mask);
    case GetFileName(Mask, Fname) of
      0 : WriteLn('Got filename=', Fname);
      1 : WriteLn('Path not found');
      2 : WriteLn('No matching files');
      3 : WriteLn('Unsupported video mode');
      4 : WriteLn('Insufficient memory');
    else
      WriteLn('Dos critical error');
    end;
  until False;
end.
