(*-------------------------------------------------------------------------*)
(*                 SigF  -- Significance of F distribution                 *)
(*-------------------------------------------------------------------------*)

FUNCTION SigF( F , Dfn , Dfd : REAL ) : REAL;

(*-------------------------------------------------------------------------*)
(*                                                                         *)
(*       Function:  SigF                                                   *)
(*                                                                         *)
(*       Purpose:   Evaluates F distribution probability                   *)
(*                                                                         *)
(*       Calling Sequence:                                                 *)
(*                                                                         *)
(*            P     := SigF( F , Dfn , Dfd );                              *)
(*                                                                         *)
(*                 F      --- F-value                                      *)
(*                 Dfn    --- Numerator degrees of freedom                 *)
(*                 Dfd    --- Denominator degrees of freedom               *)
(*                                                                         *)
(*                 P      --- Resultant probability                        *)
(*                                                                         *)
(*       Calls:                                                            *)
(*                                                                         *)
(*            CdBeta                                                       *)
(*                                                                         *)
(*       Method:                                                           *)
(*                                                                         *)
(*            The input values are transformed to match the                *)
(*            requirements of the Beta distribution.  Function CDBeta      *)
(*            provides the corresponding cumulative Beta distribution      *)
(*            probability.                                                 *)
(*                                                                         *)
(*            An error in the input arguments results in a returned        *)
(*            probability of -1.                                           *)
(*                                                                         *)
(*-------------------------------------------------------------------------*)

CONST
   Dprec   = 12;
   MaxIter = 200;

VAR
   Iter:   INTEGER;
   Cprec:  REAL;
   Ifault: INTEGER;
   Pval:   REAL;

BEGIN (* SigF *)

   Pval := -1.0;

   IF ( Dfn > 0.0 ) AND ( Dfd > 0.0 ) THEN
      BEGIN
         Pval := CDBeta( Dfd / ( Dfd + F * Dfn ), Dfd / 2.0, Dfn / 2.0,
                         Dprec, MaxIter, Cprec, Iter, Ifault );
         IF Ifault <> 0 THEN Pval := -1.0;
      END;

   SigF := Pval;

END   (* SigF *);
