rem : Module     - xphysical_day_gen.bat
rem : Updated    - 07/19/2004
rem :              Uses extended ssxphysical utility which does not require
rem                a preceding ss physical -> physical.txt run to provide input.
rem : Purpose    - Generate a Sourcesafe physical-logical file concordance.

rem : Run From   - c:\Program Files\Microsoft Visual Studio\Common\Vss\Utilities
rem                (Create as peer of ....\Vss\Win32 directory)

rem : Parameters  NOTE! Full path parameters MUST be quoted strings!
rem : - %1 Drive letter of drive containing the ...\vss\data directory e.g: X
rem        Not used. Enter a dummy parameter e.g null
rem : - %2 Full path to data directory e.g: X:\....\vss\data
rem        Not used. Enter a dummy parameter e.g null
rem : - %3 Drive letter of drive containing ...\Common\vss\win32 directory e.g.: C
rem : - %4 Full path to the vss install directory e.g.: c:\Program Files\...\Common\vss
rem : - %5 Configuration engineer email name

rem : Outputs    - ssutility.log : record of utility processing.

rem : Pre-Req #1 - Program ssxphysical.exe must be in the Utilities directory.

rem -------------------------------------------------------------------------

rem : diagnostics
echo parm1=[%1]
echo parm2=[%2]
echo parm3=[%4]
echo parm4=[%5]
echo parm5=[%5]

rem : Remove quotes from parameter 4
set ssparm4=%4
set ssparm4=%ssparm4:"=%
set ssparm4=%ssparm4:"=%

rem : switch to the vss program drive utility directory
%3%:
cd "%ssparm4%\Utilities"

:Genday
rem : Generate sourcesafe physical-logical project-file concordance
rem : OUTPUTS physical.day (Mon-Sun) and physical.tot

net send %5% xphysical_day_gen.bat : executing ssxphysical.exe
echo exit|cmd /q /k prompt $D $T xphysical_gen_day.bat : ssxphysical custom utility started. >> ssutility.log

ssxphysical.exe
rem Report exit code from ssxphysical
echo off
FOR %%E IN (0,1,2) DO IF ERRORLEVEL %%E00 SET ERLVL=%%E
IF "%ERLVL%"=="0" SET ERLVL=
SET RANGE=0,1,2,3,4,5,6,7,8,9
IF "%ERLVL%"=="2" SET RANGE=0,1,2,3,4,5
FOR %%E IN (%RANGE%) DO IF ERRORLEVEL %ERLVL%%%E0 SET ERLVL=%ERLVL%%%E
IF "%ERLVL%"=="0" SET ERLVL=
IF NOT "%ERLVL%"=="25" SET RANGE=0,1,2,3,4,5,6,7,8,9
FOR %%E IN (%RANGE%) DO IF ERRORLEVEL %ERLVL%%%E SET ERLVL=%ERLVL%%%E
SET RANGE=

net send %5% xphysical_day_gen.bat : ssxphysical exit code = %ERLVL%.
echo exit|cmd /q /k prompt $D $T xphysical_day_gen.bat : ssxphysical exit code = %ERLVL% >> ssutility.log

if ERRORLEVEL 0 if not ERRORLEVEL 1 goto Ok

net send %5% SourceSafe xphysical_gen_day.bat : ssxphysical completed with errors
echo exit|cmd /q /k prompt $D $T xphysical_gen_day.bat : sssphysical completed with errors. >> ssutility.log
goto End

:Ok
net send %5% xphysical_day_gen.bat : ssxphysical completed Ok.
echo exit|cmd /q /k prompt $D $T physical_gen_day.bat : ssxphysical completed Ok. >> ssutility.log

:End
net send %5% xphysical_gen_day.bat completed.
echo exit|cmd /q /k prompt $D $T xphysical_gen_day.bat : ended. >> ssutility.log

rem exit
