/* CDDRIVE.H - Programmed by Maarten Hofman */
/* 120793: Started programming */
/* 130793: Continued programming */

#define NO_ERROR				-1
#define WRITE_PROTECT_VIOLATION			0
#define UNKNOWN_UNIT			  	1
#define DRIVE_NOT_READY				2
#define UNKNOWN_COMMAND				3
#define CRC_ERROR				4
#define BAD_DRIVE_REQUEST_STRUCTURE_LENGTH	5
#define SEEK_ERROR				6
#define UNKNOWN_MEDIA				7
#define SECTOR_NOT_FOUND			8
#define PRINTER_OUT_OF_PAPER			9
#define WRITE_FAULT				10
#define READ_FAULT				11
#define GENERAL_FAILURE				12
#define INVALID_DISK_CHANGE			15

#define DOOR_OPEN		1
#define DOOR_UNLOCKED		2
#define SUPPORTS_RAW		4
#define SUPPORTS_WRITE		8
#define SUPPORTS_AUDIO_PLAY	16
#define SUPPORTS_INTERLEAVING	32
#define SUPPORTS_PREFETCHING	128
#define SUPPORTS_AUDIO_CHANNELS	256
#define	SUPPORTS_RED_BOOK	512

#define MEDIA_UNKNOWN	0
#define MEDIA_UNCHANGED	1
#define MEDIA_CHANGED	255

#define LOWEST_TRACK	1
#define HIGHEST_TRACK	2

#define CONTROL_ADR	0
#define TRACK_NUMBER	1
#define POINT_INDEX	2
#define RUN_MINUTES	3
#define RUN_SECONDS	4
#define RUN_FRAME	5
#define DISK_MINUTES	7
#define DISK_SECONDS	8
#define DISK_FRAME	9

#define DISK_RUNNING	0
#define DISK_PAUSED	1

#define LEAD_OUT_TRACK		-1
#define STARTING_LOCATION	-2
#define ENDING_LOCATION		-3

#define INPUT_CHANNEL_0		0
#define VOLUME_CHANNEL_0	1
#define INPUT_CHANNEL_1		2
#define VOLUME_CHANNEL_1	3
#define INPUT_CHANNEL_2		4
#define VOLUME_CHANNEL_2	5
#define INPUT_CHANNEL_3		6
#define VOLUME_CHANNEL_3	7

#define READ	3
#define WRITE	12
#define STOP	133
#define RESUME	136

struct ioctl {
  unsigned char mdb;
  unsigned char *transfer;
  unsigned int size;
  unsigned char ssn;
  void *rvi;
};

struct audio {
  unsigned char am;
  long int start;
  long int stop;
};

union extra {
  struct ioctl ioctl;
  struct audio audio;
};

struct request {
  unsigned char length;
  unsigned char subunit;
  unsigned char command;
  unsigned int status;
  unsigned char reserved[8];
  union extra extra;
};

void eject_disk(int drive);
void reset_drive(int drive);
void close_tray(int drive);
void stop_audio(int drive);
void resume_audio(int drive);
void lock_unlock_door(int drive,int door);
void play_audio(int drive,long int start,long int stop);
void audio_channel_control(int drive,int what,int setting);
extern int query_error(void);
extern int query_busy(void);
extern int query_done(void);
extern int device_status(int drive);
extern int media_changed(int drive);
extern int audio_status_info(int drive);
extern int audio_disk_info(int drive,int track);
extern int audio_track_info(int drive,int track);
extern long int redbook_to_hsg(long int redbook);
extern long int get_track_address(int drive,int track);
extern unsigned char *audio_qchannel_info(int drive);
extern unsigned char *get_upccode(int drive);
extern unsigned char *audio_channel_info(int drive);
