;===========================================================
; PROGRAM LABEL  Version 1.10 (1983)
;
;        by David Whitman
;
; Adds or replaces DOS 2.0 volume labels on already
; formatted disks.  Will overwrite an existing label.
; The syntax is:
;
;   LABEL [d:]
;
; If no drive is specified, the default drive is assumed.
;
; LABEL will prompt for the text desired as a volume label.
; A maximum of 11 characters are allowed.
;
; Requires DOS 2.0, will abort under earlier versions.
; The program will also abort if the specfied disk is
; formatted with 8 sectors/track.
;
; This source file is written for the
; syntax of the CHASM assembler.
;============================================================
; HELP!
; The author was unable to find a way to safely
; erase existing volume labels.  The following
; methods were tried:
;
;        Technique                      Result
;  Delete with DOS call 0AH    Trashed file allocation table
;  Rename to begin with E5H    High bit turned off, label begins with 'E'
;  Rename to all blanks        Rename failed - no change in label
;
; It would be nice to have this capability.  Any suggestions?
;=============================================================
;
;===============
; Equates
;===============
;
@getver   equ  30H      ;Get DOS version number
@getfsp   equ  36H      ;Get disk free space
@create   equ  16H      ;Create file
@bufinp   equ  0AH      ;Buffered keyboard input
@prnstr   equ  09H      ;Print string
@close    equ  10H      ;close file
@rename   equ  17H      ;rename file
;
cr        equ  0DH      ;carriage return
lf        equ  0AH      ;line feed
beep      equ  07H      ;bell (makes a beep sound when printed)

drvnbr    equ  [5CH]    ;drive number for first parameter

;=============
; Print title
;=============
       mov     drvok, al            ;save validity of drive
       mov     dx, offset(title)    ;title message
       mov     ah, @prnstr          ;print
       int     21H                  ;with dos call

       cmpb    drvok, 0FFH          ;was the drive valid?
       jne     doschk               ;yes, continue
       mov     dx, offset(baddrv)   ;no, bitch
       mov     ah, @prnstr          ;print message
       int     21H                  ;with dos call
       jmps    exit                 ;and exit

doschk mov     ah, @getver          ;what dos are we under?
       int     21H
       cmp     al, 00H              ;earlier than 2.0?
       jne     setdrv               ;no
       mov     dx, offset(baddos)   ;yes: bitch
       mov     ah, @prnstr          ;print message
       int     21H                  ;with dos call
       jmps    exit                 ;and exit

setdrv mov     dl, drvnbr           ;get drive number
       mov     drvnbr1, dl          ;and put it in both
       mov     drvnbr2, dl          ;extended FCBs

;=============================================================
;we can tell what format the disk is in by examining the total
;number of clusters available.  The following numbers apply:
;
;  162H = 2 sides, 9 tracks    15FH = 1 side, 9 tracks
;  13BH = 2 sides, 8 tracks    139H = 1 side, 8 tracks
;=============================================================
                                    ;dl already has drive number
chkdsk mov     ah, @getfsp          ;get disk info
       int     21H                  ;with dos call
       cmp     dx, 13BH             ;how many clusters?
       jg      input                ;more than 8 sectors, ok
       mov     dx, offset(baddsk)   ;8 sectors? bitch
       mov     ah, @prnstr          ;print message
       int     21H                  ;with dos call
       jmps    exit                 ;and quit

;=========================================
; Prompt for and input the new label text.
;=========================================
input  mov     dx, offset(prompt)   ;point to prompt message
       mov     ah, @prnstr          ;print prompt
       int     21H                  ;with dos call
       mov     dx, offset(buffer)   ;point to buffer
       mov     ah, @bufinp          ;call for buffered input
       int     21H                  ;with dos call

;=========================
; Create the volume label.
;=========================
write  mov     si, offset(buftxt)   ;input buffer
       mov     di, offset(newname)  ;rename field
       sub     cx,cx                ;zero cx
       mov     cl, numchr           ;number of input chars
       rep                          ;move'em into FCB rename field
       movsb
       mov     dx, offset(xfcb2)    ;try to rename
       mov     ah, @rename          ;with dos call
       int     21H
       cmp     al, 00H              ;was rename sucess?
       je      exit                 ;yes, exit

       mov     si, offset(buftxt)   ;otherwise create new label
       mov     di, offset(name1)    ;move text into fcb
       sub     cx, cx               ;as above
       mov     cl, numchr
       rep
       movsb
       mov     dx, offset(xfcb)     ;and create label
       mov     ah, @create          ;with dos call
       int     21H

exit   mov     dx, offset(crlf)     ;start new line
       mov     ah, @prnstr
       int     21H
       int     20H                  ;and get out of here

;=======================
; Input buffer
;=======================
buffer db      0CH        ;can hold 12 chars (including a CR)
numchr db      00H        ;number of characters inputted
buftxt ds      12, ' '    ;initial text is twelve spaces

drvok  db      00H        ;holds entry al value - drive validity

;=======================
;File control blocks
;=======================
xfcb    db 0FFH, 0,0,0,0,0
attrib  db 08H                   ;volume label attribute
drvnbr1 db 00H                   ;drive number
name1   db '        '            ;name
        db '   '                 ;extension
        ds 25                    ;rest of fcb

xfcb2   db 0FFH, 0,0,0,0,0
attrib2 db 08H                   ;volume label attribute
drvnbr2 db 00H                   ;drive number
        db '????????'            ;name
        db '???'                 ;extension
        ds 5                     ;first 5 'reserved' bytes
newname db '        '            ;rename field
        db '   '                 ;new extension
        ds 9                     ;rest of fcb

;==========
;Messages
;==========
title  db  cr,lf 'LABEL Version 1.1 - 1983 by D. Whitman' cr,lf '$'
prompt db  'Volume label (11 characters maximum): $'
baddrv db  beep,cr,lf 'Invalid drive specification!' cr, lf, '$'
baddos db  beep,cr,lf 'This utility only works under DOS 2.0!' cr, lf, '$'
baddsk db  beep,cr,lf 'Volume labels not allowed on 8 track disks!' cr, lf, '$'
crlf   db  cr, lf, '$'
