;----------------------------------------------------------------------------:
; STRUCTS.INC																 :
;																			 :
; Global data structures for CPCC											 :
; (C) John Connors 1993 													 :
;----------------------------------------------------------------------------:

;----------------------------------------------------------------------------:
; The header of a .PCX or .PCC file 										 :
;----------------------------------------------------------------------------:

STRUC	PCX_Header
	Id						db	?
	Version 				db	?
	Encoding_Mode			db	?
	Bits_per_Pixel			db	?
	X1						dw	?
	Y1						dw	?
	X2						dw	?
	Y2						dw	?
	Horizontal_Resolution	dw	?
	Vertical_Resolution 	dw	?
	Colour_Map				db	48	dup (?)
	Not_Used				db	?
	Number_Of_Planes		db	?
	Bits_per_Plane_Line 	dw	?
	Palette_Information 	dw	?
							dw	?
							dw	?
	Extra					db	54	dup (?)
ENDS	PCX_Header

;----------------------------------------------------------------------------:
; A Colour Look up Table, or Palette!										 :
;----------------------------------------------------------------------------:


STRUC	PCX_CLUT
	Colour_Information		db	3 dup (256 dup (?))
ENDS	PCX_CLUT



