 
		.286
		IDEAL
		LOCALS
		MODEL	HUGE,C


		CODESEG

		PUBLIC	fix_odd_width_bug
		PUBLIC	separate_sprite_plane	    

;----------------------------------------------------------------------------:
; fix_odd_width_bug(&lbm_buffer)											 :
; fixes lbm buffer so that it is without the padding provided by a			 :
; bizzare deluxe pain feature												 :
;----------------------------------------------------------------------------:


PROC	fix_odd_width_bug
		ARG 	lbm_buffer:DATAPTR
		LOCAL	image_width:WORD,image_height:WORD
		USES	ES,DI,DS,SI
	    
		LES 	DI,[lbm_buffer]
		LDS 	SI,[lbm_buffer]

		MOV 	BX,[SI] 						; prepare dimensions for 
		MOV 	CX,[SI+2]						; looping
		INC 	BX
		INC 	CX
		MOV 	[image_width],BX
		MOV 	[image_height],CX
	    
		ADD 	DI,4							; point to start of lbm 
		ADD 	SI,4							; data
	    
		MOV 	CX,[image_height]
@@next_row:
		PUSH	CX
		MOV 	CX,[image_width]
		REP 	MOVSB							; copy a row
		INC 	SI								; bump past padding
		POP 	CX
		LOOP	SHORT @@next_row
		RET
	    
ENDP	fix_odd_width_bug

;----------------------------------------------------------------------------:
; Seperate_Sprite_Planes													 :
; Assumes that a PCC file has been read in and decoded into Screen_Buffer	 :
; Reads screen buffer into the image buffer plane by plane so that it may	 :
; quickly be read/written													 :
; unsigned int separate_sprite_planes(source_buffer, desination_buffer, 	 :
;	plane_n):																 :
; Returns width of plane in bytes											 :
;----------------------------------------------------------------------------:

PROC	separate_sprite_plane
		USES	BX,CX,DX,SI,DI,ES,DS
	    
		ARG 	Source:DATAPTR,Destination:DATAPTR,Plane:WORD
	    
		LOCAL	Bytes_In_Plane_Row:WORD
		LOCAL	Image_Width:WORD, Image_Height:WORD

		LDS 	SI,[Source]
		MOV 	AX,[SI]
		INC 	AX
		MOV 	[Image_Width],AX
		MOV 	AX,[SI+2]
		INC 	AX
		MOV 	[Image_Height],AX
		ADD 	SI,4
		ADD 	SI,[Plane]
			    
		LES 	DI,[Destination]				; set up destination pointer
	    
		;
		; work out # of bytes in this plane
		;
		MOV 	CX,4
		SUB 	CX,[Plane]						; four planes
		; for each plane
@@Next_Plane:	    
		; work out # bytes in plane?
		MOV 	BX,[Image_Width]
		ADD 	BX,CX
		DEC 	BX
		SHR 	BX,2
		MOV 	[Bytes_In_Plane_Row],BX
		MOV 	CX,[Image_Height]
		 ; for each row
@@Next_Row:
		PUSH	CX
		MOV 	CX,[Bytes_In_Plane_Row]
		PUSH	DI								; save start of dest row
		PUSH	SI								; save start of sauce row
		; for each byte
@@Next_Byte:
		; copy byte from sauce row to destination plane
		MOVSB 
		ADD 	SI,3							; next sauce byte in plane
		  ; next byte
		LOOP	@@Next_Byte
		 ; next row
		POP 	SI								; bump sauce to next image row
		ADD 	SI,[Image_Width]
		TEST	[Image_Width],1
		JZ		SHORT @@Not_Odd_Width
		INC 	SI
@@Not_Odd_Width:
		POP 	DI
		ADD 	DI,[Bytes_In_Plane_Row]
		POP 	CX
		LOOP	@@Next_Row 
		; next plane
    
		MOV 	AX,[Bytes_In_Plane_Row]
						    
		RET     
ENDP	separate_sprite_plane


		END
