/*
                            WGT VESA Include File                       
  */


#define VIDEO          0x10             /* Video interrupt is #16 */

#define V640x400       0x100            /* Mode 256 is 640x400x256 */
#define V640x480       0x101            /* Mode 257 is 640x480x256 */
#define V800x600       0x103            /* Mode 259 is 800x600x256 */
#define V1024x768      0x105            /* Mode 261 is 1024x768x256 */
#define V1280x1024     0x107            /* Mode 263 is 1280x1024x256 */

/***************************************************************************
 The following structure is the VESA information structure returned by the
 VESA-detection interrupt. If a driver is detected, this structure is filled
 with information regarding the system.
***************************************************************************/

typedef struct {
  unsigned char  VESASignature[4];  /* Should be "VESA" */
  unsigned int   VESAVersion;       /* Version # of driver */
  unsigned char  *OEMStringPtr;     /* Pointer to video card info string */
  unsigned char  Capabilities[4];   /* Bit field of video capabilities */
  unsigned int   *VideoModePtr;     /* Pointer to list of supported modes */
  unsigned char  filler[256-18];    /* Structure must be 256 bytes */
} VGAInfoBlock;



/***************************************************************************
 The following structure is an information structure returned by the
 Return SVGA Mode Info interrupt. If the requested mode is supported, its
 specifications are placed into this structure.
***************************************************************************/

typedef struct {
  unsigned int   ModeAttributes;        /* Bit field */
  unsigned char  WinAAttributes;        /* Bit field */
  unsigned char  WinBAttributes;        /* Bit field */
  unsigned int   WinGranularity;        /* Kb boundary on which window can
                                           be placed in video memory */
  unsigned int   WinSize;               /* Size of window in Kb */
  unsigned int   WinASegment;           /* Segment address of window */
  unsigned int   WinBSegment;           /* Segment address of window */
  unsigned long  WindFuncPtr;           /* Pointer to CPU windowing 
                                           function*/
  unsigned int   BytesPerScanLine;      /* Number of bytes in one scan
                                           line */
  /* Optional information */
  /* Following information is set by some cards, but not all. */
  unsigned int   XResolution;           /* Width of video mode in pixels */
  unsigned int   YResolution;           /* Height of video mode in pixels */
  unsigned char  XCharSize;             /* Size of character cell in pixels */
  unsigned char  YCharSize;             /* Same */
  unsigned char  NumberOfPlanes;        /* # of planes in this mode */
  unsigned char  BitsPerPixel;          /* # of bits defining a pixel */
  unsigned char  NumberOfBanks;         /* # of banks in which scan lines are 
                                           grouped (1 if VGA modes 0Dh-13h) */
  unsigned char  MemoryModel;           /* Memory organization used */
  unsigned char  BankSize;              /* Size of bank in Kb */
  unsigned char  filler[256-29];        /* Structure must be 256 bytes */
} ModeInfoBlock;

extern VGAInfoBlock    VGA;              /* VESA structure is declared as global */
extern ModeInfoBlock   VESAmode;         /* Same with the mode info structure */
extern long	       VESAbanksize;	 /* Size of one video bank in kbytes */

/*
                            Function Protocols                          
  */
int  wvesa_detected(void);       // Returns 1 if SVGA support is detected
int  wvesa_supported(int mode);  // Returns 1 if requested mode is supported
int  wvesa_getmodeinfo (int mode);// Fills mode info structure for given mode
int  wvesa_init(int mode);       // Initializes SVGA graphics mode
int  wvesa_bank(int bank);         // Switch to a given bank in video memory

void memcpyx(block dst, block src, unsigned size);    /* Needed for x-ray */


/* Supported primitives and graphics functions */

void wvesa_clip (int x, int y, int x2, int y2);
void wvesa_cls (int color);
void wvesa_putpixel (int x, int y);
int  wvesa_getpixel (int x, int y);
void wvesa_line (int x, int y, int x2, int y2);
void wvesa_hline (int x, int y, int x2);
void wvesa_bar (int x, int y, int x2, int y2);
void wvesa_rectangle (int x, int y, int x2, int y2);
void wvesa_copyscreen (int sx, int sy, int sx2, int sy2, block src,
                      int dx, int dy, int method);
void wvesa_putblock (int dx, int dy, block src, int method);
void wvesa_outtextxy (int x, int y, wgtfont fnt , char *printit);
int  wvesa_outchar (int asc, int xc, int yc, wgtfont pr);
/**/

