/* 
   WordUp Graphics Toolkit V4.0  Multidirectional Scrolling Library
   Copyright 1994 Chris Egerter
*/

#ifdef __cplusplus
extern "C" {
#endif

#define NORMAL 0
#define PARALLAX 1
#define MAXWINDOWS 4

extern int wemstiles;   /* Tells if tiles and objects are stored in EMS */
extern int wemsobjects;
extern int wemsscroll;

extern int currentwindow;
extern int numwindows;

extern block scroll1[MAXWINDOWS],scroll2[MAXWINDOWS];
extern int windowminx[MAXWINDOWS],windowminy[MAXWINDOWS],windowmaxx[MAXWINDOWS],windowmaxy[MAXWINDOWS];
extern int worldx[MAXWINDOWS],worldy[MAXWINDOWS];
extern int worldmaxx[MAXWINDOWS],worldmaxy[MAXWINDOWS];
extern int mapwidth[MAXWINDOWS],mapheight[MAXWINDOWS];
extern int tilewidth[MAXWINDOWS],tileheight[MAXWINDOWS];
extern int windowwidth[MAXWINDOWS],windowheight[MAXWINDOWS];    /* Size of window (in tiles) */

typedef struct {
	char on;
	int x;
	int y;
	unsigned int num;
	} scrollsprite;

int      is_in_window(int curwindow, int x, int y, int range);
int      soverlap(int s1, scrollsprite *wobjects1, block *sprites1,
                  int s2, scrollsprite *wobjects2, block *sprites2);
void     wcopyscroll(int currentwindow, int x, int y);
void     wendscroll(int currentwindow);
void     wfreemap(wgtmap mapname);
int      wgetworldblock(int currentwindow, int posx, int posy);
unsigned char wgetworldpixel(int currentwindow, int x, int y);
void     winitscroll (int currentwindow, int mode, int link, int xwidth,
                      int ywidth, block *tileref);
wgtmap   wloadmap(int currentwindow, char *filename, int *tiletypes,
                  scrollsprite *wobjects);
void     wputworldblock(int currentwindow, int posx, int posy, int tilenum);
void     wsavemap(int currentwindow, char *filename, wgtmap savemap, 
                  int *tiletypes, scrollsprite *wobjects, int numobj);
void     wscrollwindow(int currentwindow, int wspeedx, int wspeedy);
void     wshowobjects(int currentwindow, int start, int end, block *sprites,
                      scrollsprite *wobjects);
void     wshowwindow(int currentwindow, int posx, int posy);
int	 wscreen_coordx (int currentwindow, int xcoord);
int	 wscreen_coordy (int currentwindow, int ycoord);
void	 wcopymap (int source, int dest);

#ifdef __cplusplus
}
#endif
