/*
ͻ
                     WordUp Graphics Toolkit Version 4.0                    
                            Demonstration Program 57                        
                                                                            
 This program uses the scrolling library to demonstrate some of the         
 possible configurations of the scrolling windows.                          
 It also shows how to use EMS with the scrolling library.                   
                                                                            
  PROJECT                                                             
 This program requires the files WGT4.LIB and WGTSCROL.LIB to be linked.    
                                                                            
  DATA FILES                                                          
 PARABACK.SPR, PARAFRON.SPR, PARASPR.SPR, PARAMAPB.WMP, PARAMAPF.WMP        
                                                                            
ͼ
*/

#include <dos.h>
#include <wgt4.h>
#include <wgtscrol.h>


/* Keyboard control codes */
#define LEFT 75
#define RIGHT 77
#define UP 72
#define DOWN 80
#define ESC 1

#define NUM_TILES 5

block tiles0[NUM_TILES+1];	/* 4 block array to hold our sets of tiles */
block tiles1[NUM_TILES+1];
block tiles2[NUM_TILES+1];
block tiles3[NUM_TILES+1];

int tiletypes0[256];		/* Tile types for each window */
int tiletypes1[256];
int tiletypes2[256];
int tiletypes3[256];

scrollsprite wobject[5];	/* No objects are used in this demo, but a
				   scrollsprite structure is needed to load
				   the map. */

int window_on[4];
block sprites[5];
block emsblock;
wgtmap map0,map1,map2,map3;

int setup;

int oldmode;		/* Previous graphics mode */
int useEMS; 		/* EMS flag on/off */
color pal[256];  	/* A common palette for all sprites/tiles */
int xsize[4],ysize[4];  /* The size of the tiles in our map */
char c;
int movex,movey;

void loadsprites (void);
void loadmaps (void);
void find_tile_sizes (void);
void start_scroll (void);
void close_files (void);
block get_tile (int num, block *tiles);

void main (void)
{
 oldmode = wgetmode ();

 printf ("WGT v4.0  Scrolling Possibilities Demo\n");
 printf ("This demo is meant to show the versatility of WGT's scrolling\n");
 printf ("library.  It does not show all of the possible scrolling combinations\n");
 printf ("but it gives you some setups that you can base a game around.\n\n");
 printf ("Choose your scrolling setup:\n\n");
 printf ("[0] 4 windows\n");
 printf ("[1] 1 window, 1 scrolling level\n");
 printf ("[2] 1 window, 2 scrolling levels\n");
 printf ("[3] 1 window, 3 scrolling levels\n");
 printf ("[4] 1 window, 4 scrolling levels\n");
 printf ("[5] 2 windows, 1 scrolling level, vertical\n");
 printf ("[6] 2 windows, 2 scrolling levels, vertical\n");
 printf ("[7] 2 windows, 1 scrolling level, horizontal\n");
 printf ("[8] 2 windows, 2 scrolling levels, horizontal\n");
 printf ("[9] 2 windows, 1 with 3 levels, the other with 1 level\n");

 printf ("Enter your setup:");
 scanf ("%i", &setup);

 vga256 ();

 useEMS = wems_present ();
 printf("EMS present: %i\n", useEMS);

 if (useEMS)
  {
   printf ("EMS init: %i\n", wems_init ());
   printf ("EMS page frame: %p\n", emsptr);
   printf ("EMS open: %i\n", wems_open (7*4));
   printf ("EMS handle: %Np\n", emshandle);
   delay (1000);
   wemsscroll = 1;
  }

 loadsprites ();
 find_tile_sizes ();

 start_scroll ();
 loadmaps ();

 installkbd ();
 do 
  {
   movex = 0;
   movey = 0;

   if (kbdon[UP]) 
       movey = -16;
   if (kbdon[DOWN])
       movey = 16;
   if (kbdon[LEFT])
       movex = -16;
   if (kbdon[RIGHT])
       movex = 16;

   if (window_on[0])
       wscrollwindow (0, movex * 1 / 4, movey * 1 / 4);
   if (window_on[1])
       wscrollwindow (1, movex * 2 / 4, movey * 2 / 4);
   if (window_on[2])
       wscrollwindow (2, movex * 3 / 4, movey * 3 / 4);
   if (window_on[3])
       wscrollwindow (3, movex, movey);

   wretrace ();
   switch (setup)
    {
     case 0: wcopyscroll (0, 0, 0);
	     wcopyscroll (1, 128, 0);
	     wcopyscroll (2, 0, 100);
	     wcopyscroll (3, 128, 100); break;
     case 1:
     case 2:
     case 3:
     case 4: wcopyscroll (0, 0, 0); break;
     case 5:
     case 6: wcopyscroll (0, 0, 0);
	     wcopyscroll (1, 128, 0); break;
     case 7:
     case 8: wcopyscroll (0, 0, 0);
	     wcopyscroll (1, 0, 100); break;
     case 9: wcopyscroll (0, 0, 0);
	     wcopyscroll (3, 128, 0); break;
    }
  } while (!kbdon[ESC]);  /* Until ESC is hit */

 uninstallkbd ();
 close_files ();

 wems_close ();
 wsetmode (oldmode);
}


void loadsprites (void)
 {
  if (wemstiles)
   {
    wems_loadsprites ("test1.spr", pal, tiles0, 0, NUM_TILES);
    wems_loadsprites ("test2.spr", pal, tiles1, 0, NUM_TILES);
    wems_loadsprites ("test3.spr", pal, tiles2, 0, NUM_TILES);
    wems_loadsprites ("test4.spr", pal, tiles3, 0, NUM_TILES);
   }
  else
   {
    wloadsprites (pal, "test1.spr", tiles0, 1, NUM_TILES);
    wloadsprites (pal, "test2.spr", tiles1, 1, NUM_TILES);
    wloadsprites (pal, "test3.spr", tiles2, 1, NUM_TILES);
    wloadsprites (pal, "test4.spr", tiles3, 1, NUM_TILES);
   }
   wsetpalette (0, 255, pal);
 }

void loadmaps (void)
 {
  map0 = wloadmap (0, "test4.wmp", tiletypes0, wobject);
  map1 = wloadmap (1, "test3.wmp", tiletypes1, wobject);
  map2 = wloadmap (2, "test2.wmp", tiletypes2, wobject);
  map3 = wloadmap (3, "test1.wmp", tiletypes3, wobject);

 /* If the tilewidth is not 0, the window must have been initialized
    above, so start viewing it at the top left of the map. */
 if (tilewidth[0] > 0)
   {
    wshowwindow (0, 0, 0);
    window_on[0] = 1;
   }
 if (tilewidth[1] > 0)
   {
    wshowwindow (1, 0, 0);
    window_on[1] = 1;
   }
 if (tilewidth[2] > 0)
  {
     wshowwindow (2, 0, 0);
    window_on[2] = 1;
   }
 if (tilewidth[3] > 0)
   {
   wshowwindow (3, 0, 0);
   window_on[3] = 1;
   }
 }
 


void find_tile_sizes (void)
 {
  emsblock = get_tile (1, tiles0);
  xsize[0] = wgetblockwidth (emsblock);
  ysize[0] = wgetblockheight (emsblock);

  emsblock = get_tile (1, tiles1);
  xsize[1] = wgetblockwidth (emsblock);
  ysize[1] = wgetblockheight (emsblock);

  emsblock = get_tile (1, tiles2);
  xsize[2] = wgetblockwidth (emsblock);
  ysize[2] = wgetblockheight (emsblock);

  emsblock = get_tile (1, tiles3);
  xsize[3] = wgetblockwidth (emsblock);
  ysize[3] = wgetblockheight (emsblock);
 }

void start_scroll (void)
 {
  switch (setup)
   {
    case 0:  winitscroll (0, NORMAL,  -1, 128 / xsize[2], 96 / ysize[2], tiles2);
	     winitscroll (1, NORMAL,  -1, 128 / xsize[1], 96 / ysize[1], tiles1);
	     winitscroll (2, NORMAL,  -1, 128 / xsize[2], 96 / ysize[2], tiles2);
	     winitscroll (3, NORMAL,  -1, 128 / xsize[3], 96 / ysize[3], tiles3); break;
    case 1:  winitscroll (0, NORMAL,  -1, 320 / xsize[3], 192 / ysize[3], tiles3); break;
    case 2:  winitscroll (0, NORMAL,  -1, 320 / xsize[3], 192 / ysize[3], tiles3);
	     winitscroll (1, PARALLAX, 0, 320 / xsize[1], 192 / ysize[1], tiles1); break;
    case 3:  winitscroll (0, NORMAL,  -1, 256 / xsize[0], 192 / ysize[0], tiles0);
	     winitscroll (1, PARALLAX, 0, 256 / xsize[1], 192 / ysize[1], tiles1);
	     winitscroll (2, PARALLAX, 0, 256 / xsize[2], 192 / ysize[2], tiles2); break;
    case 4:  winitscroll (0, NORMAL,  -1, 256 / xsize[0], 192 / ysize[0], tiles0);
	     winitscroll (1, PARALLAX, 0, 256 / xsize[2], 192 / ysize[2], tiles2);
	     winitscroll (2, PARALLAX, 0, 256 / xsize[1], 192 / ysize[1], tiles1);
	     winitscroll (3, PARALLAX, 0, 256 / xsize[3], 192 / ysize[3], tiles3); break;
    case 5:  winitscroll (0, NORMAL,  -1, 128 / xsize[0], 192 / ysize[0], tiles0);
	     winitscroll (1, NORMAL,  -1, 128 / xsize[1], 192 / ysize[1], tiles1); break;
    case 6:  winitscroll (0, NORMAL,  -1, 128 / xsize[0], 192 / ysize[0], tiles0);
	     winitscroll (1, NORMAL,  -1, 128 / xsize[1], 192 / ysize[1], tiles1);
	     winitscroll (2, PARALLAX, 0, 128 / xsize[2], 192 / ysize[2], tiles2);
	     winitscroll (3, PARALLAX, 1, 128 / xsize[3], 192 / ysize[3], tiles3); break;
    case 7:  winitscroll (0, NORMAL,  -1, 320 / xsize[2], 96 / ysize[2], tiles2);
	     winitscroll (1, NORMAL,  -1, 320 / xsize[1], 96 / ysize[1], tiles1); break;
    case 8:  winitscroll (0, NORMAL,  -1, 320 / xsize[2], 96 / ysize[2], tiles2);
	     winitscroll (1, NORMAL,  -1, 320 / xsize[1], 96 / ysize[1], tiles1);
	     winitscroll (2, PARALLAX, 0, 320 / xsize[2], 96 / ysize[2], tiles2);
	     winitscroll (3, PARALLAX, 1, 320 / xsize[3], 96 / ysize[3], tiles3); break;
    case 9:  winitscroll (0, NORMAL,  -1, 128 / xsize[2], 192 / ysize[2], tiles2);
	     winitscroll (1, PARALLAX, 0, 128 / xsize[1], 192 / ysize[1], tiles1);
	     winitscroll (2, PARALLAX, 0, 128 / xsize[3], 192 / ysize[3], tiles3);
	     winitscroll (3, NORMAL,  -1, 128 / xsize[3], 192 / ysize[3], tiles3); break;
   }                                                                      

}

void close_files(void)
{
  wfreemap (map0);
  wfreemap (map1);
  wfreemap (map2);
  wfreemap (map3);
  wendscroll (0);
  wendscroll (1);
  wendscroll (2);
  wendscroll (3);
}


block get_tile (int num, block *tiles)
{
if (wemstiles)
   return (wems_getsprite (num, tiles));
else
   return (tiles[num]);
}