/*
ͻ
                     WordUp Graphics Toolkit Version 4.0                    
                            Demonstration Program 33                        
                                                                            
 Demonstrates the use of wbezier. Draws random curves until key pressed.    
                                                                            
  PROJECT                                                             
 This program requires the file WGT4.LIB to be linked.          	     
                                                                            
  DATA FILES                                                          
 NONE                                                                       
                                                                            
ͼ
*/

#include <stdlib.h>
#include <wgt4.h>

#define NUM_IN 5       /* number of random points */
#define NUM_OUT 30     /* number of points of bezier curve */
/* Fewer points will make more chunky line */

void main(void)
{
  tpolypoint inpoint[NUM_IN];  	/* Array with the normal curve points */
  tpolypoint outpoint[NUM_OUT]; /* Array with smooth curve points */
  block other;                  /* Pointer to our second screen */
  int i;			/* Loop counter */
  int oldmode;			/* Stores initial video mode */

  if ( !vgadetected() )
  {
    printf("Error - VGA card required for any WGT program.\n");
    exit(0);
  }

  oldmode = wgetmode();		/* Gets the current mode */
  vga256();			/* Initialize graphics mode */

  other=wnewblock(0,0,319,199);		/* Allocate second screen */

  randomize();				/* Initialize random # generator */
  wsetcolor(15);			/* Draw with white */

  do {
    wsetscreen(other);			/* We'll draw on the hidden screen */
    wcls(0);				/* Clear it with black */

    for (i=0; i<NUM_IN; i++)		/* Randomize the BEZIER control pts */
    {
      inpoint[i].x= random (320);
      inpoint[i].y= random (200);
    }

    wbezier(inpoint,NUM_IN,outpoint,NUM_OUT);	/* Generate line */

    whollowpoly(outpoint, NUM_OUT, 0, 0, OPEN_POLY);
      /* draw the smooth curve */

    wnormscreen();		/* Reset drawing to visual screen */
    wputblock(0,0,other,0);	/* Show the screen */
  } while (!kbhit());		/* Abort if key pressed */
  getch();			/* Get the key */

  wfreeblock(other);		/* Free our screen buffer */
  wsetmode(oldmode);		/* Restore initial video mode */
}
 
 
 

