/*
ͻ
                     WordUp Graphics Toolkit Version 4.0                    
                            Demonstration Program 22                        
                                                                            
 This is a small program 'template' to help you get started with the sprite 
 library.                                                                   
                                                                            
  PROJECT                                                             
 This program requires the files WSPR.LIB and WGT4.LIB to be linked.        
                                                                            
  DATA FILES                                                          
 Make sure that INVADER.SPR is in your executable directory.                
                                                                            
ͼ
*/

#include <stdio.h>
#include <dos.h>
#include <conio.h>
#include <stdlib.h>
#include <alloc.h>
#include <wgt4.h>
#include <wgtspr.h>

#define SPRITES_IN_FILE 50

color palette[256];		
block sprites[SPRITES_IN_FILE+1];
int quit;				/* if quit !=0, program quits */
int oldmode;

void looper(void);			/* a routine which controls the sprites */

void main(void)
{
  if ( !vgadetected() )
  {
    printf("Error - VGA card required for any WGT program.\n");
    exit(0);
  }
  oldmode=wgetmode();
  vga256();
  wloadsprites(palette,"invader.spr",sprites,0,SPRITES_IN_FILE);
  /* load first 50 sprites */
  wsetpalette(0,255,palette);

  initspr();					/* initialize them */
  spon=10;					/* number of sprites on */

/* Spriteon has the following format:
   Sprite number, x coord, y coord, sprite number in array of sprites
   Therefore sprite #1 would be displayed at 160,100 with sprite 1 in the array */

  spriteon(1,160,100,1);			/* turn on any sprites */
  spriteon(2,10,100,3);				/* you need */


/* This move will go left 1, for 300 times, and right 1 for 300 times,
   and repeat */

  movex(2,"(1,300,0)(-1,300,0)R");		/* set up any movement */
  movexon(2);					/* or animation needed */


/* This animation will animate sprite 2 through a sequence of sprites
   in the sprite array and keep repeating. */

  animate(2,"(3,50)(4,50)(5,50)(4,50)R");
  animon(2);

  wsetscreen(spritescreen);
  minit();

  do {
    looper();
  } while (!quit);

  spriteoff(1);			/* turn off sprites */
  spriteoff(2);
  /* To be safe, turn off all sprites before ending program.
     This will free any memory used from them. */

  wfreesprites(sprites,0,SPRITES_IN_FILE);	/* free memory */

  deinitspr();
  mdeinit ();                   /* Deinitialize the mouse handler */
  wsetmode(oldmode);
}


void looper(void)
{
  erasespr();			/* clear the sprites */

  s[1].x=mx;	/* any direct sprite movements must be placed */
  s[1].y=my;	/* between erasespr and drawspr */
                /* This will set sprite one's coordinate to the mouse
                   coordinates. Move it around! */
		/* notice how sprite #2 moves and animates on its own now!
		   You don't need to change anything to make it move! */

  drawspr();			/* draw them back on */
  wretrace();
  if (kbhit()) quit=1;
}
