/*
ͻ
                     WordUp Graphics Toolkit Version 4.0                    
                            Demonstration Program 7                         
                                                                            
Displays some text with the text grid off until you hit a key, then turns   
the grid on and displays text, to show the difference.                      
                                                                            
  PROJECT                                                             
 This program requires the file WGT4.LIB to be linked.          	     
                                                                            
  DATA FILES                                                          
 NONE                                                                       
                                                                            
ͼ
*/

#include <wgt4.h>

int x,y,col;
int oldmode;
color palette[255];


void main(void)
{
  if ( !vgadetected() )
  {
    printf("Error - VGA card required for any WGT program.\n");
    exit(0);
  }

  oldmode = wgetmode();
  vga256();

  /* Set our palette */
  for (y = 0; y < 64; y++)
    wsetrgb(y,y,y,y,palette);
  for (y = 0; y < 64; y++)
    wsetrgb(y + 64,y,0,0,palette);
  for (y = 0; y < 64; y++)
    wsetrgb(y + 128,0,y,0,palette);
  for (y = 0; y < 64; y++)
    wsetrgb(y + 192,0,0,y,palette);
  wsetpalette(0,255,palette);

  wcls(0);

  wtextgrid(TEXTGRID_OFF);
  wtexttransparent(TEXTFGBG); 	/* Turn foreground and background on */

  do {
    x = rand() % 320;
    y = rand() % 200;
    col = rand() % 256;
    wtextcolor(col);
    wouttextxy(x,y,NULL,"WordUp Graphics Toolkit");
  } while (!kbhit());
  getch();

  wcls(0);
  wtextgrid(TEXTGRID_ON);
  do {
    x = rand() % 80;
    y = rand() % 25;
    col = rand() % 256;
    wtextcolor(col);
    wtextbackground(rand() % 256);
    wouttextxy(x,y,NULL,"WordUp Graphics Toolkit");
  } while (!kbhit());

  getch();
  wsetmode(oldmode);
}