{$X+}
Uses Tgk_Main,TGK_Text,TGK_IO,TGK_Anim,TGK_Snd,TGK_GP,TGK_BM,TGK_3D,TGK_File;

Const NrStars   = 17;

Var A,B        : Integer;
    Jerry      : Array[1..2] of AnimType;
    Music,Tune : MusicType;
    Kabang     : SampleType;
    Snork,Star : AnimType;
    Stars      : Array[1..NrStars] of AnimType;
    Gosh_A_Pic : SpriteType;

Procedure MakeDiamond(Nr:Word);
Begin
 InitObject(Nr);
 AddPoint(Nr, 20, 10,-20);
 AddPoint(Nr, 10, 20,-20);
 AddPoint(Nr,-10, 20,-20);
 AddPoint(Nr,-20, 10,-20);
 AddPoint(Nr,-20,-10,-20);
 AddPoint(Nr,-10,-20,-20);
 AddPoint(Nr, 10,-20,-20);
 AddPoint(Nr, 20,-10,-20);
 AddSurface4(Nr,1,2,3,4,127,4);
 AddSurface4(Nr,1,4,5,8,127,4);
 AddSurface4(Nr,8,5,6,7,127,4);

 AddPoint(Nr, 60, 30,25); {9}
 AddPoint(Nr, 30, 60,25);
 AddPoint(Nr,-30, 60,25);
 AddPoint(Nr,-60, 30,25);
 AddPoint(Nr,-60,-30,25);
 AddPoint(Nr,-30,-60,25);
 AddPoint(Nr, 30,-60,25);
 AddPoint(Nr, 60,-30,25);
 AddSurface4(Nr,9,10, 2,1,125,1);
 AddSurface4(Nr,10,11,3,2,126,22);
 AddSurface4(Nr,11,12,4,3,125,1);
 AddSurface4(Nr,12,13,5,4,126,22);
 AddSurface4(Nr,13,14,6,5,125,1);
 AddSurface4(Nr,14,15,7,6,126,22);
 AddSurface4(Nr,15,16,8,7,125,1);
 AddSurface4(Nr,16, 9,1,8,126,22);

 AddPoint(Nr,0,0,100);

 AddSurface3(Nr,17,10, 9,126,22);
 AddSurface3(Nr,17,11,10,125,1);
 AddSurface3(Nr,17,12,11,126,22);
 AddSurface3(Nr,17,13,12,125,1);
 AddSurface3(Nr,17,14,13,126,22);
 AddSurface3(Nr,17,15,14,125,1);
 AddSurface3(Nr,17,16,15,126,22);
 AddSurface3(Nr,17, 9,16,125,1);
End;

{ Main program ;-)) }

Begin
{ Resource:='GAMEDEMO.RES';}
 OpenGraphics;                           { Enter graphics mode }
 Randomize;
 MakeDiamond(1);                         { Initialize Vector-Object }

 LoadFont('Weird',1);                    { Load some fonts... }
 LoadFont('Scribble',2);
 SetTextJustify(CenterText,TopText);     { and set some text-options }
 SetFont(1);
 SetTextMode(Precision);                 { Slower, but hey, precise! }

 InitMusic(Music);                       { Initialize and load the }
 LoadMusic(Music,'CRITICAL');            { musical scores... }
 InitMusic(Tune);
 LoadMusic(Tune,'COFFEE');

 InitSample(Kabang);                     { Our cowboy says "Bang!", }
 LoadSample(Kabang,'SHOOT',True);
 SetDigiVolume(100);                     { but not to loud... }

 InitAnimation(Jerry[1]);                { Initialize and load some }
 LoadAnimation(Jerry[1],'SLOWLEFT');     { animations... }
 InitAnimation(Jerry[2]);
 LoadAnimation(Jerry[2],'SHOOT');
 SetupAnimation(Jerry[1],320,120,AnimMove);
 AnimationSpecs(Jerry[1],AnimXStep,-3);

 SetupAnimation(Jerry[2],30,120,AnimStatic);

 InitAnimation(Snork);
 LoadAnimation(Snork,'SLEEPMAN');
 AnimationSpecs(Snork,AnimSpeed,3);

 InitAnimation(Star);
 LoadAnimation(Star,'STAR');
 AnimationSpecs(Star,AnimPong,1);
  For A:=1 to NrStars do                { This one is cloned a few times... }
   Begin
    CloneAnimation(Star,Stars[A]);
    SetupAnimation(Stars[A],Random(320),Random(180)+10,AnimMove);
    AnimationSpecs(Stars[A],AnimXStep,-(Random(4)+1));
    Stars[A].CurFrame:=Random(Stars[A].NrFrames)+1; { random starting-frame }
   End;

 ClearPage(2);                          { Draw a stupid background... }
  For A:=0 to 39 do
   Begin
    HLine(0,39-A,319,47-A Div 3,2);
    HLine(0,160+A,319,47-A Div 3,2);
   End;

 StartMusic(Tune,0);                    { and get the show on the road }

  For A:=1 to 33 do
   Begin
    CurPage:=1-CurPage;
    CopyPage(2,1-CurPage);
    SetTextSize(A*3+1);
    Outtext(160,A*3-20,1,1-CurPage,'PRESENTING');
    Sync;
    SetPage(1-CurPage);
    WaitTimer(1,4,True);
   End;

 CopyPage(1-CurPage,2);
  For A:=1 to 100 do
   Begin
    CurPage:=1-CurPage;
    CopyPage(2,1-CurPage);
    HandleAnimation(Jerry[1],1-CurPage);
    Sync;
    SetPage(1-CurPage);
    WaitTimer(1,7,True);
   End;

  For A:=1 to Jerry[2].NrFrames do
   Begin
    CurPage:=1-CurPage;
    CopyPage(2,1-CurPage);
    HandleAnimation(Jerry[2],1-CurPage);
    Sync;
    SetPage(1-CurPage);
     If A=6 then StartSample(Kabang,1); { "Kapow!" says our cowboy }
    WaitTimer(1,10,True);
   End;

 CopyPage(1-CurPage,2);
 SetTextJustify(LeftText,TopText);
  For A:=1 to 17 do
   Begin
    CurPage:=1-CurPage;
    CopyPage(2,1-CurPage);
    Outtext(320-A*10,125,1,1-CurPage,'GAME');
    Sync;
    SetPage(1-CurPage);
   End;

 CopyPage(1-CurPage,2);

 InitSprite(Gosh_A_Pic);
 GetImage(1,79,318,157,Gosh_A_Pic,2);
 FRectangle(1,79,318,157,0,2);
  For A:=1 to 26 do
   Begin
    CurPage:=1-CurPage;
    CopyPage(2,1-CurPage);
    PutImage(1,79-A*3,Gosh_A_Pic,1-CurPage);
    Sync;
    SetPage(1-CurPage);
    WaitTimer(1,7,True);
   End;
 DisposeSprite(Gosh_A_Pic);

 SetupAnimation(Jerry[1],30,42,AnimMove);
 CopyPage(1-CurPage,2);
 FRectangle(25,40,60,80,0,2);
  For A:=1 to 17 do
   Begin
    CurPage:=1-CurPage;
    CopyPage(2,1-CurPage);
    HandleAnimation(Jerry[1],1-CurPage);
    Sync;
    SetPage(1-CurPage);
    WaitTimer(1,7,True);
   End;

 MakeDiamond(1);
 SetOrigin(1,60,100);
 SizeObject(1,0.1);
  For A:=1 to 17 do
   Begin
    CurPage:=1-CurPage;
    CopyPage(2,1-CurPage);
     For B:=1 to NrStars Do
      HandleAnimation(Stars[B],1-CurPage);
    SizeObject(1,1.1);
    RotateObject(1,10,7,8);
    HideObject(1);
    DrawObjectFilled(1,1-CurPage);
    Sync;
    SetPage(1-CurPage);
    WaitTimer(1,8,True);
    SetOverallVolume(1-(A*(100/17))/100);
   End;

 SetOverallVolume(0);
 StopMusic;
 StartMusic(Music,0);
 A:=0;
 SetTextJustify(CenterText,TopText);
 SetFont(2);
  Repeat
   CurPage:=1-CurPage;
   CopyPage(2,1-CurPage);
    For B:=1 to NrStars Do
     HandleAnimation(Stars[B],1-CurPage);
   RotateObject(1,10,7,8);
   HideObject(1);
   DrawObjectFilled(1,1-CurPage);
   Sync;
   SetPage(1-CurPage);
   Inc(A);
    If A<30 then SetOverAllVolume(A/30);
    If (A>30) and (A<170) then
     Begin
      SetupAnimation(Snork,(A-50)*2,140,AnimStatic);
      HandleAnimation(Snork,1-CurPage);
     End else If (A>=170) then HandleAnimation(Snork,1-CurPage);
    If (A>200) and (A<216) then
     OutText(160,199-(A-200),31-(A-200),1-CurPage,'Press any key to exit to DOS!');
    If A=215 then OutText(160,183,15,2,'Press any key to exit to DOS!');
   WaitTimer(1,8,True);
  Until Keypressed;

 For A:=30 downto 0 do
  Begin
   SetOverallVolume(A/30);
   WaitTimer(1,3,True);
  End;

 Readkey;
 DisposeMusic(Music);
 DisposeMusic(Tune);
 DisposeAnimation(Jerry[1]);
 DisposeAnimation(Jerry[2]);
 DisposeAnimation(Snork);
 DisposeAnimation(Star);
 DisposeFont(1);
 DisposeFont(2);
 DisposeSample(Kabang);
 CloseGraphics;
 Writeln('Goodbye...');
 Writeln;
 ClearKeybuffer;
End.