Attribute VB_Name = "Globales"
Option Explicit

' mximo n de lneas que se mostrarn simultneamente en la ventana de depurador
Public Const NUM_LIN_DEP = 50

' ficheros
Public Const EXT_VOC = ".VOC"       ' fichero de vocabulario
Public Const EXT_LOC = ".LOC"       ' fichero de localidades
Public Const EXT_OBJ = ".OBJ"       ' fichero de objetos
Public Const EXT_PSI = ".PSI"       ' fichero de PSIs
Public Const EXT_PROC = ".VST"      ' fichero con lista de mdulos
Public Const EXT_SCR = ".VS"        ' fichero de procedimientos
Public Const EXT_RES = ".RES"       ' fichero de definicin de recursos
Public Const EXT_DLL = ".VSR"       ' fichero de recursos compilados
Public Const EXT_MOD = ".VX"        ' fichero de mdulo exportado
Public Const EXT_LOCX = ".LOX"      ' fichero de mapa exportado

' tipos de recursos
Public Const RES_IMG = "IMG"        ' imagen
Public Const RES_SND = "SND"        ' sonido
Public Const RES_FNT = "FNT"        ' fuente

' tipos de objetos en la aventura
Public Const OBJ_LOC = 0            ' localidad
Public Const OBJ_OBJ = 1            ' objeto
Public Const OBJ_PSI = 2            ' PSI

' tipos de contenedores que pueden contener a un objeto
Public Const OBJ_CONTLOC = 0        ' localidad
Public Const OBJ_CONTOBJ = 1        ' objeto
Public Const OBJ_CONTPSI = 2        ' PSI

' tipos de palabras del vocabulario
Public Const VOC_VERBO = 1          ' verbo
Public Const VOC_CONJ = 2           ' conjuncin
Public Const VOC_SINONIMO = 3       ' sinnimo
Public Const VOC_VERBOMOV = 4       ' verbo de movimiento
Public Const VOC_NOMBRE = 5         ' nombre
Public Const VOC_ADJETIVO = 6       ' adjetivo
Public Const VOC_PREPOS = 7         ' preposicin

' *** TIPOS DE DATOS ***
' NOTA: si se modifica algn tipo de dato se deben revisar
'       las funciones: 'GuardarVocabulario[Res]', 'GuardarLocalidades[Res]',
'                      'GuardarObjetos[Res]', 'GuardarPSIs[Res]',
'                      'CargarVocabulario[Res]', 'CargarLocalidades[Res]',
'                      'CargarObjetos[Res]', 'CargarPSIs[Res]'
'                      'AsignaPropiedadLoc', 'PropiedadLoc'
'                      'AsignaPropiedadObj', 'PropiedadObj'
'                      'AsignaPropiedadPSI', 'PropiedadPSI'
'                      'GuardarEstado' y 'RecuperarEstado'
' definicin de conexin
Public Type Conexion
    Localidad As String         ' nombre de la localidad de destino
    Verbo As String             ' verbo de conexin
    Abierta As Boolean          ' abierta/cerrada
End Type

' definicin de localidad
Public Type Localidad
    Nombre As String            ' nombre
    DescCorta As String         ' descripcin corta
    DescLarga As String         ' descripcin larga
    Iluminada As Boolean        ' si est iluminada
    Exterior As Boolean         ' si es exterior
    Grafico As String           ' grfico asociado
    Sonido As String            ' sonido asociado
    Conexiones() As Conexion    ' lista de conexiones
    PropUsr() As String         ' valores de propiedades de usuario
    Usuario As String           ' array con informacin de usuario
    X As Long                   ' pos. X en pantalla de diseo (-1 si no se quiere mostrar)
    Y As Long                   ' pos. Y en pantalla de diseo (-1 si no se quiere mostrar)
End Type
' propiedades de localidad
' NOTA: revisar procedimiento de aadir nueva propiedad de usuario
'       en formulario 'frmLocalidades'
Public Const LOC_PROP_NOMBRE = "NOMBRE"
Public Const LOC_PROP_DESCCORTA = "DESCCORTA"
Public Const LOC_PROP_DESCLARGA = "DESCLARGA"
Public Const LOC_PROP_ILUMINADA = "ILUMINADA"
Public Const LOC_PROP_EXTERIOR = "EXTERIOR"
Public Const LOC_PROP_GRAFICO = "GRAFICO"
Public Const LOC_PROP_SONIDO = "SONIDO"
Public Const LOC_PROP_USUARIO = "USUARIO"

' definicin de objeto
Public Type Objeto
    Nombre As String            ' nombre
    Adjetivo As String          ' adjetivo
    DescCorta As String         ' descripcin corta
    DescLarga As String         ' descripcin larga
    Peso As Long                ' peso
    Tam As Long                 ' tamao
    TipoContenedor As Integer   ' tipo de contenedor dnde est el objeto
    Contenedor As String        ' contenedor donde est contenido
    Grafico As String           ' grfico asociado
    Sonido As String            ' sonido asociado
    Propiedades As String       ' cadena con los indicadores (V/F) de que
                                ' propiedades de la tabla de propiedades
                                ' de objetos estn activadas/desactivadas
    PropUsr() As String         ' valores de propiedades de usuario
    Usuario As String           ' array con informacin de usuario
End Type
' propiedades de objeto
' NOTA: revisar procedimiento de aadir nueva propiedad de usuario
'       en formulario 'frmObjetos'
Public Const OBJ_PROP_NOMBRE = "NOMBRE"
Public Const OBJ_PROP_ADJETIVO = "ADJETIVO"
Public Const OBJ_PROP_DESCCORTA = "DESCCORTA"
Public Const OBJ_PROP_DESCLARGA = "DESCLARGA"
Public Const OBJ_PROP_PESO = "PESO"
Public Const OBJ_PROP_TAM = "TAM"
Public Const OBJ_PROP_TIPOCONTENEDOR = "TIPOCONTENEDOR"
Public Const OBJ_PROP_CONTENEDOR = "CONTENEDOR"
Public Const OBJ_PROP_GRAFICO = "GRAFICO"
Public Const OBJ_PROP_SONIDO = "SONIDO"
Public Const OBJ_PROP_USUARIO = "USUARIO"
' propiedades de objeto 'definidas por el usuario'
Public Const OBJ_PROP_FEMENINO = "Femenino"
Public Const OBJ_PROP_PLURAL = "Plural"
Public Const OBJ_PROP_ESCONTENEDOR = "EsContenedor"
Public Const OBJ_PROP_LUZ = "Luz"
Public Const OBJ_PROP_INVISIBLE = "Invisible"
Public Const OBJ_PROP_TAPA = "TieneTapa"
Public Const OBJ_PROP_ABIERTO = "Abierto"
Public Const OBJ_PROP_PRENDA = "Prenda"
Public Const OBJ_PROP_PUESTO = "Puesto"
Public Const OBJ_PROP_ESCENARIO = "Escenario"
Public Const OBJ_PROP_ENCENDIDO = "Encendido"

' definicin de PSI
Public Type Psi
    Nombre As String            ' nombre
    Adjetivo As String          ' adjetivo
    DescCorta As String         ' descripcin corta
    DescLarga As String         ' descripcin larga
    Peso As Long                ' peso
    Tam As Long                 ' tamao
    Localidad As String         ' localidad donde se encuentra
    Grafico As String           ' grfico asociado
    Sonido As String            ' sonido asociado
    Propiedades As String       ' cadena con los indicadores (V/F) de qu
                                ' propiedades de la tabla de propiedades
                                ' de PSIs estn activadas/desactivadas
    PropUsr() As String         ' valores de propiedades de usuario
    Usuario As String           ' array con informacin de usuario
End Type
' propiedades de PSI
' NOTA: revisar procedimiento de aadir nueva propiedad de usuario
'       en formulario 'frmPSIs'
Public Const PSI_PROP_NOMBRE = "NOMBRE"
Public Const PSI_PROP_ADJETIVO = "ADJETIVO"
Public Const PSI_PROP_DESCCORTA = "DESCCORTA"
Public Const PSI_PROP_DESCLARGA = "DESCLARGA"
Public Const PSI_PROP_LOCALIDAD = "LOCALIDAD"
Public Const PSI_PROP_PESO = "PESO"
Public Const PSI_PROP_TAM = "TAM"
Public Const PSI_PROP_GRAFICO = "GRAFICO"
Public Const PSI_PROP_SONIDO = "SONIDO"
Public Const PSI_PROP_USUARIO = "USUARIO"
' propiedades de PSI 'definidas por el usuario'
Public Const PSI_PROP_FEMENINO = "Femenino"
Public Const PSI_PROP_PLURAL = "Plural"
Public Const PSI_PROP_INVISIBLE = "Invisible"
Public Const PSI_PROP_MUERTO = "Muerto"
Public Const PSI_PROP_ESCENARIO = "Escenario"

' definicin de mdulo
Public Type Modulo
    Nombre As String        ' descripcin
    Fichero As String       ' fichero dnde se guarda
End Type

' mtodos de LOC/OBJ/PSI (declaramos nombres comunes, dentro de lo posible, por
' cada mtodo se indica a qu tipo de objetos se puede aplicar LOC, OBJ o PSI)
Public Const METODO_CONEX = "CONEXIONES"    ' lista de conexiones (LOC)
Public Const METODO_OBJETOS = "OBJETOS"     ' lista de objetos contenidos (LOC/OBJ/PSI)
Public Const METODO_PESOOBJETOS = "PESOOBJETOS"     ' peso total de los objetos contenidos (OBJ/PSI)
Public Const METODO_PSIS = "PSIS"           ' lista de PSIs en una localidad (LOC)
Public Const METODO_METER = "METER"         ' poner objeto en loc. (LOC)
                                            ' meter objeto en otro (OBJ)
Public Const METODO_COGER = "COGER"         ' coger objeto (PSI)
Public Const METODO_DEJAR = "DEJAR"         ' dejar objeto en localidad (OBJ)
                                            ' dejar objeto el localidad actual (PSI)
Public Const METODO_CONTIENE = "CONTIENE"   ' si un objeto contiene a otro (LOC/OBJ/PSI)
Public Const METODO_MOVER = "MOVER"         ' mover con verbo movimiento (PSI)
Public Const METODO_LOCALIDAD = "LOCALIDAD" ' devuelve la localidad con la que conecta (LOC)
Public Const METODO_ABIERTA = "ABIERTA"     ' comprueba si una conexin est abierta (LOC)
Public Const METODO_ABRIR = "ABRIR"         ' abre una conexin (LOC)
Public Const METODO_CERRAR = "CERRAR"       ' cierra una conexin (LOC)

' definicin de palabra de vocabulario
Public Type Palabra
    Palabra As String           ' palabra
    Tipo As Integer             ' tipo
    Sinonimo As String          ' palabra de la que es sinnimo
End Type

' propiedad de usuario
Type UsrProp
    Tipo As Integer             ' tipo
    Nombre As String            ' nombre
End Type

' tipos de propiedades de usuario
Public Const TIPO_PROP_SINO = 0     ' verdadero/falso
Public Const TIPO_PROP_VAR = 1      ' valor (cadena, numero, array,...)

' propiedades de objetos/PSIs
Public Const PROP_ACTIV = "V"       ' si
Public Const PROP_DESACTIV = "F"    ' no

' mapa de conexiones
Public Const TAM_MAPAX = 30000      ' tamao del mapa
Public Const TAM_MAPAY = 30000
Public Const TAM_LOCX = 500         ' tamao de recuadro de localidad
Public Const TAM_LOCY = 500
Public Const VCONEX_DELTAX = 4      ' separacin del verbo de conexin respecto
Public Const VCONEX_DELTAY = 4      ' al recuadro

' *** VARIABLES GLOBALES (NOTA: inicializar en 'Inicializa') ***
Public sFichAventura As String      ' nombre del fichero de aventura que estamos
                                    ' editando (sin extensin)
                                    
Public bHayLoc As Boolean           ' si hay alguna localidad
Public Localidades() As Localidad   ' lista de localidades
Public LocProp() As UsrProp         ' lista de propiedades de las localidades

Public bHayObj As Boolean           ' si hay algn objeto
Public Objetos() As Objeto          ' lista de objetos
Public ObjProp() As UsrProp         ' lista de propiedades de los objetos

Public bHayPSI As Boolean           ' si hay algn PSI
Public PSIs() As Psi                ' lista de PSIs
Public PSIProp() As UsrProp         ' lista de propiedades de los PSIs

Public bHayVoc As Boolean           ' si el vocabulario tiene alguna palabra
Public Vocabulario() As Palabra     ' vocabulario

Public bHayModulos As Boolean
Public ListaMod() As Modulo         ' lista de mdulos

Public Localidades2() As Localidad  ' tablas para guardar datos para poder
Public Objetos2() As Objeto         ' reiniciar el programa
Public PSIs2() As Psi

' configuracin del editor
Public sEdLetra As String           ' tipo de letra
Public lEdTamLetra As Long          ' tamao de letra
Public iEdAnchoTab As Integer       ' ancho de tabulacin
