import "story/trial"

function shrine()
	clearText()
	image("shrine", "cover")

	text [[You enter into an enormous chamber, disturbing epochs of dust with each step. The Shrine seems to be divided into two sections by a stone wall, which is now ruined and collapsing. The interior is brighter than you expected; looking up, you realise that the roof of the Shrine must have caved in at some point, on both sides of the partition. Through the gap, you can see no sun, moon, or stars; only an eerie crepuscular murk.]]

	text [[In the inner chamber stands an oversized marble statue of an elegant woman in a flowing robe.]]
	jump "shrine_hub"
end

function shrine_hub()
	image("shrine", "cover")

	if shrineLookedAround and shrineExaminedPlaque and shrineExaminedRoof then
		jump "shrine_scowles"
	end

	choice([[Examine the statue.]], "shrine_statue")
	choice([[Look around the room.]], "shrine_lookAround")
	choice([[Look up at the roof.]], "shrine_roof")
end

function shrine_statue()
	image "statue"

	text [[The statue, including its plinth, is about twice your height. You suspect Queen Gwenhaela isn't actually as tall as that. She's dressed in a style you've seen in engravings of ancient civilisations, like something from one of your grandfather's books. A garland of flowers surmounts her head.]]

	text [[Chiselled into the backs of the statue's hands, in delicate capital letters, are the words "ARS" (on her left), and "SCIENTIA" (on her right). On the plinth is a brass plaque.]]

	jump "shrine_statueHub"
end

function shrine_statueHub()
	choiceOnce([[Curtsy to the statue.]], "shrine_curtsy")
	choiceOnce([[Read the plaque.]], "shrine_plaque")
	choice([[Turn to look at the room again.]], "shrine_hub")
end

function shrine_curtsy()
	text [[You assume this is probably what you're supposed to do. You bob stiffly. It feels a bit silly, though, since there's nobody here.]]
	jump "shrine_statueHub"
end

function shrine_plaque()
	text [[It says "Euphoria of Purpose".]]

	shrineExaminedPlaque = true

	jump "shrine_statueHub"
end

function shrine_lookAround()
	text [[The shrine is absolutely choked with dust from plaster and fallen masonry. Rubble and smashed bits of something litter the floor; on closer inspection they appear to be fragments of porcelain. It's fortunate the collapsing roof seems to have missed the statue, though it still looks as if more could break off at any moment. The partition wall also looks structurally unsound – it must not be bearing very much weight, since it would surely have come crashing down otherwise.]]

	shrineLookedAround = true

	jump "shrine_hub"
end

function shrine_roof()
	text [[It's impossible to tell how long it's been like that. You can see leafy plants growing around the edge of the hole, so it seems doubtful that the collapse was a recent occurrence.]]

	shrineExaminedRoof = true

	jump "shrine_hub"
end

function shrine_scowles()
	text [[As you're looking around the room again, you hear a creaking sound above you, and a few small stones land on the floor.]]

	text [[You look up.]]

	clearText()

	image("scowles", "cover")

	if not cellSeenScowles then
		text [[High above, you see an enormous creature looking down over the broken masonry. Its woody tendrils and barklike skin give it the appearance of a monstrous tree, and its dark, eyeless sockets seem to be fixed on you in the dusty half-light.]]
	else
		text [[High above, the enormous arborescent creature you saw through the window of your cell looks down over the broken masonry, its eyeless sockets fixed on you in the dusty half-light.]]
	end

	text [["HELLO," it says. "I DID NOT EXPECT TO SEE YOU HERE IN THE QUEEN'S CHAMBER."]]

	choice([[Stare.]], "shrine_stare")
end

function shrine_stare()
	text [["IT WAS I WHO BROUGHT YOU HERE. TO GALLOS."]]
	jump "shrine_scowlesHub"
end

function shrine_scowlesHub()
	if visited(
		"shrine_foundAsleep",
		"shrine_lift",
		"shrine_whoScowles",
		"shrine_chamber",
		"shrine_gwenhaela",
		"shrine_outside",
		"shrine_elsewhere",
		"shrine_shrine"
	) then
		jump "shrine_vultures"
	end

	choiceOnce([["How did I get here?"]], "shrine_foundAsleep")
	choiceOnce([["Can you lift me up to the roof?"]], "shrine_lift")
	choiceOnce([["Who…are you?"]], "shrine_whoScowles")
	choiceOnce([["Did you say 'the Queen's Chamber'?"]], "shrine_chamber")
	if shrineQueenRemembered then
		choiceOnce([["What do you remember about the Queen?"]], "shrine_gwenhaela")
	end
	if shrineCityWalls then
		choiceOnce([["What do you mean by 'outside the city walls'? I wasn't even very far from Ruan-le-Pentrith! And besides, I'd never heard of this place before I came here!"]], "shrine_outside")
	end
	if shrineLocationUnknown then
		choiceOnce([["Wait. Do you mean I fell asleep near the village and you brought me all the way here? To a different…" You can't think of the word. "Elsewhere?"]], "shrine_elsewhere")
	end

	if shrineQueenRemembered then
		choiceOnce([["Do you know what happened to the Shrine? How long has it been like this?"]], "shrine_shrine")
	end
end

function shrine_foundAsleep()
	text [["YOU WERE FOUND. ASLEEP OUTSIDE THE CITY WALLS. I CARRIED YOU TO THE GATE."]]

	jump "shrine_scowlesHub"
end

function shrine_lift()
	text [["I CANNOT. THIS PLACE IS OLD AND WEARING DOWN. THE STONES NOT AS STRONG AS THEY WERE. TO CARRY YOU UP HERE WOULD BE A DANGER TO YOU."]]

	shrineCityWalls = true

	jump "shrine_scowlesHub"
end

function shrine_whoScowles()
	text [["SCOWLES IS MY NAME."]]
	choice([["What sort of creature are you?"]], "shrine_scowlesCreature")
end

function shrine_scowlesCreature()
	text [["MILPREVE THE REMEMBRANCER SAYS THAT I AM A 'LUM-OX'.]]
	text [["I DO NOT THINK THAT IS TRUE. I DO NOT THINK I AM ANY KIND OF OX."]]
	jump "shrine_scowlesHub"
end

function shrine_chamber()
	text [["YES"]]

	text [["Everyone else calls it the Shrine."]]

	text [["THIS IS HER PLACE OF REST. SHE HAS RESTED HERE FOR OVER ONE HUNDRED SEASONS. SHE WILL REMAIN HERE FOR ETERNITY."]]

	shrineQueenRemembered = true

	text [[You think for a moment. "Are there really seasons here?"]]

	text [["THEY ARE NOT SEASONS AS YOU WOULD KNOW THEM."]]

	jump "shrine_scowlesHub"
end

function shrine_gwenhaela()
	text [["SHE WAS VERY WISE. SHE KNEW THE LANGUAGE OF BEASTS AND THE SECRETS OF STONE. MORE THAN THAT I CANNOT SAY."]]

	text [["Cannot? Why?"]]

	text [["I KNEW HER ONLY A SHORT WHILE. SHE DID NOT LAST.]]

	text [["THE CITY OF GALLOS WAS BROUGHT HERE BRICK AND STONE AND TIMBER FROM THE OTHER PLACE. TO MAINTAIN THE GATEFOLD TOOK HER REMAINING LIFE."]]

	if millersofintinnuum then
		text [[Brick by brick - just like the Millers of Intinnuum, each one carrying a brick that used to be their Temple when they fled their city. Only the Queen was carrying all the bricks on her own.]]
	end

	jump "shrine_scowlesHub"
end

function shrine_outside()
	text [["I TRAVEL FAR IN SEARCH OF LOST THINGS. THE OVERWARD AND THE PLACES BETWEEN ARE OPEN TO ME.]]

	text [["THIS CITY, GALLOS, IS INCOMPLETE. ITS LANDS ARE STRETCHED BETWEEN THIS PLACE AND THE OTHER. PERHAPS YOU WERE IN THE UNDERMARCH. PERHAPS YOU WERE NOT."]]

	shrineLocationUnknown = true

	jump "shrine_scowlesHub"
end

function shrine_elsewhere()
	text [["PERHAPS. THE CITY AND THE VILLAGE MAY BE CLOSE. OR THEY MAY NOT. I CANNOT SAY FOR CERTAIN.]]

	text [["IF QUEEN GWENHAELA WERE HERE SHE COULD ANSWER SUCH QUESTIONS. I KNOW ONLY THE UNDERMARCH.]]

	text [["I WAS HERE LONG BEFORE. WHEN THE CITY IS GONE I WILL REMAIN HERE."]]

	jump "shrine_scowlesHub"
end

function shrine_shrine()
	text [["THIS PLACE IS OLDER THAN THE OTHERS. IT IS BECAUSE FEW EVER VISIT HERE."]]

	text [[You think about this.]]

	text [["Do you mean the Shrine fell into ruin because nobody maintained it? But, a hundred seasons…that's not that long, is it? Not enough for all this?"]]

	text [["NO. WHEN A PLACE IS LEFT UNINHABITED IT BECOMES ANCIENT BEFORE ITS TIME. SUCH IS THE WAY IN GALLOS."]]

	jump "shrine_scowlesHub"
end

function shrine_vultures()
	clearText()
	clearImage()

	text [[High above, you hear a strained, familiar voice cry "Scowles!"]]

	text [[He raises his head to look. From down here it's hard to see clearly, but perched on the edge of the crumbled roof appears to be a blackish clump of argumentation and feathers that could, in all probability, be the vultures.]]

	text [[You can only hear snatches of their conversation – *under the Northbury Convention* – *digressive, superfluous, and-furthermore* – but after a brief exchange Scowles withdraws, and the vultures leap from the edge and fly down towards you.]]

	jump "shrine_vultures2"
end

function shrine_vultures2()
	image "vultures"

	text [["There you are!" The vultures land in front of you, disturbing a pile of dust.]]

	text [["Your hearing," says Leofwine, "is scheduled to begin at any moment. What in the name of hyperbole are you doing here conversing with the help?"]]

	choice([["The help?"]], "shrine_theHelp")
end

function shrine_theHelp()
	text [["Scowles is concerned only with protecting the city and performing certain laborious duties as needed. When you are a True Citizen, you need not concern yourself with the tedious business of instructing him; others will convey your wishes."]]

	text [["Conditional on your success in the imminent hearing!" snaps Leofric. "Which, I need not remind you, is by no means guaranteed! Now: follow!"]]

	jump "trial"
end
