.TH cppmake 1
.SH NAME
cppmake \- Cpp then Make
.SH SYNOPSIS
.B cppmake
[\ \fB\-C\ \fIcpp\ \fR]
[\ \fB\-D\ \fIdefine\ \fR]
[\ \fB\-I\ \fIdirectory\ \fR]
[\ \fB\-M\ \fImake\ \fR]
[\ \fB\-U\ \fIdefine\ \fR]
[\ \fB\-f\ \fIcppmakefile\ \fR]
[\ \fB\-o\ \fIoutfile\ \fR]
[\ \fB\-v\ \fR]
[\ make options\ ]
.sp 1
.B cppmake
\fB\-c\fR
[\ \fB\-C\ \fIcpp\ \fR]
[\ \fB\-D\ \fIdefine\ \fR]
[\ \fB\-I\ \fIdirectory\ \fR]
[\ \fB\-M\ \fImake\ \fR]
[\ \fB\-U\ \fIdefine\ \fR]
[\ \fB\-f\ \fIcppmakefile\ \fR]
[\ \fB\-o\ \fIoutfile\ \fR]
[\ \fB\-v\ \fR]
[\ file\ ]
.SH DESCRIPTION
In the first invocation form,
.B cppmake
runs the C preprocessor on the
.IR cppmakefile .
By default,
.B cppmake
looks for files named
.I Makefile.cpp
then
.I makefile.cpp
in the current working directory.
The output of the preprocessor is then filtered before being passed to
.B make
for final processing.
.PP
In the second form,
.B cppmake
runs the C preprocessor on the named file to produce
a file suitable for inclusion by other
.IR cppmakefiles .
.BR make .
.SH OPTIONS
.TP 15
.BI -C cpp
Use
.I cpp
as the name of the C preprocessor. This option will have
precedence over the environment variable
.B CPPMAKECPP.
.TP 15
.BI -D define
Pass the following symbol definitions to
.BR cpp .
.TP 15
.BI -I directory
Pass the following include directory to
.BR cpp .
.TP 15
.BI -M make
Use
.I make
as the name of the make program. This option will have
precedence over the environment variable
.B CPPMAKEMAKE.
.TP 15
.BI -U define
Undefine the following symbol in
.BR cpp .
.TP 15
.B -c
Preprocess the named file to produce a file that is suitable for inclusion by
other
.IR cppmakefiles .
.TP 15
.BI -f cppmakefile
Use the named file as the input file, otherwise the default names of the
.I cppmakefile
will be tried, or if the
.B -c
option is specified,
.I file
will be used as the name.
.TP 15
.BI -o outfile
Place the
.I makefile
in the named file and do not invoke make, or if the
.B -c
option is specified, the generated include file is placed in the named file
rather than using the name of the
.I cppmakefile
with a .i extension.
.TP 15
.B -v
Verbose mode. Lots of (debugging) information will be printed.
.PP
The order in which the arguments are specified is not significant
but if
.B cppmake
is invoked in the first form,
the first argument or unknown option marks the start of the arguments
to be passed directly to
.BR make .
.SH "ENVIRONMENT VARIABLES"
.PP
.TP 15
.B CPPMAKEMAKE
The path to a make program (eg /bin/ndmake). By default,
.B cppmake
will use whatever program named
.I make
that can be found in the
.B PATH
environment variable.
.TP 15
.B CPPMAKECPP
The path to a C preprocessor (eg /bin/cpp). By default,
.B cppmake
will use the program named
.IR /lib/cpp .
.SH "OPERATION"
.PP
.B Cppmake
operates on
.IR cppmakefiles .
These are
.I makefiles
that have been augmented with
.B cpp
constructs. The addition of these constructs, in particular conditional
inclusion and macro expansion, allows site dependent makefiles to be combined
into a single
.IR makefile .
.PP
.B Cppmake
preprocesses the
.I cppmakefile
to produce an input file for
.BR cpp .
This step is required since different versions of
.B cpp
treat whitespace and line continuation differently. This preprocessing phase
quotes comment lines, quotes empty lines, retains
.B cpp
directive lines, quotes whitespace where needed and
quotes line continuations (except in
.B cpp
directives where line continuations cause lines to be merged). A preamble is
inserted into the file. The resultant cpp input file is then passed to
.B cpp
for processing.  Typical contents of the preamble are:
.sp 1
.RS
#define CPPMAKEMAKE \fImake\fR
.br
#define CPPMAKECPP \fI/lib/cpp\fR
.br
#define CPPMAKEFILE \fImakefile.cpp\fR
.br
#define CPPMAKEMAKEFILE \fI/tmp/makeAA.AAA\fR
.RE
.sp 1
.PD 0
.TP 22
CPPMAKEMAKE
The name of the make program.
.TP 22
CPPMAKECPP
The name of the C preprocessor.
.TP 22
CPPMAKEFILE
The name of the cppmake file.
.TP 22
CPPMAKEMAKEFILE
The name of the makefile.
.PD
.PP
The output from
.B cpp
is processed again by
.BR cppmake .
.B Cpp
line control information is removed.
Quoted whitespace, comments and empty lines from the preprocessing phase
are unquoted.
Occurrences of ## (including any surrounding
whitespace) are
removed (allowing token concatention). Occurrences of @@
are replaced with \\n with any preceding whitespace deleted.
.PP
The processed output from
.B cpp
becomes the
.I makefile
and is passed to
.B make
for processing.
.SH "SEE ALSO"
make(1)
.br
imake(1) [Todd Brunhoff (Tektronix Inc) and Project Athena]
.SH AUTHOR
Earl Chew
.SH "BUGS"
.PP
Unknown options mixed with known options causes
.B cppmake
to become confused about which belongs where.
