/*
 * @(#)desc.c	1.5 91/09/05
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/file.h>
#include <sys/time.h>
#include <sys/ptrace.h>

#include "defs.h"


static Xlat fcntlcmds[] = {
	F_DUPFD, 	"DUPFD",
	F_GETFD,	"GETFD",
	F_SETFD,	"SETFD",
	F_GETFL,	"F_GETFL",
	F_SETFL,	"F_SETFL",
	F_GETLK,	"F_GETLK",
	F_SETLK,	"F_SETLK",
	F_SETLKW,	"F_SETLKW",
	F_GETOWN,	"F_GETOWN",
	F_SETOWN,	"F_SETOWN",
#ifndef linux
	F_RSETLK,	"F_RSETLK",
	F_RSETLKW,	"F_RSETLKW",
	F_RGETLK,	"F_RGETLK",
	F_CNVT,		"F_CNVT",
#else
	O_NDELAY,	"O_NDELAY",
#endif
	0,		NULL,
};
#ifndef linux
static Xlat flockcmds[] = {
	LOCK_SH,	"LOCK_SH",
	LOCK_EX,	"LOCK_EX",
	LOCK_NB,	"LOCK_NB",
	LOCK_UN,	"LOCK_UN",
	0,		NULL,
};
#endif

int
sys_fcntl(tcp)
struct tcb *tcp;
{
	if (entering(tcp)) {
		fprintf(outf, "%u, ", tcp->u_args[0]);
		printxval(fcntlcmds, tcp->u_args[1], "F_???");
		fprintf(outf, ", %#x", tcp->u_args[2]);
	}
	return 0;
}

#ifndef linux
int
sys_flock(tcp)
struct tcb *tcp;
{
	if (entering(tcp)) {
		fprintf(outf, "%u, ", tcp->u_args[0]);
		printflags(flockcmds, tcp->u_args[1]);
	}
	return 0;
}
#endif

int
sys_close(tcp)
struct tcb *tcp;
{
	if (entering(tcp)) {
		fprintf(outf, "%u", tcp->u_args[0]);
	}
	return 0;
}

int
sys_dup(tcp)
struct tcb *tcp;
{
	if (entering(tcp)) {
		fprintf(outf, "%u", tcp->u_args[0]);
	}
	return 0;
}

int
sys_dup2(tcp)
struct tcb *tcp;
{
	if (entering(tcp)) {
		fprintf(outf, "%u, %u", tcp->u_args[0], tcp->u_args[1]);
	}
	return 0;
}

int
sys_getdtablesize(tcp)
struct tcb *tcp;
{
	return 0;
}

int
sys_select(tcp)
struct tcb *tcp;
{
	int i, j, nfds;
	fd_set fds;
	struct timeval tv;
	static char outstr[1024];
#ifdef linux
	int args[5];
#define	ARGS	args
	umove(tcp->pid, tcp->u_args[0], sizeof args, (char *) args);
#else
#define	ARGS	tcp->u_args
#endif

	if (entering(tcp)) {
		nfds = ARGS[0];
		fprintf(outf, "%u", nfds);
		for (i = 0; i < 3; i++) {
			if (ARGS[i+1] == 0) {
				fprintf(outf, ", 0", j);
				continue;
			}

			fprintf(outf, ", fdset%u:[", i);
			umove(tcp->pid, ARGS[i+1], sizeof fds, (char *)&fds);
			for (j = 0; j < nfds; j++)
				if (FD_ISSET(j, &fds))
					fprintf(outf, " %u", j);
			fprintf(outf, "]");
		}
		if (ARGS[4]) {
			umove(tcp->pid, ARGS[4], sizeof tv, (char *)&tv);
			fprintf(outf, ", tv:[%u,%u]", tv.tv_sec, tv.tv_usec);
		} else
			fprintf(outf, ", (struct timeval *)0");
	} else {
		int cumlen = 0;

		if (syserror(tcp))
			return 0;

		if ((nfds = tcp->u_rval) == 0) {
			tcp->auxstr = "Timeout";
			return RVAL_STR;
		}
		outstr[0] = '\0';
		for (i = 0; i < 3; i++) {
			int first = 1;
			char str[20];

			tcp->auxstr = outstr;
			if (ARGS[i+1] == 0) {
				continue;
			}
			umove(tcp->pid, ARGS[i+1], sizeof fds, (char *)&fds);
			for (j = 0; j < ARGS[0]; j++) {
				if (FD_ISSET(j, &fds)) {
					if (first)
						sprintf(str, "fdset%u:[%u",
								i, j), first=0;
					else
						sprintf(str, " %u", j);

					--nfds;
					if ((cumlen += strlen(str)) < sizeof outstr)
						strcat(outstr, str);
				}
			}
			if (cumlen) strcat(outstr, "]");
			if (nfds == 0) break;
		}
		return RVAL_STR;
	}
	return 0;
}
