.TH PFDISK 8 "Oct 1990" "Release 1.3"
.SH NAME
pfdisk \- partition fixed disk
.SH SYNOPSIS
.B pfdisk
.I device
.SH DESCRIPTION
.LP
.B pfdisk
partitions the fixed disk identified as
.I device
into (at most) four parts, each of which may
be independently loaded with an operating system.
The actual name of
.I device
depends on the operating system in use.
For ESIX (System V/386) the device name is either
"/dev/rdsk/0s0" or "/dev/rdsk/1s0".
For Minix, it is "/dev/hd0" or "/dev/hd5".
For MS-DOS it is a single digit (zero or one).
.LP
.B pfdisk
reads the hard disk partition table from block zero of
.I device
into memory and allows the user to examine, modify, or save the
partition table.  A regular file may be used instead of a real
.I device
for testing purposes, though the device geometry must be specified
manually, and some systems will requrire a file-name argument with
the "R" and "W" commands (DOS, ESIX).
.LP
The partition table on
.I device
is NOT modified unless the write command (W) is used with no argument.
.SH USAGE
.SS Commands
.LP
All
.B pfdisk
commands consist of a command word followed by optional
blank-separated command arguments.
Note that only the first letter of a command word is significant
(except for "wq" and "q!").
All command letters are accepted in either upper or lower case.
Numeric arguments are specified using C syntax.
Extra arguments are silently ignored.
.LP
The commands are:
.TP
.B ?
Prints a command summary (help).
.TP
.BI 1 " sys_id first last sys_name"
Set the partition table entry for part one, using:
.I sys_id
as its system ID code,
.I first
as the lowest numbered cylinder it uses,
.I last
as the highest numbered cylinder it uses, and
.I sys_name
(optional) as the system name (in the menu name table).
.TP
.BI 2|3|4 " sys-id first last sys-name"
Similar to
.B 1
but sets partition two, three, or four, respectively.
.TP
.BI A " number"
Mark partition
.I number
as active (so it will be used for booting).  If
.I number
is zero, no partition will be active.
.TP
.BI G " cylinders heads sectors"
Inform
.B pfdisk
what the geometry of the device is.
.TP
.B I
Print a summary of the known ID codes.
.TP
.B L
List the partition table.
See
.B "Output Format"
below.
.TP
.B Q
Quit without saving.  If the memory copy of the partition table was
modified, a warning will be issued and the command ignored.
.TP
.B Q!
Quit, even if the memory copy of the partition table was not saved.
.TP
.BI R " file-name"
Read boot sector from
.I file-name
(if given) otherwise read from
.I device.
.TP
.BI W " file-name"
Write boot sector to
.I file-name.
(if given) otherwise write to
.I device.
.TP
.B WQ
Same as "write" followed by "quit".
.TP
.B #
This line is a comment (to be ignored).
.SS "Output Format"
.LP
Here is a sample of the output from the
.B L
command:
.LP
.nf
# Partition table on device: /dev/rdsk/0s0
geometry 1222 15 34 (cyls heads sectors)
#  ID  First(cyl)  Last(cyl)  Name     # start, length (sectors)
1   4      0        127       MS-LOSS  # 34, 65246
2 129    128        255       Minix    # 65280, 65280
3   0      0          0                # 0, 0
4  99    256       1220       ESIX     # 130560, 492150
# note:  last(4): phys=(1023,14,34) logical=(1220,14,34)
active: 4
.fi
.LP
This output format is carefully constructed so that it
may be saved in a file  (by redirecting standard output)
and later used as input (by redirecting standard input).
On a UNIX system, one can save this output using the command:
.IP
(echo L) | pfdisk device-name >
.I save-file
.LP The printable representation saved in
.I save-file
is a complete record of the partition table.
On a UNIX system, one could use
.I save-file
to re-initialize the partition table using the command:
.IP
(cat save-file ; echo wq) | pfdisk device-name
.LP
Consistency of each partition table entry is checked
while the table is listed.  Any inconsistencies discovered
are reported in a commentary note as shown above.
.SS "Physical vs. Logical"
.LP
Each partition table entry has both "physical" and a "logical" fields.
The physical fields specify the lowest and highest cylinder,head,sector
combinations to be used in that partition.  The logical start field
has the total number of sectors which precede this partition, and
the logical length field has the total number of sectors contained
in this partition.  These fields should be self consistent unless
the disk has more than 1024 cylinders.
.LP
The physical cylinder fields are only ten-bits wide so the contents
are limited to 1023. The logical sector fields are 32 bits wide and
always show the true logical beginning and length of the partition.
Generally, the physical start field is used only to locate the
secondary boot sector, and the logical start and length fields are
used to actually delimit the partition used by a particular system.
.SS "Partition Names"
.LP
The
.B Name
field in the partition table is treated specially if the
.B bootmenu
program is installed in the primary boot sector.
(See the file bootmenu.doc for more information.)
.B pfdisk
can recognize the name table used by
.B bootmenu
and will show the actual names present in that name table.
If any other boot program is used then the
.B Name
field reflects the result of a table-lookup of the system ID.
.LP
If you provide a name when setting any partition entry, the
boot-sector is marked as using a name table, so that on
subsequent uses of
.B pfdisk
you will see the partition names you have specified.
.SS "Boot program replacement"
.LP
You can replace the boot program in your boot sector without
affecting the partition table by using
.B pfdisk
as follows.  First, (as always) save a copy of the current boot
sector (on a floppy) using the "W file" command.  Then, use the
"R file" command to read the new boot program.
If the boot program read in is less than 446 bytes long, the
partition table will be unchanged.
.LP
Unlike the DOS or UNIX
.B fdisk
programs,
.B pfdisk
has
.I NO
boot program compiled into its executable image.
If you wish to use
.B pfdisk
to partition a newly formatted hard disk, you must have a boot program
image available to read in using the "r file" command.
Two boot programs, "bootmenu.bin" and "bootauto.bin" are distributed with
.B pfdisk
and should be found with its source files.  See the file bootmenu.doc
for further information about these boot programs.
.SH AUTHOR
Gordon W. Ross
