/*
 * Copyright 2020 Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER(S) OR AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 */
#ifndef _vcn_2_6_0_OFFSET_HEADER
#define _vcn_2_6_0_OFFSET_HEADER



// addressBlock: uvd0_ecpudec
// base address: 0x1fd00
#define regUVD_VCPU_CACHE_OFFSET0                                                                       0x0140
#define regUVD_VCPU_CACHE_OFFSET0_BASE_IDX                                                              1
#define regUVD_VCPU_CACHE_SIZE0                                                                         0x0141
#define regUVD_VCPU_CACHE_SIZE0_BASE_IDX                                                                1
#define regUVD_VCPU_CACHE_OFFSET1                                                                       0x0142
#define regUVD_VCPU_CACHE_OFFSET1_BASE_IDX                                                              1
#define regUVD_VCPU_CACHE_SIZE1                                                                         0x0143
#define regUVD_VCPU_CACHE_SIZE1_BASE_IDX                                                                1
#define regUVD_VCPU_CACHE_OFFSET2                                                                       0x0144
#define regUVD_VCPU_CACHE_OFFSET2_BASE_IDX                                                              1
#define regUVD_VCPU_CACHE_SIZE2                                                                         0x0145
#define regUVD_VCPU_CACHE_SIZE2_BASE_IDX                                                                1
#define regUVD_VCPU_CACHE_OFFSET3                                                                       0x0146
#define regUVD_VCPU_CACHE_OFFSET3_BASE_IDX                                                              1
#define regUVD_VCPU_CACHE_SIZE3                                                                         0x0147
#define regUVD_VCPU_CACHE_SIZE3_BASE_IDX                                                                1
#define regUVD_VCPU_CACHE_OFFSET4                                                                       0x0148
#define regUVD_VCPU_CACHE_OFFSET4_BASE_IDX                                                              1
#define regUVD_VCPU_CACHE_SIZE4                                                                         0x0149
#define regUVD_VCPU_CACHE_SIZE4_BASE_IDX                                                                1
#define regUVD_VCPU_CACHE_OFFSET5                                                                       0x014a
#define regUVD_VCPU_CACHE_OFFSET5_BASE_IDX                                                              1
#define regUVD_VCPU_CACHE_SIZE5                                                                         0x014b
#define regUVD_VCPU_CACHE_SIZE5_BASE_IDX                                                                1
#define regUVD_VCPU_CACHE_OFFSET6                                                                       0x014c
#define regUVD_VCPU_CACHE_OFFSET6_BASE_IDX                                                              1
#define regUVD_VCPU_CACHE_SIZE6                                                                         0x014d
#define regUVD_VCPU_CACHE_SIZE6_BASE_IDX                                                                1
#define regUVD_VCPU_CACHE_OFFSET7                                                                       0x014e
#define regUVD_VCPU_CACHE_OFFSET7_BASE_IDX                                                              1
#define regUVD_VCPU_CACHE_SIZE7                                                                         0x014f
#define regUVD_VCPU_CACHE_SIZE7_BASE_IDX                                                                1
#define regUVD_VCPU_CACHE_OFFSET8                                                                       0x0150
#define regUVD_VCPU_CACHE_OFFSET8_BASE_IDX                                                              1
#define regUVD_VCPU_CACHE_SIZE8                                                                         0x0151
#define regUVD_VCPU_CACHE_SIZE8_BASE_IDX                                                                1
#define regUVD_VCPU_NONCACHE_OFFSET0                                                                    0x0152
#define regUVD_VCPU_NONCACHE_OFFSET0_BASE_IDX                                                           1
#define regUVD_VCPU_NONCACHE_SIZE0                                                                      0x0153
#define regUVD_VCPU_NONCACHE_SIZE0_BASE_IDX                                                             1
#define regUVD_VCPU_NONCACHE_OFFSET1                                                                    0x0154
#define regUVD_VCPU_NONCACHE_OFFSET1_BASE_IDX                                                           1
#define regUVD_VCPU_NONCACHE_SIZE1                                                                      0x0155
#define regUVD_VCPU_NONCACHE_SIZE1_BASE_IDX                                                             1
#define regUVD_VCPU_CNTL                                                                                0x0156
#define regUVD_VCPU_CNTL_BASE_IDX                                                                       1
#define regUVD_VCPU_PRID                                                                                0x0157
#define regUVD_VCPU_PRID_BASE_IDX                                                                       1
#define regUVD_VCPU_TRCE                                                                                0x0158
#define regUVD_VCPU_TRCE_BASE_IDX                                                                       1
#define regUVD_VCPU_TRCE_RD                                                                             0x0159
#define regUVD_VCPU_TRCE_RD_BASE_IDX                                                                    1
#define regUVD_VCPU_IND_INDEX                                                                           0x015b
#define regUVD_VCPU_IND_INDEX_BASE_IDX                                                                  1
#define regUVD_VCPU_IND_DATA                                                                            0x015c
#define regUVD_VCPU_IND_DATA_BASE_IDX                                                                   1


// addressBlock: uvd0_jpegnpdec
// base address: 0x1e200
#define regUVD_JPEG_CNTL                                                                                0x0080
#define regUVD_JPEG_CNTL_BASE_IDX                                                                       0
#define regUVD_JPEG_RB_BASE                                                                             0x0081
#define regUVD_JPEG_RB_BASE_BASE_IDX                                                                    0
#define regUVD_JPEG_RB_WPTR                                                                             0x0082
#define regUVD_JPEG_RB_WPTR_BASE_IDX                                                                    0
#define regUVD_JPEG_RB_RPTR                                                                             0x0083
#define regUVD_JPEG_RB_RPTR_BASE_IDX                                                                    0
#define regUVD_JPEG_RB_SIZE                                                                             0x0084
#define regUVD_JPEG_RB_SIZE_BASE_IDX                                                                    0
#define regUVD_JPEG_DEC_CNT                                                                             0x0085
#define regUVD_JPEG_DEC_CNT_BASE_IDX                                                                    0
#define regUVD_JPEG_SPS_INFO                                                                            0x0086
#define regUVD_JPEG_SPS_INFO_BASE_IDX                                                                   0
#define regUVD_JPEG_SPS1_INFO                                                                           0x0087
#define regUVD_JPEG_SPS1_INFO_BASE_IDX                                                                  0
#define regUVD_JPEG_RE_TIMER                                                                            0x0088
#define regUVD_JPEG_RE_TIMER_BASE_IDX                                                                   0
#define regUVD_JPEG_DEC_SCRATCH0                                                                        0x0089
#define regUVD_JPEG_DEC_SCRATCH0_BASE_IDX                                                               0
#define regUVD_JPEG_INT_EN                                                                              0x008a
#define regUVD_JPEG_INT_EN_BASE_IDX                                                                     0
#define regUVD_JPEG_INT_STAT                                                                            0x008b
#define regUVD_JPEG_INT_STAT_BASE_IDX                                                                   0
#define regUVD_JPEG_TIER_CNTL0                                                                          0x008d
#define regUVD_JPEG_TIER_CNTL0_BASE_IDX                                                                 0
#define regUVD_JPEG_TIER_CNTL1                                                                          0x008e
#define regUVD_JPEG_TIER_CNTL1_BASE_IDX                                                                 0
#define regUVD_JPEG_TIER_CNTL2                                                                          0x008f
#define regUVD_JPEG_TIER_CNTL2_BASE_IDX                                                                 0
#define regUVD_JPEG_TIER_STATUS                                                                         0x0090
#define regUVD_JPEG_TIER_STATUS_BASE_IDX                                                                0
#define regUVD_JPEG_OUTBUF_CNTL                                                                         0x009c
#define regUVD_JPEG_OUTBUF_CNTL_BASE_IDX                                                                0
#define regUVD_JPEG_OUTBUF_WPTR                                                                         0x009d
#define regUVD_JPEG_OUTBUF_WPTR_BASE_IDX                                                                0
#define regUVD_JPEG_OUTBUF_RPTR                                                                         0x009e
#define regUVD_JPEG_OUTBUF_RPTR_BASE_IDX                                                                0
#define regUVD_JPEG_PITCH                                                                               0x009f
#define regUVD_JPEG_PITCH_BASE_IDX                                                                      0
#define regUVD_JPEG_UV_PITCH                                                                            0x00a0
#define regUVD_JPEG_UV_PITCH_BASE_IDX                                                                   0
#define regJPEG_DEC_Y_GFX8_TILING_SURFACE                                                               0x00a1
#define regJPEG_DEC_Y_GFX8_TILING_SURFACE_BASE_IDX                                                      0
#define regJPEG_DEC_UV_GFX8_TILING_SURFACE                                                              0x00a2
#define regJPEG_DEC_UV_GFX8_TILING_SURFACE_BASE_IDX                                                     0
#define regJPEG_DEC_GFX8_ADDR_CONFIG                                                                    0x00a3
#define regJPEG_DEC_GFX8_ADDR_CONFIG_BASE_IDX                                                           0
#define regJPEG_DEC_Y_GFX10_TILING_SURFACE                                                              0x00a4
#define regJPEG_DEC_Y_GFX10_TILING_SURFACE_BASE_IDX                                                     0
#define regJPEG_DEC_UV_GFX10_TILING_SURFACE                                                             0x00a5
#define regJPEG_DEC_UV_GFX10_TILING_SURFACE_BASE_IDX                                                    0
#define regJPEG_DEC_GFX10_ADDR_CONFIG                                                                   0x00a6
#define regJPEG_DEC_GFX10_ADDR_CONFIG_BASE_IDX                                                          0
#define regJPEG_DEC_ADDR_MODE                                                                           0x00a7
#define regJPEG_DEC_ADDR_MODE_BASE_IDX                                                                  0
#define regUVD_JPEG_OUTPUT_XY                                                                           0x00a8
#define regUVD_JPEG_OUTPUT_XY_BASE_IDX                                                                  0
#define regUVD_JPEG_GPCOM_CMD                                                                           0x00a9
#define regUVD_JPEG_GPCOM_CMD_BASE_IDX                                                                  0
#define regUVD_JPEG_GPCOM_DATA0                                                                         0x00aa
#define regUVD_JPEG_GPCOM_DATA0_BASE_IDX                                                                0
#define regUVD_JPEG_GPCOM_DATA1                                                                         0x00ab
#define regUVD_JPEG_GPCOM_DATA1_BASE_IDX                                                                0
#define regUVD_JPEG_INDEX                                                                               0x00ac
#define regUVD_JPEG_INDEX_BASE_IDX                                                                      0
#define regUVD_JPEG_DATA                                                                                0x00ad
#define regUVD_JPEG_DATA_BASE_IDX                                                                       0
#define regUVD_JPEG_SCRATCH1                                                                            0x00ae
#define regUVD_JPEG_SCRATCH1_BASE_IDX                                                                   0
#define regUVD_JPEG_DEC_SOFT_RST                                                                        0x00af
#define regUVD_JPEG_DEC_SOFT_RST_BASE_IDX                                                               0


// addressBlock: uvd0_lmi_adpdec
// base address: 0x20870
#define regUVD_LMI_RE_64BIT_BAR_LOW                                                                     0x041c
#define regUVD_LMI_RE_64BIT_BAR_LOW_BASE_IDX                                                            1
#define regUVD_LMI_RE_64BIT_BAR_HIGH                                                                    0x041d
#define regUVD_LMI_RE_64BIT_BAR_HIGH_BASE_IDX                                                           1
#define regUVD_LMI_IT_64BIT_BAR_LOW                                                                     0x041e
#define regUVD_LMI_IT_64BIT_BAR_LOW_BASE_IDX                                                            1
#define regUVD_LMI_IT_64BIT_BAR_HIGH                                                                    0x041f
#define regUVD_LMI_IT_64BIT_BAR_HIGH_BASE_IDX                                                           1
#define regUVD_LMI_MP_64BIT_BAR_LOW                                                                     0x0420
#define regUVD_LMI_MP_64BIT_BAR_LOW_BASE_IDX                                                            1
#define regUVD_LMI_MP_64BIT_BAR_HIGH                                                                    0x0421
#define regUVD_LMI_MP_64BIT_BAR_HIGH_BASE_IDX                                                           1
#define regUVD_LMI_CM_64BIT_BAR_LOW                                                                     0x0422
#define regUVD_LMI_CM_64BIT_BAR_LOW_BASE_IDX                                                            1
#define regUVD_LMI_CM_64BIT_BAR_HIGH                                                                    0x0423
#define regUVD_LMI_CM_64BIT_BAR_HIGH_BASE_IDX                                                           1
#define regUVD_LMI_DB_64BIT_BAR_LOW                                                                     0x0424
#define regUVD_LMI_DB_64BIT_BAR_LOW_BASE_IDX                                                            1
#define regUVD_LMI_DB_64BIT_BAR_HIGH                                                                    0x0425
#define regUVD_LMI_DB_64BIT_BAR_HIGH_BASE_IDX                                                           1
#define regUVD_LMI_DBW_64BIT_BAR_LOW                                                                    0x0426
#define regUVD_LMI_DBW_64BIT_BAR_LOW_BASE_IDX                                                           1
#define regUVD_LMI_DBW_64BIT_BAR_HIGH                                                                   0x0427
#define regUVD_LMI_DBW_64BIT_BAR_HIGH_BASE_IDX                                                          1
#define regUVD_LMI_IDCT_64BIT_BAR_LOW                                                                   0x0428
#define regUVD_LMI_IDCT_64BIT_BAR_LOW_BASE_IDX                                                          1
#define regUVD_LMI_IDCT_64BIT_BAR_HIGH                                                                  0x0429
#define regUVD_LMI_IDCT_64BIT_BAR_HIGH_BASE_IDX                                                         1
#define regUVD_LMI_MPRD_S0_64BIT_BAR_LOW                                                                0x042a
#define regUVD_LMI_MPRD_S0_64BIT_BAR_LOW_BASE_IDX                                                       1
#define regUVD_LMI_MPRD_S0_64BIT_BAR_HIGH                                                               0x042b
#define regUVD_LMI_MPRD_S0_64BIT_BAR_HIGH_BASE_IDX                                                      1
#define regUVD_LMI_MPRD_S1_64BIT_BAR_LOW                                                                0x042c
#define regUVD_LMI_MPRD_S1_64BIT_BAR_LOW_BASE_IDX                                                       1
#define regUVD_LMI_MPRD_S1_64BIT_BAR_HIGH                                                               0x042d
#define regUVD_LMI_MPRD_S1_64BIT_BAR_HIGH_BASE_IDX                                                      1
#define regUVD_LMI_MPRD_DBW_64BIT_BAR_LOW                                                               0x042e
#define regUVD_LMI_MPRD_DBW_64BIT_BAR_LOW_BASE_IDX                                                      1
#define regUVD_LMI_MPRD_DBW_64BIT_BAR_HIGH                                                              0x042f
#define regUVD_LMI_MPRD_DBW_64BIT_BAR_HIGH_BASE_IDX                                                     1
#define regUVD_LMI_MPC_64BIT_BAR_LOW                                                                    0x0430
#define regUVD_LMI_MPC_64BIT_BAR_LOW_BASE_IDX                                                           1
#define regUVD_LMI_MPC_64BIT_BAR_HIGH                                                                   0x0431
#define regUVD_LMI_MPC_64BIT_BAR_HIGH_BASE_IDX                                                          1
#define regUVD_LMI_RBC_RB_64BIT_BAR_LOW                                                                 0x0432
#define regUVD_LMI_RBC_RB_64BIT_BAR_LOW_BASE_IDX                                                        1
#define regUVD_LMI_RBC_RB_64BIT_BAR_HIGH                                                                0x0433
#define regUVD_LMI_RBC_RB_64BIT_BAR_HIGH_BASE_IDX                                                       1
#define regUVD_LMI_RBC_IB_64BIT_BAR_LOW                                                                 0x0434
#define regUVD_LMI_RBC_IB_64BIT_BAR_LOW_BASE_IDX                                                        1
#define regUVD_LMI_RBC_IB_64BIT_BAR_HIGH                                                                0x0435
#define regUVD_LMI_RBC_IB_64BIT_BAR_HIGH_BASE_IDX                                                       1
#define regUVD_LMI_LBSI_64BIT_BAR_LOW                                                                   0x0436
#define regUVD_LMI_LBSI_64BIT_BAR_LOW_BASE_IDX                                                          1
#define regUVD_LMI_LBSI_64BIT_BAR_HIGH                                                                  0x0437
#define regUVD_LMI_LBSI_64BIT_BAR_HIGH_BASE_IDX                                                         1
#define regUVD_LMI_VCPU_NC0_64BIT_BAR_LOW                                                               0x0438
#define regUVD_LMI_VCPU_NC0_64BIT_BAR_LOW_BASE_IDX                                                      1
#define regUVD_LMI_VCPU_NC0_64BIT_BAR_HIGH                                                              0x0439
#define regUVD_LMI_VCPU_NC0_64BIT_BAR_HIGH_BASE_IDX                                                     1
#define regUVD_LMI_VCPU_NC1_64BIT_BAR_LOW                                                               0x043a
#define regUVD_LMI_VCPU_NC1_64BIT_BAR_LOW_BASE_IDX                                                      1
#define regUVD_LMI_VCPU_NC1_64BIT_BAR_HIGH                                                              0x043b
#define regUVD_LMI_VCPU_NC1_64BIT_BAR_HIGH_BASE_IDX                                                     1
#define regUVD_LMI_VCPU_CACHE_64BIT_BAR_LOW                                                             0x043c
#define regUVD_LMI_VCPU_CACHE_64BIT_BAR_LOW_BASE_IDX                                                    1
#define regUVD_LMI_VCPU_CACHE_64BIT_BAR_HIGH                                                            0x043d
#define regUVD_LMI_VCPU_CACHE_64BIT_BAR_HIGH_BASE_IDX                                                   1
#define regUVD_LMI_CENC_64BIT_BAR_LOW                                                                   0x043e
#define regUVD_LMI_CENC_64BIT_BAR_LOW_BASE_IDX                                                          1
#define regUVD_LMI_CENC_64BIT_BAR_HIGH                                                                  0x043f
#define regUVD_LMI_CENC_64BIT_BAR_HIGH_BASE_IDX                                                         1
#define regUVD_LMI_SRE_64BIT_BAR_LOW                                                                    0x0440
#define regUVD_LMI_SRE_64BIT_BAR_LOW_BASE_IDX                                                           1
#define regUVD_LMI_SRE_64BIT_BAR_HIGH                                                                   0x0441
#define regUVD_LMI_SRE_64BIT_BAR_HIGH_BASE_IDX                                                          1
#define regUVD_LMI_MIF_GPGPU_64BIT_BAR_LOW                                                              0x0442
#define regUVD_LMI_MIF_GPGPU_64BIT_BAR_LOW_BASE_IDX                                                     1
#define regUVD_LMI_MIF_GPGPU_64BIT_BAR_HIGH                                                             0x0443
#define regUVD_LMI_MIF_GPGPU_64BIT_BAR_HIGH_BASE_IDX                                                    1
#define regUVD_LMI_MIF_CURR_LUMA_64BIT_BAR_LOW                                                          0x0444
#define regUVD_LMI_MIF_CURR_LUMA_64BIT_BAR_LOW_BASE_IDX                                                 1
#define regUVD_LMI_MIF_CURR_LUMA_64BIT_BAR_HIGH                                                         0x0445
#define regUVD_LMI_MIF_CURR_LUMA_64BIT_BAR_HIGH_BASE_IDX                                                1
#define regUVD_LMI_MIF_CURR_CHROMA_64BIT_BAR_LOW                                                        0x0446
#define regUVD_LMI_MIF_CURR_CHROMA_64BIT_BAR_LOW_BASE_IDX                                               1
#define regUVD_LMI_MIF_CURR_CHROMA_64BIT_BAR_HIGH                                                       0x0447
#define regUVD_LMI_MIF_CURR_CHROMA_64BIT_BAR_HIGH_BASE_IDX                                              1
#define regUVD_LMI_MIF_REF_64BIT_BAR_LOW                                                                0x0448
#define regUVD_LMI_MIF_REF_64BIT_BAR_LOW_BASE_IDX                                                       1
#define regUVD_LMI_MIF_REF_64BIT_BAR_HIGH                                                               0x0449
#define regUVD_LMI_MIF_REF_64BIT_BAR_HIGH_BASE_IDX                                                      1
#define regUVD_LMI_MIF_DBW_64BIT_BAR_LOW                                                                0x044a
#define regUVD_LMI_MIF_DBW_64BIT_BAR_LOW_BASE_IDX                                                       1
#define regUVD_LMI_MIF_DBW_64BIT_BAR_HIGH                                                               0x044b
#define regUVD_LMI_MIF_DBW_64BIT_BAR_HIGH_BASE_IDX                                                      1
#define regUVD_LMI_MIF_CM_COLOC_64BIT_BAR_LOW                                                           0x044c
#define regUVD_LMI_MIF_CM_COLOC_64BIT_BAR_LOW_BASE_IDX                                                  1
#define regUVD_LMI_MIF_CM_COLOC_64BIT_BAR_HIGH                                                          0x044d
#define regUVD_LMI_MIF_CM_COLOC_64BIT_BAR_HIGH_BASE_IDX                                                 1
#define regUVD_LMI_MIF_BSP0_64BIT_BAR_LOW                                                               0x044e
#define regUVD_LMI_MIF_BSP0_64BIT_BAR_LOW_BASE_IDX                                                      1
#define regUVD_LMI_MIF_BSP0_64BIT_BAR_HIGH                                                              0x044f
#define regUVD_LMI_MIF_BSP0_64BIT_BAR_HIGH_BASE_IDX                                                     1
#define regUVD_LMI_MIF_BSP1_64BIT_BAR_LOW                                                               0x0450
#define regUVD_LMI_MIF_BSP1_64BIT_BAR_LOW_BASE_IDX                                                      1
#define regUVD_LMI_MIF_BSP1_64BIT_BAR_HIGH                                                              0x0451
#define regUVD_LMI_MIF_BSP1_64BIT_BAR_HIGH_BASE_IDX                                                     1
#define regUVD_LMI_MIF_BSP2_64BIT_BAR_LOW                                                               0x0452
#define regUVD_LMI_MIF_BSP2_64BIT_BAR_LOW_BASE_IDX                                                      1
#define regUVD_LMI_MIF_BSP2_64BIT_BAR_HIGH                                                              0x0453
#define regUVD_LMI_MIF_BSP2_64BIT_BAR_HIGH_BASE_IDX                                                     1
#define regUVD_LMI_MIF_BSP3_64BIT_BAR_LOW                                                               0x0454
#define regUVD_LMI_MIF_BSP3_64BIT_BAR_LOW_BASE_IDX                                                      1
#define regUVD_LMI_MIF_BSP3_64BIT_BAR_HIGH                                                              0x0455
#define regUVD_LMI_MIF_BSP3_64BIT_BAR_HIGH_BASE_IDX                                                     1
#define regUVD_LMI_MIF_BSD0_64BIT_BAR_LOW                                                               0x0456
#define regUVD_LMI_MIF_BSD0_64BIT_BAR_LOW_BASE_IDX                                                      1
#define regUVD_LMI_MIF_BSD0_64BIT_BAR_HIGH                                                              0x0457
#define regUVD_LMI_MIF_BSD0_64BIT_BAR_HIGH_BASE_IDX                                                     1
#define regUVD_LMI_MIF_BSD1_64BIT_BAR_LOW                                                               0x0458
#define regUVD_LMI_MIF_BSD1_64BIT_BAR_LOW_BASE_IDX                                                      1
#define regUVD_LMI_MIF_BSD1_64BIT_BAR_HIGH                                                              0x0459
#define regUVD_LMI_MIF_BSD1_64BIT_BAR_HIGH_BASE_IDX                                                     1
#define regUVD_LMI_MIF_BSD2_64BIT_BAR_LOW                                                               0x045a
#define regUVD_LMI_MIF_BSD2_64BIT_BAR_LOW_BASE_IDX                                                      1
#define regUVD_LMI_MIF_BSD2_64BIT_BAR_HIGH                                                              0x045b
#define regUVD_LMI_MIF_BSD2_64BIT_BAR_HIGH_BASE_IDX                                                     1
#define regUVD_LMI_MIF_BSD3_64BIT_BAR_LOW                                                               0x045c
#define regUVD_LMI_MIF_BSD3_64BIT_BAR_LOW_BASE_IDX                                                      1
#define regUVD_LMI_MIF_BSD3_64BIT_BAR_HIGH                                                              0x045d
#define regUVD_LMI_MIF_BSD3_64BIT_BAR_HIGH_BASE_IDX                                                     1
#define regUVD_LMI_MIF_BSD4_64BIT_BAR_LOW                                                               0x045e
#define regUVD_LMI_MIF_BSD4_64BIT_BAR_LOW_BASE_IDX                                                      1
#define regUVD_LMI_MIF_BSD4_64BIT_BAR_HIGH                                                              0x045f
#define regUVD_LMI_MIF_BSD4_64BIT_BAR_HIGH_BASE_IDX                                                     1
#define regUVD_LMI_VCPU_CACHE1_64BIT_BAR_LOW                                                            0x0468
#define regUVD_LMI_VCPU_CACHE1_64BIT_BAR_LOW_BASE_IDX                                                   1
#define regUVD_LMI_VCPU_CACHE1_64BIT_BAR_HIGH                                                           0x0469
#define regUVD_LMI_VCPU_CACHE1_64BIT_BAR_HIGH_BASE_IDX                                                  1
#define regUVD_LMI_VCPU_CACHE8_64BIT_BAR_LOW                                                            0x046a
#define regUVD_LMI_VCPU_CACHE8_64BIT_BAR_LOW_BASE_IDX                                                   1
#define regUVD_LMI_VCPU_CACHE8_64BIT_BAR_HIGH                                                           0x046b
#define regUVD_LMI_VCPU_CACHE8_64BIT_BAR_HIGH_BASE_IDX                                                  1
#define regUVD_LMI_VCPU_CACHE2_64BIT_BAR_LOW                                                            0x046c
#define regUVD_LMI_VCPU_CACHE2_64BIT_BAR_LOW_BASE_IDX                                                   1
#define regUVD_LMI_VCPU_CACHE2_64BIT_BAR_HIGH                                                           0x046d
#define regUVD_LMI_VCPU_CACHE2_64BIT_BAR_HIGH_BASE_IDX                                                  1
#define regUVD_LMI_VCPU_CACHE3_64BIT_BAR_LOW                                                            0x046e
#define regUVD_LMI_VCPU_CACHE3_64BIT_BAR_LOW_BASE_IDX                                                   1
#define regUVD_LMI_VCPU_CACHE3_64BIT_BAR_HIGH                                                           0x046f
#define regUVD_LMI_VCPU_CACHE3_64BIT_BAR_HIGH_BASE_IDX                                                  1
#define regUVD_LMI_VCPU_CACHE4_64BIT_BAR_LOW                                                            0x0470
#define regUVD_LMI_VCPU_CACHE4_64BIT_BAR_LOW_BASE_IDX                                                   1
#define regUVD_LMI_VCPU_CACHE4_64BIT_BAR_HIGH                                                           0x0471
#define regUVD_LMI_VCPU_CACHE4_64BIT_BAR_HIGH_BASE_IDX                                                  1
#define regUVD_LMI_VCPU_CACHE5_64BIT_BAR_LOW                                                            0x0472
#define regUVD_LMI_VCPU_CACHE5_64BIT_BAR_LOW_BASE_IDX                                                   1
#define regUVD_LMI_VCPU_CACHE5_64BIT_BAR_HIGH                                                           0x0473
#define regUVD_LMI_VCPU_CACHE5_64BIT_BAR_HIGH_BASE_IDX                                                  1
#define regUVD_LMI_VCPU_CACHE6_64BIT_BAR_LOW                                                            0x0474
#define regUVD_LMI_VCPU_CACHE6_64BIT_BAR_LOW_BASE_IDX                                                   1
#define regUVD_LMI_VCPU_CACHE6_64BIT_BAR_HIGH                                                           0x0475
#define regUVD_LMI_VCPU_CACHE6_64BIT_BAR_HIGH_BASE_IDX                                                  1
#define regUVD_LMI_VCPU_CACHE7_64BIT_BAR_LOW                                                            0x0476
#define regUVD_LMI_VCPU_CACHE7_64BIT_BAR_LOW_BASE_IDX                                                   1
#define regUVD_LMI_VCPU_CACHE7_64BIT_BAR_HIGH                                                           0x0477
#define regUVD_LMI_VCPU_CACHE7_64BIT_BAR_HIGH_BASE_IDX                                                  1
#define regUVD_LMI_MIF_SCLR_64BIT_BAR_LOW                                                               0x0478
#define regUVD_LMI_MIF_SCLR_64BIT_BAR_LOW_BASE_IDX                                                      1
#define regUVD_LMI_MIF_SCLR_64BIT_BAR_HIGH                                                              0x0479
#define regUVD_LMI_MIF_SCLR_64BIT_BAR_HIGH_BASE_IDX                                                     1
#define regUVD_LMI_MIF_SCLR2_64BIT_BAR_LOW                                                              0x047a
#define regUVD_LMI_MIF_SCLR2_64BIT_BAR_LOW_BASE_IDX                                                     1
#define regUVD_LMI_MIF_SCLR2_64BIT_BAR_HIGH                                                             0x047b
#define regUVD_LMI_MIF_SCLR2_64BIT_BAR_HIGH_BASE_IDX                                                    1
#define regUVD_LMI_SPH_64BIT_BAR_HIGH                                                                   0x047c
#define regUVD_LMI_SPH_64BIT_BAR_HIGH_BASE_IDX                                                          1
#define regUVD_LMI_MMSCH_NC0_64BIT_BAR_LOW                                                              0x047d
#define regUVD_LMI_MMSCH_NC0_64BIT_BAR_LOW_BASE_IDX                                                     1
#define regUVD_LMI_MMSCH_NC0_64BIT_BAR_HIGH                                                             0x047e
#define regUVD_LMI_MMSCH_NC0_64BIT_BAR_HIGH_BASE_IDX                                                    1
#define regUVD_LMI_MMSCH_NC1_64BIT_BAR_LOW                                                              0x047f
#define regUVD_LMI_MMSCH_NC1_64BIT_BAR_LOW_BASE_IDX                                                     1
#define regUVD_LMI_MMSCH_NC1_64BIT_BAR_HIGH                                                             0x0480
#define regUVD_LMI_MMSCH_NC1_64BIT_BAR_HIGH_BASE_IDX                                                    1
#define regUVD_LMI_MMSCH_NC2_64BIT_BAR_LOW                                                              0x0481
#define regUVD_LMI_MMSCH_NC2_64BIT_BAR_LOW_BASE_IDX                                                     1
#define regUVD_LMI_MMSCH_NC2_64BIT_BAR_HIGH                                                             0x0482
#define regUVD_LMI_MMSCH_NC2_64BIT_BAR_HIGH_BASE_IDX                                                    1
#define regUVD_LMI_MMSCH_NC3_64BIT_BAR_LOW                                                              0x0483
#define regUVD_LMI_MMSCH_NC3_64BIT_BAR_LOW_BASE_IDX                                                     1
#define regUVD_LMI_MMSCH_NC3_64BIT_BAR_HIGH                                                             0x0484
#define regUVD_LMI_MMSCH_NC3_64BIT_BAR_HIGH_BASE_IDX                                                    1
#define regUVD_LMI_MMSCH_NC4_64BIT_BAR_LOW                                                              0x0485
#define regUVD_LMI_MMSCH_NC4_64BIT_BAR_LOW_BASE_IDX                                                     1
#define regUVD_LMI_MMSCH_NC4_64BIT_BAR_HIGH                                                             0x0486
#define regUVD_LMI_MMSCH_NC4_64BIT_BAR_HIGH_BASE_IDX                                                    1
#define regUVD_LMI_MMSCH_NC5_64BIT_BAR_LOW                                                              0x0487
#define regUVD_LMI_MMSCH_NC5_64BIT_BAR_LOW_BASE_IDX                                                     1
#define regUVD_LMI_MMSCH_NC5_64BIT_BAR_HIGH                                                             0x0488
#define regUVD_LMI_MMSCH_NC5_64BIT_BAR_HIGH_BASE_IDX                                                    1
#define regUVD_LMI_MMSCH_NC6_64BIT_BAR_LOW                                                              0x0489
#define regUVD_LMI_MMSCH_NC6_64BIT_BAR_LOW_BASE_IDX                                                     1
#define regUVD_LMI_MMSCH_NC6_64BIT_BAR_HIGH                                                             0x048a
#define regUVD_LMI_MMSCH_NC6_64BIT_BAR_HIGH_BASE_IDX                                                    1
#define regUVD_LMI_MMSCH_NC7_64BIT_BAR_LOW                                                              0x048b
#define regUVD_LMI_MMSCH_NC7_64BIT_BAR_LOW_BASE_IDX                                                     1
#define regUVD_LMI_MMSCH_NC7_64BIT_BAR_HIGH                                                             0x048c
#define regUVD_LMI_MMSCH_NC7_64BIT_BAR_HIGH_BASE_IDX                                                    1
#define regUVD_LMI_MMSCH_NC_VMID                                                                        0x048d
#define regUVD_LMI_MMSCH_NC_VMID_BASE_IDX                                                               1
#define regUVD_LMI_MMSCH_CTRL                                                                           0x048e
#define regUVD_LMI_MMSCH_CTRL_BASE_IDX                                                                  1
#define regUVD_MMSCH_LMI_STATUS                                                                         0x048f
#define regUVD_MMSCH_LMI_STATUS_BASE_IDX                                                                1
#define regUVD_LMI_MIF_IMAGEPASTE_LUMA_64BIT_BAR_LOW                                                    0x0490
#define regUVD_LMI_MIF_IMAGEPASTE_LUMA_64BIT_BAR_LOW_BASE_IDX                                           1
#define regUVD_LMI_MIF_IMAGEPASTE_LUMA_64BIT_BAR_HIGH                                                   0x0491
#define regUVD_LMI_MIF_IMAGEPASTE_LUMA_64BIT_BAR_HIGH_BASE_IDX                                          1
#define regUVD_LMI_MIF_IMAGEPASTE_CHROMA_64BIT_BAR_LOW                                                  0x0492
#define regUVD_LMI_MIF_IMAGEPASTE_CHROMA_64BIT_BAR_LOW_BASE_IDX                                         1
#define regUVD_LMI_MIF_IMAGEPASTE_CHROMA_64BIT_BAR_HIGH                                                 0x0493
#define regUVD_LMI_MIF_IMAGEPASTE_CHROMA_64BIT_BAR_HIGH_BASE_IDX                                        1
#define regUVD_LMI_MIF_PRIVACY_LUMA_64BIT_BAR_LOW                                                       0x0494
#define regUVD_LMI_MIF_PRIVACY_LUMA_64BIT_BAR_LOW_BASE_IDX                                              1
#define regUVD_LMI_MIF_PRIVACY_LUMA_64BIT_BAR_HIGH                                                      0x0495
#define regUVD_LMI_MIF_PRIVACY_LUMA_64BIT_BAR_HIGH_BASE_IDX                                             1
#define regUVD_LMI_MIF_PRIVACY_CHROMA_64BIT_BAR_LOW                                                     0x0496
#define regUVD_LMI_MIF_PRIVACY_CHROMA_64BIT_BAR_LOW_BASE_IDX                                            1
#define regUVD_LMI_MIF_PRIVACY_CHROMA_64BIT_BAR_HIGH                                                    0x0497
#define regUVD_LMI_MIF_PRIVACY_CHROMA_64BIT_BAR_HIGH_BASE_IDX                                           1
#define regUVD_ADP_ATOMIC_CONFIG                                                                        0x0499
#define regUVD_ADP_ATOMIC_CONFIG_BASE_IDX                                                               1
#define regUVD_LMI_ARB_CTRL2                                                                            0x049a
#define regUVD_LMI_ARB_CTRL2_BASE_IDX                                                                   1
#define regUVD_LMI_VCPU_CACHE_VMIDS_MULTI                                                               0x049f
#define regUVD_LMI_VCPU_CACHE_VMIDS_MULTI_BASE_IDX                                                      1
#define regUVD_LMI_VCPU_NC_VMIDS_MULTI                                                                  0x04a0
#define regUVD_LMI_VCPU_NC_VMIDS_MULTI_BASE_IDX                                                         1
#define regUVD_LMI_LAT_CTRL                                                                             0x04a1
#define regUVD_LMI_LAT_CTRL_BASE_IDX                                                                    1
#define regUVD_LMI_LAT_CNTR                                                                             0x04a2
#define regUVD_LMI_LAT_CNTR_BASE_IDX                                                                    1
#define regUVD_LMI_AVG_LAT_CNTR                                                                         0x04a3
#define regUVD_LMI_AVG_LAT_CNTR_BASE_IDX                                                                1
#define regUVD_LMI_SPH                                                                                  0x04a4
#define regUVD_LMI_SPH_BASE_IDX                                                                         1
#define regUVD_LMI_VCPU_CACHE_VMID                                                                      0x04a5
#define regUVD_LMI_VCPU_CACHE_VMID_BASE_IDX                                                             1
#define regUVD_LMI_CTRL2                                                                                0x04a6
#define regUVD_LMI_CTRL2_BASE_IDX                                                                       1
#define regUVD_LMI_URGENT_CTRL                                                                          0x04a7
#define regUVD_LMI_URGENT_CTRL_BASE_IDX                                                                 1
#define regUVD_LMI_CTRL                                                                                 0x04a8
#define regUVD_LMI_CTRL_BASE_IDX                                                                        1
#define regUVD_LMI_STATUS                                                                               0x04a9
#define regUVD_LMI_STATUS_BASE_IDX                                                                      1
#define regUVD_LMI_PERFMON_CTRL                                                                         0x04ac
#define regUVD_LMI_PERFMON_CTRL_BASE_IDX                                                                1
#define regUVD_LMI_PERFMON_COUNT_LO                                                                     0x04ad
#define regUVD_LMI_PERFMON_COUNT_LO_BASE_IDX                                                            1
#define regUVD_LMI_PERFMON_COUNT_HI                                                                     0x04ae
#define regUVD_LMI_PERFMON_COUNT_HI_BASE_IDX                                                            1
#define regUVD_LMI_ADP_SWAP_CNTL                                                                        0x04af
#define regUVD_LMI_ADP_SWAP_CNTL_BASE_IDX                                                               1
#define regUVD_LMI_RBC_RB_VMID                                                                          0x04b0
#define regUVD_LMI_RBC_RB_VMID_BASE_IDX                                                                 1
#define regUVD_LMI_RBC_IB_VMID                                                                          0x04b1
#define regUVD_LMI_RBC_IB_VMID_BASE_IDX                                                                 1
#define regUVD_LMI_MC_CREDITS                                                                           0x04b2
#define regUVD_LMI_MC_CREDITS_BASE_IDX                                                                  1
#define regUVD_LMI_ADP_IND_INDEX                                                                        0x04b6
#define regUVD_LMI_ADP_IND_INDEX_BASE_IDX                                                               1
#define regUVD_LMI_ADP_IND_DATA                                                                         0x04b7
#define regUVD_LMI_ADP_IND_DATA_BASE_IDX                                                                1
#define regVCN_RAS_CNTL                                                                                 0x04b9
#define regVCN_RAS_CNTL_BASE_IDX                                                                        1


// addressBlock: uvd0_mmsch_dec
// base address: 0x1e000
#define regMMSCH_UCODE_ADDR                                                                             0x0000
#define regMMSCH_UCODE_ADDR_BASE_IDX                                                                    0
#define regMMSCH_UCODE_DATA                                                                             0x0001
#define regMMSCH_UCODE_DATA_BASE_IDX                                                                    0
#define regMMSCH_SRAM_ADDR                                                                              0x0002
#define regMMSCH_SRAM_ADDR_BASE_IDX                                                                     0
#define regMMSCH_SRAM_DATA                                                                              0x0003
#define regMMSCH_SRAM_DATA_BASE_IDX                                                                     0
#define regMMSCH_VF_SRAM_OFFSET                                                                         0x0004
#define regMMSCH_VF_SRAM_OFFSET_BASE_IDX                                                                0
#define regMMSCH_DB_SRAM_OFFSET                                                                         0x0005
#define regMMSCH_DB_SRAM_OFFSET_BASE_IDX                                                                0
#define regMMSCH_CTX_SRAM_OFFSET                                                                        0x0006
#define regMMSCH_CTX_SRAM_OFFSET_BASE_IDX                                                               0
#define regMMSCH_INTR                                                                                   0x0008
#define regMMSCH_INTR_BASE_IDX                                                                          0
#define regMMSCH_INTR_ACK                                                                               0x0009
#define regMMSCH_INTR_ACK_BASE_IDX                                                                      0
#define regMMSCH_INTR_STATUS                                                                            0x000a
#define regMMSCH_INTR_STATUS_BASE_IDX                                                                   0
#define regMMSCH_VF_VMID                                                                                0x000b
#define regMMSCH_VF_VMID_BASE_IDX                                                                       0
#define regMMSCH_VF_CTX_ADDR_LO                                                                         0x000c
#define regMMSCH_VF_CTX_ADDR_LO_BASE_IDX                                                                0
#define regMMSCH_VF_CTX_ADDR_HI                                                                         0x000d
#define regMMSCH_VF_CTX_ADDR_HI_BASE_IDX                                                                0
#define regMMSCH_VF_CTX_SIZE                                                                            0x000e
#define regMMSCH_VF_CTX_SIZE_BASE_IDX                                                                   0
#define regMMSCH_VF_GPCOM_ADDR_LO                                                                       0x000f
#define regMMSCH_VF_GPCOM_ADDR_LO_BASE_IDX                                                              0
#define regMMSCH_VF_GPCOM_ADDR_HI                                                                       0x0010
#define regMMSCH_VF_GPCOM_ADDR_HI_BASE_IDX                                                              0
#define regMMSCH_VF_GPCOM_SIZE                                                                          0x0011
#define regMMSCH_VF_GPCOM_SIZE_BASE_IDX                                                                 0
#define regMMSCH_VF_MAILBOX_HOST                                                                        0x0012
#define regMMSCH_VF_MAILBOX_HOST_BASE_IDX                                                               0
#define regMMSCH_VF_MAILBOX_RESP                                                                        0x0013
#define regMMSCH_VF_MAILBOX_RESP_BASE_IDX                                                               0
#define regMMSCH_VF_MAILBOX_0                                                                           0x0014
#define regMMSCH_VF_MAILBOX_0_BASE_IDX                                                                  0
#define regMMSCH_VF_MAILBOX_0_RESP                                                                      0x0015
#define regMMSCH_VF_MAILBOX_0_RESP_BASE_IDX                                                             0
#define regMMSCH_VF_MAILBOX_1                                                                           0x0016
#define regMMSCH_VF_MAILBOX_1_BASE_IDX                                                                  0
#define regMMSCH_VF_MAILBOX_1_RESP                                                                      0x0017
#define regMMSCH_VF_MAILBOX_1_RESP_BASE_IDX                                                             0
#define regMMSCH_CNTL                                                                                   0x001c
#define regMMSCH_CNTL_BASE_IDX                                                                          0
#define regMMSCH_NONCACHE_OFFSET0                                                                       0x001d
#define regMMSCH_NONCACHE_OFFSET0_BASE_IDX                                                              0
#define regMMSCH_NONCACHE_SIZE0                                                                         0x001e
#define regMMSCH_NONCACHE_SIZE0_BASE_IDX                                                                0
#define regMMSCH_NONCACHE_OFFSET1                                                                       0x001f
#define regMMSCH_NONCACHE_OFFSET1_BASE_IDX                                                              0
#define regMMSCH_NONCACHE_SIZE1                                                                         0x0020
#define regMMSCH_NONCACHE_SIZE1_BASE_IDX                                                                0
#define regMMSCH_PROC_STATE1                                                                            0x0026
#define regMMSCH_PROC_STATE1_BASE_IDX                                                                   0
#define regMMSCH_LAST_MC_ADDR                                                                           0x0027
#define regMMSCH_LAST_MC_ADDR_BASE_IDX                                                                  0
#define regMMSCH_LAST_MEM_ACCESS_HI                                                                     0x0028
#define regMMSCH_LAST_MEM_ACCESS_HI_BASE_IDX                                                            0
#define regMMSCH_LAST_MEM_ACCESS_LO                                                                     0x0029
#define regMMSCH_LAST_MEM_ACCESS_LO_BASE_IDX                                                            0
#define regMMSCH_SCRATCH_0                                                                              0x002b
#define regMMSCH_SCRATCH_0_BASE_IDX                                                                     0
#define regMMSCH_SCRATCH_1                                                                              0x002c
#define regMMSCH_SCRATCH_1_BASE_IDX                                                                     0
#define regMMSCH_GPUIOV_SCH_BLOCK_0                                                                     0x002d
#define regMMSCH_GPUIOV_SCH_BLOCK_0_BASE_IDX                                                            0
#define regMMSCH_GPUIOV_CMD_CONTROL_0                                                                   0x002e
#define regMMSCH_GPUIOV_CMD_CONTROL_0_BASE_IDX                                                          0
#define regMMSCH_GPUIOV_CMD_STATUS_0                                                                    0x002f
#define regMMSCH_GPUIOV_CMD_STATUS_0_BASE_IDX                                                           0
#define regMMSCH_GPUIOV_VM_BUSY_STATUS_0                                                                0x0030
#define regMMSCH_GPUIOV_VM_BUSY_STATUS_0_BASE_IDX                                                       0
#define regMMSCH_GPUIOV_ACTIVE_FCNS_0                                                                   0x0031
#define regMMSCH_GPUIOV_ACTIVE_FCNS_0_BASE_IDX                                                          0
#define regMMSCH_GPUIOV_ACTIVE_FCN_ID_0                                                                 0x0032
#define regMMSCH_GPUIOV_ACTIVE_FCN_ID_0_BASE_IDX                                                        0
#define regMMSCH_GPUIOV_DW6_0                                                                           0x0033
#define regMMSCH_GPUIOV_DW6_0_BASE_IDX                                                                  0
#define regMMSCH_GPUIOV_DW7_0                                                                           0x0034
#define regMMSCH_GPUIOV_DW7_0_BASE_IDX                                                                  0
#define regMMSCH_GPUIOV_DW8_0                                                                           0x0035
#define regMMSCH_GPUIOV_DW8_0_BASE_IDX                                                                  0
#define regMMSCH_GPUIOV_SCH_BLOCK_1                                                                     0x0036
#define regMMSCH_GPUIOV_SCH_BLOCK_1_BASE_IDX                                                            0
#define regMMSCH_GPUIOV_CMD_CONTROL_1                                                                   0x0037
#define regMMSCH_GPUIOV_CMD_CONTROL_1_BASE_IDX                                                          0
#define regMMSCH_GPUIOV_CMD_STATUS_1                                                                    0x0038
#define regMMSCH_GPUIOV_CMD_STATUS_1_BASE_IDX                                                           0
#define regMMSCH_GPUIOV_VM_BUSY_STATUS_1                                                                0x0039
#define regMMSCH_GPUIOV_VM_BUSY_STATUS_1_BASE_IDX                                                       0
#define regMMSCH_GPUIOV_ACTIVE_FCNS_1                                                                   0x003a
#define regMMSCH_GPUIOV_ACTIVE_FCNS_1_BASE_IDX                                                          0
#define regMMSCH_GPUIOV_ACTIVE_FCN_ID_1                                                                 0x003b
#define regMMSCH_GPUIOV_ACTIVE_FCN_ID_1_BASE_IDX                                                        0
#define regMMSCH_GPUIOV_DW6_1                                                                           0x003c
#define regMMSCH_GPUIOV_DW6_1_BASE_IDX                                                                  0
#define regMMSCH_GPUIOV_DW7_1                                                                           0x003d
#define regMMSCH_GPUIOV_DW7_1_BASE_IDX                                                                  0
#define regMMSCH_GPUIOV_DW8_1                                                                           0x003e
#define regMMSCH_GPUIOV_DW8_1_BASE_IDX                                                                  0
#define regMMSCH_GPUIOV_CNTXT                                                                           0x003f
#define regMMSCH_GPUIOV_CNTXT_BASE_IDX                                                                  0
#define regMMSCH_SCRATCH_2                                                                              0x0040
#define regMMSCH_SCRATCH_2_BASE_IDX                                                                     0
#define regMMSCH_SCRATCH_3                                                                              0x0041
#define regMMSCH_SCRATCH_3_BASE_IDX                                                                     0
#define regMMSCH_SCRATCH_4                                                                              0x0042
#define regMMSCH_SCRATCH_4_BASE_IDX                                                                     0
#define regMMSCH_SCRATCH_5                                                                              0x0043
#define regMMSCH_SCRATCH_5_BASE_IDX                                                                     0
#define regMMSCH_SCRATCH_6                                                                              0x0044
#define regMMSCH_SCRATCH_6_BASE_IDX                                                                     0
#define regMMSCH_SCRATCH_7                                                                              0x0045
#define regMMSCH_SCRATCH_7_BASE_IDX                                                                     0
#define regMMSCH_VFID_FIFO_HEAD_0                                                                       0x0046
#define regMMSCH_VFID_FIFO_HEAD_0_BASE_IDX                                                              0
#define regMMSCH_VFID_FIFO_TAIL_0                                                                       0x0047
#define regMMSCH_VFID_FIFO_TAIL_0_BASE_IDX                                                              0
#define regMMSCH_VFID_FIFO_HEAD_1                                                                       0x0048
#define regMMSCH_VFID_FIFO_HEAD_1_BASE_IDX                                                              0
#define regMMSCH_VFID_FIFO_TAIL_1                                                                       0x0049
#define regMMSCH_VFID_FIFO_TAIL_1_BASE_IDX                                                              0
#define regMMSCH_NACK_STATUS                                                                            0x004a
#define regMMSCH_NACK_STATUS_BASE_IDX                                                                   0
#define regMMSCH_VF_MAILBOX0_DATA                                                                       0x004b
#define regMMSCH_VF_MAILBOX0_DATA_BASE_IDX                                                              0
#define regMMSCH_VF_MAILBOX1_DATA                                                                       0x004c
#define regMMSCH_VF_MAILBOX1_DATA_BASE_IDX                                                              0
#define regMMSCH_GPUIOV_SCH_BLOCK_IP_0                                                                  0x004d
#define regMMSCH_GPUIOV_SCH_BLOCK_IP_0_BASE_IDX                                                         0
#define regMMSCH_GPUIOV_CMD_STATUS_IP_0                                                                 0x004e
#define regMMSCH_GPUIOV_CMD_STATUS_IP_0_BASE_IDX                                                        0
#define regMMSCH_GPUIOV_ACTIVE_FCN_ID_IP_0                                                              0x004f
#define regMMSCH_GPUIOV_ACTIVE_FCN_ID_IP_0_BASE_IDX                                                     0
#define regMMSCH_GPUIOV_SCH_BLOCK_IP_1                                                                  0x0050
#define regMMSCH_GPUIOV_SCH_BLOCK_IP_1_BASE_IDX                                                         0
#define regMMSCH_GPUIOV_CMD_STATUS_IP_1                                                                 0x0051
#define regMMSCH_GPUIOV_CMD_STATUS_IP_1_BASE_IDX                                                        0
#define regMMSCH_GPUIOV_ACTIVE_FCN_ID_IP_1                                                              0x0052
#define regMMSCH_GPUIOV_ACTIVE_FCN_ID_IP_1_BASE_IDX                                                     0
#define regMMSCH_GPUIOV_CNTXT_IP                                                                        0x0053
#define regMMSCH_GPUIOV_CNTXT_IP_BASE_IDX                                                               0
#define regMMSCH_GPUIOV_SCH_BLOCK_2                                                                     0x0054
#define regMMSCH_GPUIOV_SCH_BLOCK_2_BASE_IDX                                                            0
#define regMMSCH_GPUIOV_CMD_CONTROL_2                                                                   0x0055
#define regMMSCH_GPUIOV_CMD_CONTROL_2_BASE_IDX                                                          0
#define regMMSCH_GPUIOV_CMD_STATUS_2                                                                    0x0056
#define regMMSCH_GPUIOV_CMD_STATUS_2_BASE_IDX                                                           0
#define regMMSCH_GPUIOV_VM_BUSY_STATUS_2                                                                0x0057
#define regMMSCH_GPUIOV_VM_BUSY_STATUS_2_BASE_IDX                                                       0
#define regMMSCH_GPUIOV_ACTIVE_FCNS_2                                                                   0x0058
#define regMMSCH_GPUIOV_ACTIVE_FCNS_2_BASE_IDX                                                          0
#define regMMSCH_GPUIOV_ACTIVE_FCN_ID_2                                                                 0x0059
#define regMMSCH_GPUIOV_ACTIVE_FCN_ID_2_BASE_IDX                                                        0
#define regMMSCH_GPUIOV_DW6_2                                                                           0x005a
#define regMMSCH_GPUIOV_DW6_2_BASE_IDX                                                                  0
#define regMMSCH_GPUIOV_DW7_2                                                                           0x005b
#define regMMSCH_GPUIOV_DW7_2_BASE_IDX                                                                  0
#define regMMSCH_GPUIOV_DW8_2                                                                           0x005c
#define regMMSCH_GPUIOV_DW8_2_BASE_IDX                                                                  0
#define regMMSCH_GPUIOV_SCH_BLOCK_IP_2                                                                  0x005d
#define regMMSCH_GPUIOV_SCH_BLOCK_IP_2_BASE_IDX                                                         0
#define regMMSCH_GPUIOV_CMD_STATUS_IP_2                                                                 0x005e
#define regMMSCH_GPUIOV_CMD_STATUS_IP_2_BASE_IDX                                                        0
#define regMMSCH_GPUIOV_ACTIVE_FCN_ID_IP_2                                                              0x005f
#define regMMSCH_GPUIOV_ACTIVE_FCN_ID_IP_2_BASE_IDX                                                     0
#define regMMSCH_VFID_FIFO_HEAD_2                                                                       0x0060
#define regMMSCH_VFID_FIFO_HEAD_2_BASE_IDX                                                              0
#define regMMSCH_VFID_FIFO_TAIL_2                                                                       0x0061
#define regMMSCH_VFID_FIFO_TAIL_2_BASE_IDX                                                              0
#define regMMSCH_VM_BUSY_STATUS_0                                                                       0x0062
#define regMMSCH_VM_BUSY_STATUS_0_BASE_IDX                                                              0
#define regMMSCH_VM_BUSY_STATUS_1                                                                       0x0063
#define regMMSCH_VM_BUSY_STATUS_1_BASE_IDX                                                              0
#define regMMSCH_VM_BUSY_STATUS_2                                                                       0x0064
#define regMMSCH_VM_BUSY_STATUS_2_BASE_IDX                                                              0


// addressBlock: uvd0_uvd_jmi_dec
// base address: 0x1e500
#define regUVD_JADP_MCIF_URGENT_CTRL                                                                    0x0141
#define regUVD_JADP_MCIF_URGENT_CTRL_BASE_IDX                                                           0
#define regUVD_JMI_URGENT_CTRL                                                                          0x0142
#define regUVD_JMI_URGENT_CTRL_BASE_IDX                                                                 0
#define regUVD_JPEG_DEC_PF_CTRL                                                                         0x0143
#define regUVD_JPEG_DEC_PF_CTRL_BASE_IDX                                                                0
#define regUVD_JPEG_ENC_PF_CTRL                                                                         0x0144
#define regUVD_JPEG_ENC_PF_CTRL_BASE_IDX                                                                0
#define regUVD_JMI_CTRL                                                                                 0x0145
#define regUVD_JMI_CTRL_BASE_IDX                                                                        0
#define regUVD_LMI_JRBC_CTRL                                                                            0x0146
#define regUVD_LMI_JRBC_CTRL_BASE_IDX                                                                   0
#define regUVD_LMI_JPEG_CTRL                                                                            0x0147
#define regUVD_LMI_JPEG_CTRL_BASE_IDX                                                                   0
#define regUVD_JMI_EJRBC_CTRL                                                                           0x0148
#define regUVD_JMI_EJRBC_CTRL_BASE_IDX                                                                  0
#define regUVD_LMI_EJPEG_CTRL                                                                           0x0149
#define regUVD_LMI_EJPEG_CTRL_BASE_IDX                                                                  0
#define regUVD_JMI_SCALER_CTRL                                                                          0x014a
#define regUVD_JMI_SCALER_CTRL_BASE_IDX                                                                 0
#define regJPEG_LMI_DROP                                                                                0x014b
#define regJPEG_LMI_DROP_BASE_IDX                                                                       0
#define regUVD_JMI_EJPEG_DROP                                                                           0x014c
#define regUVD_JMI_EJPEG_DROP_BASE_IDX                                                                  0
#define regJPEG_MEMCHECK_CLAMPING                                                                       0x014d
#define regJPEG_MEMCHECK_CLAMPING_BASE_IDX                                                              0
#define regUVD_JMI_EJPEG_MEMCHECK_CLAMPING                                                              0x014e
#define regUVD_JMI_EJPEG_MEMCHECK_CLAMPING_BASE_IDX                                                     0
#define regUVD_LMI_JRBC_IB_VMID                                                                         0x014f
#define regUVD_LMI_JRBC_IB_VMID_BASE_IDX                                                                0
#define regUVD_LMI_JRBC_RB_VMID                                                                         0x0150
#define regUVD_LMI_JRBC_RB_VMID_BASE_IDX                                                                0
#define regUVD_LMI_JPEG_VMID                                                                            0x0151
#define regUVD_LMI_JPEG_VMID_BASE_IDX                                                                   0
#define regUVD_JMI_ENC_JRBC_IB_VMID                                                                     0x0152
#define regUVD_JMI_ENC_JRBC_IB_VMID_BASE_IDX                                                            0
#define regUVD_JMI_ENC_JRBC_RB_VMID                                                                     0x0153
#define regUVD_JMI_ENC_JRBC_RB_VMID_BASE_IDX                                                            0
#define regUVD_JMI_ENC_JPEG_VMID                                                                        0x0154
#define regUVD_JMI_ENC_JPEG_VMID_BASE_IDX                                                               0
#define regUVD_JMI_EJPEG_RAS_CNTL                                                                       0x0156
#define regUVD_JMI_EJPEG_RAS_CNTL_BASE_IDX                                                              0
#define regJPEG_MEMCHECK_SAFE_ADDR                                                                      0x0157
#define regJPEG_MEMCHECK_SAFE_ADDR_BASE_IDX                                                             0
#define regJPEG_MEMCHECK_SAFE_ADDR_64BIT                                                                0x0158
#define regJPEG_MEMCHECK_SAFE_ADDR_64BIT_BASE_IDX                                                       0
#define regUVD_JMI_LAT_CTRL                                                                             0x0159
#define regUVD_JMI_LAT_CTRL_BASE_IDX                                                                    0
#define regUVD_JMI_LAT_CNTR                                                                             0x015a
#define regUVD_JMI_LAT_CNTR_BASE_IDX                                                                    0
#define regUVD_JMI_AVG_LAT_CNTR                                                                         0x015b
#define regUVD_JMI_AVG_LAT_CNTR_BASE_IDX                                                                0
#define regUVD_JMI_PERFMON_CTRL                                                                         0x015c
#define regUVD_JMI_PERFMON_CTRL_BASE_IDX                                                                0
#define regUVD_JMI_PERFMON_COUNT_LO                                                                     0x015d
#define regUVD_JMI_PERFMON_COUNT_LO_BASE_IDX                                                            0
#define regUVD_JMI_PERFMON_COUNT_HI                                                                     0x015e
#define regUVD_JMI_PERFMON_COUNT_HI_BASE_IDX                                                            0
#define regUVD_JMI_CLEAN_STATUS                                                                         0x015f
#define regUVD_JMI_CLEAN_STATUS_BASE_IDX                                                                0
#define regUVD_LMI_JPEG_READ_64BIT_BAR_LOW                                                              0x0160
#define regUVD_LMI_JPEG_READ_64BIT_BAR_LOW_BASE_IDX                                                     0
#define regUVD_LMI_JPEG_READ_64BIT_BAR_HIGH                                                             0x0161
#define regUVD_LMI_JPEG_READ_64BIT_BAR_HIGH_BASE_IDX                                                    0
#define regUVD_LMI_JPEG_WRITE_64BIT_BAR_LOW                                                             0x0162
#define regUVD_LMI_JPEG_WRITE_64BIT_BAR_LOW_BASE_IDX                                                    0
#define regUVD_LMI_JPEG_WRITE_64BIT_BAR_HIGH                                                            0x0163
#define regUVD_LMI_JPEG_WRITE_64BIT_BAR_HIGH_BASE_IDX                                                   0
#define regUVD_LMI_JPEG_PREEMPT_FENCE_64BIT_BAR_LOW                                                     0x0164
#define regUVD_LMI_JPEG_PREEMPT_FENCE_64BIT_BAR_LOW_BASE_IDX                                            0
#define regUVD_LMI_JPEG_PREEMPT_FENCE_64BIT_BAR_HIGH                                                    0x0165
#define regUVD_LMI_JPEG_PREEMPT_FENCE_64BIT_BAR_HIGH_BASE_IDX                                           0
#define regUVD_LMI_JRBC_RB_64BIT_BAR_LOW                                                                0x0166
#define regUVD_LMI_JRBC_RB_64BIT_BAR_LOW_BASE_IDX                                                       0
#define regUVD_LMI_JRBC_RB_64BIT_BAR_HIGH                                                               0x0167
#define regUVD_LMI_JRBC_RB_64BIT_BAR_HIGH_BASE_IDX                                                      0
#define regUVD_LMI_JRBC_IB_64BIT_BAR_LOW                                                                0x0168
#define regUVD_LMI_JRBC_IB_64BIT_BAR_LOW_BASE_IDX                                                       0
#define regUVD_LMI_JRBC_IB_64BIT_BAR_HIGH                                                               0x0169
#define regUVD_LMI_JRBC_IB_64BIT_BAR_HIGH_BASE_IDX                                                      0
#define regUVD_LMI_JRBC_RB_MEM_WR_64BIT_BAR_LOW                                                         0x016a
#define regUVD_LMI_JRBC_RB_MEM_WR_64BIT_BAR_LOW_BASE_IDX                                                0
#define regUVD_LMI_JRBC_RB_MEM_WR_64BIT_BAR_HIGH                                                        0x016b
#define regUVD_LMI_JRBC_RB_MEM_WR_64BIT_BAR_HIGH_BASE_IDX                                               0
#define regUVD_LMI_JRBC_RB_MEM_RD_64BIT_BAR_LOW                                                         0x016c
#define regUVD_LMI_JRBC_RB_MEM_RD_64BIT_BAR_LOW_BASE_IDX                                                0
#define regUVD_LMI_JRBC_RB_MEM_RD_64BIT_BAR_HIGH                                                        0x016d
#define regUVD_LMI_JRBC_RB_MEM_RD_64BIT_BAR_HIGH_BASE_IDX                                               0
#define regUVD_LMI_JRBC_IB_MEM_WR_64BIT_BAR_LOW                                                         0x016e
#define regUVD_LMI_JRBC_IB_MEM_WR_64BIT_BAR_LOW_BASE_IDX                                                0
#define regUVD_LMI_JRBC_IB_MEM_WR_64BIT_BAR_HIGH                                                        0x016f
#define regUVD_LMI_JRBC_IB_MEM_WR_64BIT_BAR_HIGH_BASE_IDX                                               0
#define regUVD_LMI_JRBC_IB_MEM_RD_64BIT_BAR_LOW                                                         0x0170
#define regUVD_LMI_JRBC_IB_MEM_RD_64BIT_BAR_LOW_BASE_IDX                                                0
#define regUVD_LMI_JRBC_IB_MEM_RD_64BIT_BAR_HIGH                                                        0x0171
#define regUVD_LMI_JRBC_IB_MEM_RD_64BIT_BAR_HIGH_BASE_IDX                                               0
#define regUVD_JMI_PEL_RD_64BIT_BAR_LOW                                                                 0x0172
#define regUVD_JMI_PEL_RD_64BIT_BAR_LOW_BASE_IDX                                                        0
#define regUVD_JMI_PEL_RD_64BIT_BAR_HIGH                                                                0x0173
#define regUVD_JMI_PEL_RD_64BIT_BAR_HIGH_BASE_IDX                                                       0
#define regUVD_JMI_BS_WR_64BIT_BAR_LOW                                                                  0x0174
#define regUVD_JMI_BS_WR_64BIT_BAR_LOW_BASE_IDX                                                         0
#define regUVD_JMI_BS_WR_64BIT_BAR_HIGH                                                                 0x0175
#define regUVD_JMI_BS_WR_64BIT_BAR_HIGH_BASE_IDX                                                        0
#define regUVD_JMI_SCALAR_RD_64BIT_BAR_LOW                                                              0x0176
#define regUVD_JMI_SCALAR_RD_64BIT_BAR_LOW_BASE_IDX                                                     0
#define regUVD_JMI_SCALAR_RD_64BIT_BAR_HIGH                                                             0x0177
#define regUVD_JMI_SCALAR_RD_64BIT_BAR_HIGH_BASE_IDX                                                    0
#define regUVD_JMI_SCALAR_WR_64BIT_BAR_LOW                                                              0x0178
#define regUVD_JMI_SCALAR_WR_64BIT_BAR_LOW_BASE_IDX                                                     0
#define regUVD_JMI_SCALAR_WR_64BIT_BAR_HIGH                                                             0x0179
#define regUVD_JMI_SCALAR_WR_64BIT_BAR_HIGH_BASE_IDX                                                    0
#define regUVD_LMI_EJPEG_PREEMPT_FENCE_64BIT_BAR_LOW                                                    0x017a
#define regUVD_LMI_EJPEG_PREEMPT_FENCE_64BIT_BAR_LOW_BASE_IDX                                           0
#define regUVD_LMI_EJPEG_PREEMPT_FENCE_64BIT_BAR_HIGH                                                   0x017b
#define regUVD_LMI_EJPEG_PREEMPT_FENCE_64BIT_BAR_HIGH_BASE_IDX                                          0
#define regUVD_LMI_EJRBC_RB_64BIT_BAR_LOW                                                               0x017c
#define regUVD_LMI_EJRBC_RB_64BIT_BAR_LOW_BASE_IDX                                                      0
#define regUVD_LMI_EJRBC_RB_64BIT_BAR_HIGH                                                              0x017d
#define regUVD_LMI_EJRBC_RB_64BIT_BAR_HIGH_BASE_IDX                                                     0
#define regUVD_LMI_EJRBC_IB_64BIT_BAR_LOW                                                               0x017e
#define regUVD_LMI_EJRBC_IB_64BIT_BAR_LOW_BASE_IDX                                                      0
#define regUVD_LMI_EJRBC_IB_64BIT_BAR_HIGH                                                              0x017f
#define regUVD_LMI_EJRBC_IB_64BIT_BAR_HIGH_BASE_IDX                                                     0
#define regUVD_LMI_EJRBC_RB_MEM_WR_64BIT_BAR_LOW                                                        0x0180
#define regUVD_LMI_EJRBC_RB_MEM_WR_64BIT_BAR_LOW_BASE_IDX                                               0
#define regUVD_LMI_EJRBC_RB_MEM_WR_64BIT_BAR_HIGH                                                       0x0181
#define regUVD_LMI_EJRBC_RB_MEM_WR_64BIT_BAR_HIGH_BASE_IDX                                              0
#define regUVD_LMI_EJRBC_RB_MEM_RD_64BIT_BAR_LOW                                                        0x0182
#define regUVD_LMI_EJRBC_RB_MEM_RD_64BIT_BAR_LOW_BASE_IDX                                               0
#define regUVD_LMI_EJRBC_RB_MEM_RD_64BIT_BAR_HIGH                                                       0x0183
#define regUVD_LMI_EJRBC_RB_MEM_RD_64BIT_BAR_HIGH_BASE_IDX                                              0
#define regUVD_LMI_EJRBC_IB_MEM_WR_64BIT_BAR_LOW                                                        0x0184
#define regUVD_LMI_EJRBC_IB_MEM_WR_64BIT_BAR_LOW_BASE_IDX                                               0
#define regUVD_LMI_EJRBC_IB_MEM_WR_64BIT_BAR_HIGH                                                       0x0185
#define regUVD_LMI_EJRBC_IB_MEM_WR_64BIT_BAR_HIGH_BASE_IDX                                              0
#define regUVD_LMI_EJRBC_IB_MEM_RD_64BIT_BAR_LOW                                                        0x0186
#define regUVD_LMI_EJRBC_IB_MEM_RD_64BIT_BAR_LOW_BASE_IDX                                               0
#define regUVD_LMI_EJRBC_IB_MEM_RD_64BIT_BAR_HIGH                                                       0x0187
#define regUVD_LMI_EJRBC_IB_MEM_RD_64BIT_BAR_HIGH_BASE_IDX                                              0
#define regUVD_LMI_JPEG_PREEMPT_VMID                                                                    0x0188
#define regUVD_LMI_JPEG_PREEMPT_VMID_BASE_IDX                                                           0
#define regUVD_LMI_ENC_JPEG_PREEMPT_VMID                                                                0x0189
#define regUVD_LMI_ENC_JPEG_PREEMPT_VMID_BASE_IDX                                                       0
#define regUVD_LMI_JPEG2_VMID                                                                           0x018a
#define regUVD_LMI_JPEG2_VMID_BASE_IDX                                                                  0
#define regUVD_LMI_JPEG2_READ_64BIT_BAR_LOW                                                             0x018b
#define regUVD_LMI_JPEG2_READ_64BIT_BAR_LOW_BASE_IDX                                                    0
#define regUVD_LMI_JPEG2_READ_64BIT_BAR_HIGH                                                            0x018c
#define regUVD_LMI_JPEG2_READ_64BIT_BAR_HIGH_BASE_IDX                                                   0
#define regUVD_LMI_JPEG2_WRITE_64BIT_BAR_LOW                                                            0x018d
#define regUVD_LMI_JPEG2_WRITE_64BIT_BAR_LOW_BASE_IDX                                                   0
#define regUVD_LMI_JPEG2_WRITE_64BIT_BAR_HIGH                                                           0x018e
#define regUVD_LMI_JPEG2_WRITE_64BIT_BAR_HIGH_BASE_IDX                                                  0
#define regUVD_LMI_JPEG_CTRL2                                                                           0x018f
#define regUVD_LMI_JPEG_CTRL2_BASE_IDX                                                                  0
#define regUVD_JMI_DEC_SWAP_CNTL                                                                        0x0190
#define regUVD_JMI_DEC_SWAP_CNTL_BASE_IDX                                                               0
#define regUVD_JMI_ENC_SWAP_CNTL                                                                        0x0191
#define regUVD_JMI_ENC_SWAP_CNTL_BASE_IDX                                                               0
#define regUVD_JMI_CNTL                                                                                 0x0192
#define regUVD_JMI_CNTL_BASE_IDX                                                                        0
#define regUVD_JMI_ATOMIC_CNTL                                                                          0x0193
#define regUVD_JMI_ATOMIC_CNTL_BASE_IDX                                                                 0
#define regUVD_JMI_ATOMIC_CNTL2                                                                         0x0194
#define regUVD_JMI_ATOMIC_CNTL2_BASE_IDX                                                                0
#define regUVD_JMI_ATOMIC_USER0_WRITE_64BIT_BAR_LOW                                                     0x0195
#define regUVD_JMI_ATOMIC_USER0_WRITE_64BIT_BAR_LOW_BASE_IDX                                            0
#define regUVD_JMI_ATOMIC_USER0_WRITE_64BIT_BAR_HIGH                                                    0x0196
#define regUVD_JMI_ATOMIC_USER0_WRITE_64BIT_BAR_HIGH_BASE_IDX                                           0
#define regUVD_JMI_ATOMIC_USER1_WRITE_64BIT_BAR_LOW                                                     0x0197
#define regUVD_JMI_ATOMIC_USER1_WRITE_64BIT_BAR_LOW_BASE_IDX                                            0
#define regUVD_JMI_ATOMIC_USER1_WRITE_64BIT_BAR_HIGH                                                    0x0198
#define regUVD_JMI_ATOMIC_USER1_WRITE_64BIT_BAR_HIGH_BASE_IDX                                           0
#define regJPEG2_LMI_DROP                                                                               0x0199
#define regJPEG2_LMI_DROP_BASE_IDX                                                                      0
#define regUVD_JMI_HUFF_FENCE_64BIT_BAR_LOW                                                             0x019a
#define regUVD_JMI_HUFF_FENCE_64BIT_BAR_LOW_BASE_IDX                                                    0
#define regUVD_JMI_HUFF_FENCE_64BIT_BAR_HIGH                                                            0x019b
#define regUVD_JMI_HUFF_FENCE_64BIT_BAR_HIGH_BASE_IDX                                                   0
#define regUVD_JMI_DEC_SWAP_CNTL2                                                                       0x019c
#define regUVD_JMI_DEC_SWAP_CNTL2_BASE_IDX                                                              0
#define regUVD_JMI_DJPEG_RAS_CNTL                                                                       0x019f
#define regUVD_JMI_DJPEG_RAS_CNTL_BASE_IDX                                                              0


// addressBlock: uvd0_uvd_jpeg_common_dec
// base address: 0x1e700
#define regJPEG_SOFT_RESET_STATUS                                                                       0x01c0
#define regJPEG_SOFT_RESET_STATUS_BASE_IDX                                                              0
#define regJPEG_SYS_INT_EN                                                                              0x01c1
#define regJPEG_SYS_INT_EN_BASE_IDX                                                                     0
#define regJPEG_SYS_INT_STATUS                                                                          0x01c2
#define regJPEG_SYS_INT_STATUS_BASE_IDX                                                                 0
#define regJPEG_SYS_INT_ACK                                                                             0x01c3
#define regJPEG_SYS_INT_ACK_BASE_IDX                                                                    0
#define regJPEG_MEMCHECK_SYS_INT_EN                                                                     0x01c4
#define regJPEG_MEMCHECK_SYS_INT_EN_BASE_IDX                                                            0
#define regJPEG_MEMCHECK_SYS_INT_STAT                                                                   0x01c5
#define regJPEG_MEMCHECK_SYS_INT_STAT_BASE_IDX                                                          0
#define regJPEG_MEMCHECK_SYS_INT_ACK                                                                    0x01c6
#define regJPEG_MEMCHECK_SYS_INT_ACK_BASE_IDX                                                           0
#define regJPEG_MASTINT_EN                                                                              0x01c8
#define regJPEG_MASTINT_EN_BASE_IDX                                                                     0
#define regJPEG_IH_CTRL                                                                                 0x01c9
#define regJPEG_IH_CTRL_BASE_IDX                                                                        0
#define regJRBBM_ARB_CTRL                                                                               0x01cb
#define regJRBBM_ARB_CTRL_BASE_IDX                                                                      0


// addressBlock: uvd0_uvd_jpeg_common_sclk_dec
// base address: 0x1e780
#define regJPEG_CGC_GATE                                                                                0x01e0
#define regJPEG_CGC_GATE_BASE_IDX                                                                       0
#define regJPEG_CGC_CTRL                                                                                0x01e1
#define regJPEG_CGC_CTRL_BASE_IDX                                                                       0
#define regJPEG_CGC_STATUS                                                                              0x01e2
#define regJPEG_CGC_STATUS_BASE_IDX                                                                     0
#define regJPEG_COMN_CGC_MEM_CTRL                                                                       0x01e3
#define regJPEG_COMN_CGC_MEM_CTRL_BASE_IDX                                                              0
#define regJPEG_DEC_CGC_MEM_CTRL                                                                        0x01e4
#define regJPEG_DEC_CGC_MEM_CTRL_BASE_IDX                                                               0
#define regJPEG2_DEC_CGC_MEM_CTRL                                                                       0x01e5
#define regJPEG2_DEC_CGC_MEM_CTRL_BASE_IDX                                                              0
#define regJPEG_ENC_CGC_MEM_CTRL                                                                        0x01e6
#define regJPEG_ENC_CGC_MEM_CTRL_BASE_IDX                                                               0
#define regJPEG_SOFT_RESET2                                                                             0x01e7
#define regJPEG_SOFT_RESET2_BASE_IDX                                                                    0
#define regJPEG_PERF_BANK_CONF                                                                          0x01e8
#define regJPEG_PERF_BANK_CONF_BASE_IDX                                                                 0
#define regJPEG_PERF_BANK_EVENT_SEL                                                                     0x01e9
#define regJPEG_PERF_BANK_EVENT_SEL_BASE_IDX                                                            0
#define regJPEG_PERF_BANK_COUNT0                                                                        0x01ea
#define regJPEG_PERF_BANK_COUNT0_BASE_IDX                                                               0
#define regJPEG_PERF_BANK_COUNT1                                                                        0x01eb
#define regJPEG_PERF_BANK_COUNT1_BASE_IDX                                                               0
#define regJPEG_PERF_BANK_COUNT2                                                                        0x01ec
#define regJPEG_PERF_BANK_COUNT2_BASE_IDX                                                               0
#define regJPEG_PERF_BANK_COUNT3                                                                        0x01ed
#define regJPEG_PERF_BANK_COUNT3_BASE_IDX                                                               0


// addressBlock: uvd0_uvd_jpeg_enc_dec
// base address: 0x1e300
#define regUVD_JPEG_ENC_INT_EN                                                                          0x00c1
#define regUVD_JPEG_ENC_INT_EN_BASE_IDX                                                                 0
#define regUVD_JPEG_ENC_INT_STATUS                                                                      0x00c2
#define regUVD_JPEG_ENC_INT_STATUS_BASE_IDX                                                             0
#define regUVD_JPEG_ENC_ENGINE_CNTL                                                                     0x00c5
#define regUVD_JPEG_ENC_ENGINE_CNTL_BASE_IDX                                                            0
#define regUVD_JPEG_ENC_SCRATCH1                                                                        0x00ce
#define regUVD_JPEG_ENC_SCRATCH1_BASE_IDX                                                               0


// addressBlock: uvd0_uvd_jpeg_enc_sclk_dec
// base address: 0x1e380
#define regUVD_JPEG_ENC_SPS_INFO                                                                        0x00e0
#define regUVD_JPEG_ENC_SPS_INFO_BASE_IDX                                                               0
#define regUVD_JPEG_ENC_SPS_INFO1                                                                       0x00e1
#define regUVD_JPEG_ENC_SPS_INFO1_BASE_IDX                                                              0
#define regUVD_JPEG_ENC_TBL_SIZE                                                                        0x00e2
#define regUVD_JPEG_ENC_TBL_SIZE_BASE_IDX                                                               0
#define regUVD_JPEG_ENC_TBL_CNTL                                                                        0x00e3
#define regUVD_JPEG_ENC_TBL_CNTL_BASE_IDX                                                               0
#define regUVD_JPEG_ENC_MC_REQ_CNTL                                                                     0x00e4
#define regUVD_JPEG_ENC_MC_REQ_CNTL_BASE_IDX                                                            0
#define regUVD_JPEG_ENC_STATUS                                                                          0x00e5
#define regUVD_JPEG_ENC_STATUS_BASE_IDX                                                                 0
#define regUVD_JPEG_ENC_PITCH                                                                           0x00e6
#define regUVD_JPEG_ENC_PITCH_BASE_IDX                                                                  0
#define regUVD_JPEG_ENC_LUMA_BASE                                                                       0x00e7
#define regUVD_JPEG_ENC_LUMA_BASE_BASE_IDX                                                              0
#define regUVD_JPEG_ENC_CHROMAU_BASE                                                                    0x00e8
#define regUVD_JPEG_ENC_CHROMAU_BASE_BASE_IDX                                                           0
#define regUVD_JPEG_ENC_CHROMAV_BASE                                                                    0x00e9
#define regUVD_JPEG_ENC_CHROMAV_BASE_BASE_IDX                                                           0
#define regJPEG_ENC_Y_GFX10_TILING_SURFACE                                                              0x00ea
#define regJPEG_ENC_Y_GFX10_TILING_SURFACE_BASE_IDX                                                     0
#define regJPEG_ENC_UV_GFX10_TILING_SURFACE                                                             0x00eb
#define regJPEG_ENC_UV_GFX10_TILING_SURFACE_BASE_IDX                                                    0
#define regJPEG_ENC_GFX10_ADDR_CONFIG                                                                   0x00ec
#define regJPEG_ENC_GFX10_ADDR_CONFIG_BASE_IDX                                                          0
#define regJPEG_ENC_ADDR_MODE                                                                           0x00ed
#define regJPEG_ENC_ADDR_MODE_BASE_IDX                                                                  0
#define regUVD_JPEG_ENC_GPCOM_CMD                                                                       0x00ee
#define regUVD_JPEG_ENC_GPCOM_CMD_BASE_IDX                                                              0
#define regUVD_JPEG_ENC_GPCOM_DATA0                                                                     0x00ef
#define regUVD_JPEG_ENC_GPCOM_DATA0_BASE_IDX                                                            0
#define regUVD_JPEG_ENC_GPCOM_DATA1                                                                     0x00f0
#define regUVD_JPEG_ENC_GPCOM_DATA1_BASE_IDX                                                            0
#define regUVD_JPEG_TBL_DAT0                                                                            0x00f1
#define regUVD_JPEG_TBL_DAT0_BASE_IDX                                                                   0
#define regUVD_JPEG_TBL_DAT1                                                                            0x00f2
#define regUVD_JPEG_TBL_DAT1_BASE_IDX                                                                   0
#define regUVD_JPEG_TBL_IDX                                                                             0x00f3
#define regUVD_JPEG_TBL_IDX_BASE_IDX                                                                    0
#define regUVD_JPEG_ENC_CGC_CNTL                                                                        0x00f5
#define regUVD_JPEG_ENC_CGC_CNTL_BASE_IDX                                                               0
#define regUVD_JPEG_ENC_SCRATCH0                                                                        0x00f6
#define regUVD_JPEG_ENC_SCRATCH0_BASE_IDX                                                               0
#define regUVD_JPEG_ENC_SOFT_RST                                                                        0x00f7
#define regUVD_JPEG_ENC_SOFT_RST_BASE_IDX                                                               0


// addressBlock: uvd0_uvd_jrbc_dec
// base address: 0x1e400
#define regUVD_JRBC_RB_WPTR                                                                             0x0100
#define regUVD_JRBC_RB_WPTR_BASE_IDX                                                                    0
#define regUVD_JRBC_RB_CNTL                                                                             0x0101
#define regUVD_JRBC_RB_CNTL_BASE_IDX                                                                    0
#define regUVD_JRBC_IB_SIZE                                                                             0x0102
#define regUVD_JRBC_IB_SIZE_BASE_IDX                                                                    0
#define regUVD_JRBC_URGENT_CNTL                                                                         0x0103
#define regUVD_JRBC_URGENT_CNTL_BASE_IDX                                                                0
#define regUVD_JRBC_RB_REF_DATA                                                                         0x0104
#define regUVD_JRBC_RB_REF_DATA_BASE_IDX                                                                0
#define regUVD_JRBC_RB_COND_RD_TIMER                                                                    0x0105
#define regUVD_JRBC_RB_COND_RD_TIMER_BASE_IDX                                                           0
#define regUVD_JRBC_SOFT_RESET                                                                          0x0108
#define regUVD_JRBC_SOFT_RESET_BASE_IDX                                                                 0
#define regUVD_JRBC_STATUS                                                                              0x0109
#define regUVD_JRBC_STATUS_BASE_IDX                                                                     0
#define regUVD_JRBC_RB_RPTR                                                                             0x010a
#define regUVD_JRBC_RB_RPTR_BASE_IDX                                                                    0
#define regUVD_JRBC_RB_BUF_STATUS                                                                       0x010b
#define regUVD_JRBC_RB_BUF_STATUS_BASE_IDX                                                              0
#define regUVD_JRBC_IB_BUF_STATUS                                                                       0x010c
#define regUVD_JRBC_IB_BUF_STATUS_BASE_IDX                                                              0
#define regUVD_JRBC_IB_SIZE_UPDATE                                                                      0x010d
#define regUVD_JRBC_IB_SIZE_UPDATE_BASE_IDX                                                             0
#define regUVD_JRBC_IB_COND_RD_TIMER                                                                    0x010e
#define regUVD_JRBC_IB_COND_RD_TIMER_BASE_IDX                                                           0
#define regUVD_JRBC_IB_REF_DATA                                                                         0x010f
#define regUVD_JRBC_IB_REF_DATA_BASE_IDX                                                                0
#define regUVD_JPEG_PREEMPT_CMD                                                                         0x0110
#define regUVD_JPEG_PREEMPT_CMD_BASE_IDX                                                                0
#define regUVD_JPEG_PREEMPT_FENCE_DATA0                                                                 0x0111
#define regUVD_JPEG_PREEMPT_FENCE_DATA0_BASE_IDX                                                        0
#define regUVD_JPEG_PREEMPT_FENCE_DATA1                                                                 0x0112
#define regUVD_JPEG_PREEMPT_FENCE_DATA1_BASE_IDX                                                        0
#define regUVD_JRBC_RB_SIZE                                                                             0x0113
#define regUVD_JRBC_RB_SIZE_BASE_IDX                                                                    0
#define regUVD_JRBC_SCRATCH0                                                                            0x0114
#define regUVD_JRBC_SCRATCH0_BASE_IDX                                                                   0


// addressBlock: uvd0_uvd_jrbc_enc_dec
// base address: 0x1e480
#define regUVD_JRBC_ENC_RB_WPTR                                                                         0x0120
#define regUVD_JRBC_ENC_RB_WPTR_BASE_IDX                                                                0
#define regUVD_JRBC_ENC_RB_CNTL                                                                         0x0121
#define regUVD_JRBC_ENC_RB_CNTL_BASE_IDX                                                                0
#define regUVD_JRBC_ENC_IB_SIZE                                                                         0x0122
#define regUVD_JRBC_ENC_IB_SIZE_BASE_IDX                                                                0
#define regUVD_JRBC_ENC_URGENT_CNTL                                                                     0x0123
#define regUVD_JRBC_ENC_URGENT_CNTL_BASE_IDX                                                            0
#define regUVD_JRBC_ENC_RB_REF_DATA                                                                     0x0124
#define regUVD_JRBC_ENC_RB_REF_DATA_BASE_IDX                                                            0
#define regUVD_JRBC_ENC_RB_COND_RD_TIMER                                                                0x0125
#define regUVD_JRBC_ENC_RB_COND_RD_TIMER_BASE_IDX                                                       0
#define regUVD_JRBC_ENC_SOFT_RESET                                                                      0x0128
#define regUVD_JRBC_ENC_SOFT_RESET_BASE_IDX                                                             0
#define regUVD_JRBC_ENC_STATUS                                                                          0x0129
#define regUVD_JRBC_ENC_STATUS_BASE_IDX                                                                 0
#define regUVD_JRBC_ENC_RB_RPTR                                                                         0x012a
#define regUVD_JRBC_ENC_RB_RPTR_BASE_IDX                                                                0
#define regUVD_JRBC_ENC_RB_BUF_STATUS                                                                   0x012b
#define regUVD_JRBC_ENC_RB_BUF_STATUS_BASE_IDX                                                          0
#define regUVD_JRBC_ENC_IB_BUF_STATUS                                                                   0x012c
#define regUVD_JRBC_ENC_IB_BUF_STATUS_BASE_IDX                                                          0
#define regUVD_JRBC_ENC_IB_SIZE_UPDATE                                                                  0x012d
#define regUVD_JRBC_ENC_IB_SIZE_UPDATE_BASE_IDX                                                         0
#define regUVD_JRBC_ENC_IB_COND_RD_TIMER                                                                0x012e
#define regUVD_JRBC_ENC_IB_COND_RD_TIMER_BASE_IDX                                                       0
#define regUVD_JRBC_ENC_IB_REF_DATA                                                                     0x012f
#define regUVD_JRBC_ENC_IB_REF_DATA_BASE_IDX                                                            0
#define regUVD_JPEG_ENC_PREEMPT_CMD                                                                     0x0130
#define regUVD_JPEG_ENC_PREEMPT_CMD_BASE_IDX                                                            0
#define regUVD_JPEG_ENC_PREEMPT_FENCE_DATA0                                                             0x0131
#define regUVD_JPEG_ENC_PREEMPT_FENCE_DATA0_BASE_IDX                                                    0
#define regUVD_JPEG_ENC_PREEMPT_FENCE_DATA1                                                             0x0132
#define regUVD_JPEG_ENC_PREEMPT_FENCE_DATA1_BASE_IDX                                                    0
#define regUVD_JRBC_ENC_RB_SIZE                                                                         0x0133
#define regUVD_JRBC_ENC_RB_SIZE_BASE_IDX                                                                0
#define regUVD_JRBC_ENC_SCRATCH0                                                                        0x0134
#define regUVD_JRBC_ENC_SCRATCH0_BASE_IDX                                                               0


// addressBlock: uvd0_uvd_mpcdec
// base address: 0x20310
#define regUVD_MP_SWAP_CNTL                                                                             0x02c4
#define regUVD_MP_SWAP_CNTL_BASE_IDX                                                                    1
#define regUVD_MP_SWAP_CNTL2                                                                            0x02c5
#define regUVD_MP_SWAP_CNTL2_BASE_IDX                                                                   1
#define regUVD_MPC_LUMA_SRCH                                                                            0x02c6
#define regUVD_MPC_LUMA_SRCH_BASE_IDX                                                                   1
#define regUVD_MPC_LUMA_HIT                                                                             0x02c7
#define regUVD_MPC_LUMA_HIT_BASE_IDX                                                                    1
#define regUVD_MPC_LUMA_HITPEND                                                                         0x02c8
#define regUVD_MPC_LUMA_HITPEND_BASE_IDX                                                                1
#define regUVD_MPC_CHROMA_SRCH                                                                          0x02c9
#define regUVD_MPC_CHROMA_SRCH_BASE_IDX                                                                 1
#define regUVD_MPC_CHROMA_HIT                                                                           0x02ca
#define regUVD_MPC_CHROMA_HIT_BASE_IDX                                                                  1
#define regUVD_MPC_CHROMA_HITPEND                                                                       0x02cb
#define regUVD_MPC_CHROMA_HITPEND_BASE_IDX                                                              1
#define regUVD_MPC_CNTL                                                                                 0x02cc
#define regUVD_MPC_CNTL_BASE_IDX                                                                        1
#define regUVD_MPC_PITCH                                                                                0x02cd
#define regUVD_MPC_PITCH_BASE_IDX                                                                       1
#define regUVD_MPC_SET_MUXA0                                                                            0x02ce
#define regUVD_MPC_SET_MUXA0_BASE_IDX                                                                   1
#define regUVD_MPC_SET_MUXA1                                                                            0x02cf
#define regUVD_MPC_SET_MUXA1_BASE_IDX                                                                   1
#define regUVD_MPC_SET_MUXB0                                                                            0x02d0
#define regUVD_MPC_SET_MUXB0_BASE_IDX                                                                   1
#define regUVD_MPC_SET_MUXB1                                                                            0x02d1
#define regUVD_MPC_SET_MUXB1_BASE_IDX                                                                   1
#define regUVD_MPC_SET_MUX                                                                              0x02d2
#define regUVD_MPC_SET_MUX_BASE_IDX                                                                     1
#define regUVD_MPC_SET_ALU                                                                              0x02d3
#define regUVD_MPC_SET_ALU_BASE_IDX                                                                     1
#define regUVD_MPC_PERF0                                                                                0x02d4
#define regUVD_MPC_PERF0_BASE_IDX                                                                       1
#define regUVD_MPC_PERF1                                                                                0x02d5
#define regUVD_MPC_PERF1_BASE_IDX                                                                       1
#define regUVD_MPC_IND_INDEX                                                                            0x02d6
#define regUVD_MPC_IND_INDEX_BASE_IDX                                                                   1
#define regUVD_MPC_IND_DATA                                                                             0x02d7
#define regUVD_MPC_IND_DATA_BASE_IDX                                                                    1


// addressBlock: uvd0_uvd_pg_dec
// base address: 0x1f800
#define regUVD_PGFSM_CONFIG                                                                             0x0000
#define regUVD_PGFSM_CONFIG_BASE_IDX                                                                    1
#define regUVD_PGFSM_STATUS                                                                             0x0001
#define regUVD_PGFSM_STATUS_BASE_IDX                                                                    1
#define regUVD_POWER_STATUS                                                                             0x0004
#define regUVD_POWER_STATUS_BASE_IDX                                                                    1
#define regUVD_PG_IND_INDEX                                                                             0x0005
#define regUVD_PG_IND_INDEX_BASE_IDX                                                                    1
#define regUVD_PG_IND_DATA                                                                              0x0006
#define regUVD_PG_IND_DATA_BASE_IDX                                                                     1
#define regCC_UVD_HARVESTING                                                                            0x0007
#define regCC_UVD_HARVESTING_BASE_IDX                                                                   1
#define regUVD_JPEG_POWER_STATUS                                                                        0x000a
#define regUVD_JPEG_POWER_STATUS_BASE_IDX                                                               1
#define regUVD_DPG_LMA_CTL                                                                              0x0011
#define regUVD_DPG_LMA_CTL_BASE_IDX                                                                     1
#define regUVD_DPG_LMA_DATA                                                                             0x0012
#define regUVD_DPG_LMA_DATA_BASE_IDX                                                                    1
#define regUVD_DPG_LMA_MASK                                                                             0x0013
#define regUVD_DPG_LMA_MASK_BASE_IDX                                                                    1
#define regUVD_DPG_PAUSE                                                                                0x0014
#define regUVD_DPG_PAUSE_BASE_IDX                                                                       1
#define regUVD_SCRATCH1                                                                                 0x0015
#define regUVD_SCRATCH1_BASE_IDX                                                                        1
#define regUVD_SCRATCH2                                                                                 0x0016
#define regUVD_SCRATCH2_BASE_IDX                                                                        1
#define regUVD_SCRATCH3                                                                                 0x0017
#define regUVD_SCRATCH3_BASE_IDX                                                                        1
#define regUVD_SCRATCH4                                                                                 0x0018
#define regUVD_SCRATCH4_BASE_IDX                                                                        1
#define regUVD_SCRATCH5                                                                                 0x0019
#define regUVD_SCRATCH5_BASE_IDX                                                                        1
#define regUVD_SCRATCH6                                                                                 0x001a
#define regUVD_SCRATCH6_BASE_IDX                                                                        1
#define regUVD_SCRATCH7                                                                                 0x001b
#define regUVD_SCRATCH7_BASE_IDX                                                                        1
#define regUVD_SCRATCH8                                                                                 0x001c
#define regUVD_SCRATCH8_BASE_IDX                                                                        1
#define regUVD_SCRATCH9                                                                                 0x001d
#define regUVD_SCRATCH9_BASE_IDX                                                                        1
#define regUVD_SCRATCH10                                                                                0x001e
#define regUVD_SCRATCH10_BASE_IDX                                                                       1
#define regUVD_SCRATCH11                                                                                0x001f
#define regUVD_SCRATCH11_BASE_IDX                                                                       1
#define regUVD_SCRATCH12                                                                                0x0020
#define regUVD_SCRATCH12_BASE_IDX                                                                       1
#define regUVD_SCRATCH13                                                                                0x0021
#define regUVD_SCRATCH13_BASE_IDX                                                                       1
#define regUVD_SCRATCH14                                                                                0x0022
#define regUVD_SCRATCH14_BASE_IDX                                                                       1
#define regUVD_FREE_COUNTER_REG                                                                         0x0024
#define regUVD_FREE_COUNTER_REG_BASE_IDX                                                                1
#define regUVD_DPG_LMI_VCPU_CACHE_64BIT_BAR_LOW                                                         0x0025
#define regUVD_DPG_LMI_VCPU_CACHE_64BIT_BAR_LOW_BASE_IDX                                                1
#define regUVD_DPG_LMI_VCPU_CACHE_64BIT_BAR_HIGH                                                        0x0026
#define regUVD_DPG_LMI_VCPU_CACHE_64BIT_BAR_HIGH_BASE_IDX                                               1
#define regUVD_DPG_VCPU_CACHE_OFFSET0                                                                   0x0027
#define regUVD_DPG_VCPU_CACHE_OFFSET0_BASE_IDX                                                          1
#define regUVD_DPG_LMI_VCPU_CACHE_VMID                                                                  0x0028
#define regUVD_DPG_LMI_VCPU_CACHE_VMID_BASE_IDX                                                         1
#define regUVD_PF_STATUS                                                                                0x0039
#define regUVD_PF_STATUS_BASE_IDX                                                                       1
#define regUVD_FW_VERSION                                                                               0x003a
#define regUVD_FW_VERSION_BASE_IDX                                                                      1
#define regUVD_DPG_CLK_EN_VCPU_REPORT                                                                   0x003c
#define regUVD_DPG_CLK_EN_VCPU_REPORT_BASE_IDX                                                          1
#define regUVD_GFX8_ADDR_CONFIG                                                                         0x0049
#define regUVD_GFX8_ADDR_CONFIG_BASE_IDX                                                                1
#define regUVD_GFX10_ADDR_CONFIG                                                                        0x004a
#define regUVD_GFX10_ADDR_CONFIG_BASE_IDX                                                               1
#define regUVD_GPCNT2_CNTL                                                                              0x004b
#define regUVD_GPCNT2_CNTL_BASE_IDX                                                                     1
#define regUVD_GPCNT2_TARGET_LOWER                                                                      0x004c
#define regUVD_GPCNT2_TARGET_LOWER_BASE_IDX                                                             1
#define regUVD_GPCNT2_STATUS_LOWER                                                                      0x004d
#define regUVD_GPCNT2_STATUS_LOWER_BASE_IDX                                                             1
#define regUVD_GPCNT2_TARGET_UPPER                                                                      0x004e
#define regUVD_GPCNT2_TARGET_UPPER_BASE_IDX                                                             1
#define regUVD_GPCNT2_STATUS_UPPER                                                                      0x004f
#define regUVD_GPCNT2_STATUS_UPPER_BASE_IDX                                                             1
#define regUVD_GPCNT3_CNTL                                                                              0x0050
#define regUVD_GPCNT3_CNTL_BASE_IDX                                                                     1
#define regUVD_GPCNT3_TARGET_LOWER                                                                      0x0051
#define regUVD_GPCNT3_TARGET_LOWER_BASE_IDX                                                             1
#define regUVD_GPCNT3_STATUS_LOWER                                                                      0x0052
#define regUVD_GPCNT3_STATUS_LOWER_BASE_IDX                                                             1
#define regUVD_GPCNT3_TARGET_UPPER                                                                      0x0053
#define regUVD_GPCNT3_TARGET_UPPER_BASE_IDX                                                             1
#define regUVD_GPCNT3_STATUS_UPPER                                                                      0x0054
#define regUVD_GPCNT3_STATUS_UPPER_BASE_IDX                                                             1
#define regUVD_VCLK_DS_CNTL                                                                             0x0055
#define regUVD_VCLK_DS_CNTL_BASE_IDX                                                                    1
#define regUVD_DCLK_DS_CNTL                                                                             0x0056
#define regUVD_DCLK_DS_CNTL_BASE_IDX                                                                    1
#define regUVD_RAS_VCPU_VCODEC_STATUS                                                                   0x0057
#define regUVD_RAS_VCPU_VCODEC_STATUS_BASE_IDX                                                          1
#define regUVD_RAS_MMSCH_FATAL_ERROR                                                                    0x0058
#define regUVD_RAS_MMSCH_FATAL_ERROR_BASE_IDX                                                           1
#define regUVD_RAS_JPEG0_STATUS                                                                         0x0059
#define regUVD_RAS_JPEG0_STATUS_BASE_IDX                                                                1
#define regUVD_RAS_JPEG1_STATUS                                                                         0x005a
#define regUVD_RAS_JPEG1_STATUS_BASE_IDX                                                                1
#define regUVD_RAS_CNTL_PMI_ARB                                                                         0x005b
#define regUVD_RAS_CNTL_PMI_ARB_BASE_IDX                                                                1


// addressBlock: uvd0_uvd_rbcdec
// base address: 0x20370
#define regUVD_RBC_IB_SIZE                                                                              0x02dc
#define regUVD_RBC_IB_SIZE_BASE_IDX                                                                     1
#define regUVD_RBC_IB_SIZE_UPDATE                                                                       0x02dd
#define regUVD_RBC_IB_SIZE_UPDATE_BASE_IDX                                                              1
#define regUVD_RBC_RB_CNTL                                                                              0x02de
#define regUVD_RBC_RB_CNTL_BASE_IDX                                                                     1
#define regUVD_RBC_RB_RPTR_ADDR                                                                         0x02df
#define regUVD_RBC_RB_RPTR_ADDR_BASE_IDX                                                                1
#define regUVD_RBC_RB_RPTR                                                                              0x02e0
#define regUVD_RBC_RB_RPTR_BASE_IDX                                                                     1
#define regUVD_RBC_RB_WPTR                                                                              0x02e1
#define regUVD_RBC_RB_WPTR_BASE_IDX                                                                     1
#define regUVD_RBC_VCPU_ACCESS                                                                          0x02e2
#define regUVD_RBC_VCPU_ACCESS_BASE_IDX                                                                 1
#define regUVD_FW_SEMAPHORE_CNTL                                                                        0x02e3
#define regUVD_FW_SEMAPHORE_CNTL_BASE_IDX                                                               1
#define regUVD_RBC_READ_REQ_URGENT_CNTL                                                                 0x02e5
#define regUVD_RBC_READ_REQ_URGENT_CNTL_BASE_IDX                                                        1
#define regUVD_RBC_RB_WPTR_CNTL                                                                         0x02e6
#define regUVD_RBC_RB_WPTR_CNTL_BASE_IDX                                                                1
#define regUVD_RBC_WPTR_STATUS                                                                          0x02e7
#define regUVD_RBC_WPTR_STATUS_BASE_IDX                                                                 1
#define regUVD_RBC_WPTR_POLL_CNTL                                                                       0x02e8
#define regUVD_RBC_WPTR_POLL_CNTL_BASE_IDX                                                              1
#define regUVD_RBC_WPTR_POLL_ADDR                                                                       0x02e9
#define regUVD_RBC_WPTR_POLL_ADDR_BASE_IDX                                                              1
#define regUVD_SEMA_CMD                                                                                 0x02ea
#define regUVD_SEMA_CMD_BASE_IDX                                                                        1
#define regUVD_SEMA_ADDR_LOW                                                                            0x02eb
#define regUVD_SEMA_ADDR_LOW_BASE_IDX                                                                   1
#define regUVD_SEMA_ADDR_HIGH                                                                           0x02ec
#define regUVD_SEMA_ADDR_HIGH_BASE_IDX                                                                  1
#define regUVD_ENGINE_CNTL                                                                              0x02ed
#define regUVD_ENGINE_CNTL_BASE_IDX                                                                     1
#define regUVD_SEMA_TIMEOUT_STATUS                                                                      0x02ee
#define regUVD_SEMA_TIMEOUT_STATUS_BASE_IDX                                                             1
#define regUVD_SEMA_CNTL                                                                                0x02ef
#define regUVD_SEMA_CNTL_BASE_IDX                                                                       1
#define regUVD_SEMA_SIGNAL_INCOMPLETE_TIMEOUT_CNTL                                                      0x02f0
#define regUVD_SEMA_SIGNAL_INCOMPLETE_TIMEOUT_CNTL_BASE_IDX                                             1
#define regUVD_SEMA_WAIT_FAULT_TIMEOUT_CNTL                                                             0x02f1
#define regUVD_SEMA_WAIT_FAULT_TIMEOUT_CNTL_BASE_IDX                                                    1
#define regUVD_SEMA_WAIT_INCOMPLETE_TIMEOUT_CNTL                                                        0x02f2
#define regUVD_SEMA_WAIT_INCOMPLETE_TIMEOUT_CNTL_BASE_IDX                                               1
#define regUVD_JOB_START                                                                                0x02f3
#define regUVD_JOB_START_BASE_IDX                                                                       1
#define regUVD_RBC_BUF_STATUS                                                                           0x02f4
#define regUVD_RBC_BUF_STATUS_BASE_IDX                                                                  1
#define regUVD_RBC_SWAP_CNTL                                                                            0x02f5
#define regUVD_RBC_SWAP_CNTL_BASE_IDX                                                                   1


// addressBlock: uvd0_uvddec
// base address: 0x1fa00
#define regUVD_STATUS                                                                                   0x0080
#define regUVD_STATUS_BASE_IDX                                                                          1
#define regUVD_ENC_PIPE_BUSY                                                                            0x0081
#define regUVD_ENC_PIPE_BUSY_BASE_IDX                                                                   1
#define regUVD_FW_POWER_STATUS                                                                          0x0082
#define regUVD_FW_POWER_STATUS_BASE_IDX                                                                 1
#define regUVD_CNTL                                                                                     0x0083
#define regUVD_CNTL_BASE_IDX                                                                            1
#define regUVD_SOFT_RESET                                                                               0x0084
#define regUVD_SOFT_RESET_BASE_IDX                                                                      1
#define regUVD_SOFT_RESET2                                                                              0x0085
#define regUVD_SOFT_RESET2_BASE_IDX                                                                     1
#define regUVD_MMSCH_SOFT_RESET                                                                         0x0086
#define regUVD_MMSCH_SOFT_RESET_BASE_IDX                                                                1
#define regUVD_WIG_CTRL                                                                                 0x0087
#define regUVD_WIG_CTRL_BASE_IDX                                                                        1
#define regUVD_CGC_GATE                                                                                 0x0088
#define regUVD_CGC_GATE_BASE_IDX                                                                        1
#define regUVD_CGC_STATUS                                                                               0x0089
#define regUVD_CGC_STATUS_BASE_IDX                                                                      1
#define regUVD_CGC_CTRL                                                                                 0x008a
#define regUVD_CGC_CTRL_BASE_IDX                                                                        1
#define regUVD_CGC_UDEC_STATUS                                                                          0x008b
#define regUVD_CGC_UDEC_STATUS_BASE_IDX                                                                 1
#define regUVD_SUVD_CGC_GATE                                                                            0x008c
#define regUVD_SUVD_CGC_GATE_BASE_IDX                                                                   1
#define regUVD_SUVD_CGC_STATUS                                                                          0x008d
#define regUVD_SUVD_CGC_STATUS_BASE_IDX                                                                 1
#define regUVD_SUVD_CGC_CTRL                                                                            0x008e
#define regUVD_SUVD_CGC_CTRL_BASE_IDX                                                                   1
#define regUVD_GPCOM_VCPU_CMD                                                                           0x008f
#define regUVD_GPCOM_VCPU_CMD_BASE_IDX                                                                  1
#define regUVD_GPCOM_VCPU_DATA0                                                                         0x0090
#define regUVD_GPCOM_VCPU_DATA0_BASE_IDX                                                                1
#define regUVD_GPCOM_VCPU_DATA1                                                                         0x0091
#define regUVD_GPCOM_VCPU_DATA1_BASE_IDX                                                                1
#define regUVD_GPCOM_SYS_CMD                                                                            0x0092
#define regUVD_GPCOM_SYS_CMD_BASE_IDX                                                                   1
#define regUVD_GPCOM_SYS_DATA0                                                                          0x0093
#define regUVD_GPCOM_SYS_DATA0_BASE_IDX                                                                 1
#define regUVD_GPCOM_SYS_DATA1                                                                          0x0094
#define regUVD_GPCOM_SYS_DATA1_BASE_IDX                                                                 1
#define regUVD_VCPU_INT_EN                                                                              0x0095
#define regUVD_VCPU_INT_EN_BASE_IDX                                                                     1
#define regUVD_VCPU_INT_STATUS                                                                          0x0096
#define regUVD_VCPU_INT_STATUS_BASE_IDX                                                                 1
#define regUVD_VCPU_INT_ACK                                                                             0x0097
#define regUVD_VCPU_INT_ACK_BASE_IDX                                                                    1
#define regUVD_VCPU_INT_ROUTE                                                                           0x0098
#define regUVD_VCPU_INT_ROUTE_BASE_IDX                                                                  1
#define regUVD_DRV_FW_MSG                                                                               0x0099
#define regUVD_DRV_FW_MSG_BASE_IDX                                                                      1
#define regUVD_FW_DRV_MSG_ACK                                                                           0x009a
#define regUVD_FW_DRV_MSG_ACK_BASE_IDX                                                                  1
#define regUVD_SUVD_INT_EN                                                                              0x009b
#define regUVD_SUVD_INT_EN_BASE_IDX                                                                     1
#define regUVD_SUVD_INT_STATUS                                                                          0x009c
#define regUVD_SUVD_INT_STATUS_BASE_IDX                                                                 1
#define regUVD_SUVD_INT_ACK                                                                             0x009d
#define regUVD_SUVD_INT_ACK_BASE_IDX                                                                    1
#define regUVD_ENC_VCPU_INT_EN                                                                          0x009e
#define regUVD_ENC_VCPU_INT_EN_BASE_IDX                                                                 1
#define regUVD_ENC_VCPU_INT_STATUS                                                                      0x009f
#define regUVD_ENC_VCPU_INT_STATUS_BASE_IDX                                                             1
#define regUVD_ENC_VCPU_INT_ACK                                                                         0x00a0
#define regUVD_ENC_VCPU_INT_ACK_BASE_IDX                                                                1
#define regUVD_MASTINT_EN                                                                               0x00a1
#define regUVD_MASTINT_EN_BASE_IDX                                                                      1
#define regUVD_SYS_INT_EN                                                                               0x00a2
#define regUVD_SYS_INT_EN_BASE_IDX                                                                      1
#define regUVD_SYS_INT_STATUS                                                                           0x00a3
#define regUVD_SYS_INT_STATUS_BASE_IDX                                                                  1
#define regUVD_SYS_INT_ACK                                                                              0x00a4
#define regUVD_SYS_INT_ACK_BASE_IDX                                                                     1
#define regUVD_JOB_DONE                                                                                 0x00a5
#define regUVD_JOB_DONE_BASE_IDX                                                                        1
#define regUVD_CBUF_ID                                                                                  0x00a6
#define regUVD_CBUF_ID_BASE_IDX                                                                         1
#define regUVD_CONTEXT_ID                                                                               0x00a7
#define regUVD_CONTEXT_ID_BASE_IDX                                                                      1
#define regUVD_CONTEXT_ID2                                                                              0x00a8
#define regUVD_CONTEXT_ID2_BASE_IDX                                                                     1
#define regUVD_NO_OP                                                                                    0x00a9
#define regUVD_NO_OP_BASE_IDX                                                                           1
#define regUVD_RB_BASE_LO                                                                               0x00aa
#define regUVD_RB_BASE_LO_BASE_IDX                                                                      1
#define regUVD_RB_BASE_HI                                                                               0x00ab
#define regUVD_RB_BASE_HI_BASE_IDX                                                                      1
#define regUVD_RB_SIZE                                                                                  0x00ac
#define regUVD_RB_SIZE_BASE_IDX                                                                         1
#define regUVD_RB_RPTR                                                                                  0x00ad
#define regUVD_RB_RPTR_BASE_IDX                                                                         1
#define regUVD_RB_WPTR                                                                                  0x00ae
#define regUVD_RB_WPTR_BASE_IDX                                                                         1
#define regUVD_RB_BASE_LO2                                                                              0x00af
#define regUVD_RB_BASE_LO2_BASE_IDX                                                                     1
#define regUVD_RB_BASE_HI2                                                                              0x00b0
#define regUVD_RB_BASE_HI2_BASE_IDX                                                                     1
#define regUVD_RB_SIZE2                                                                                 0x00b1
#define regUVD_RB_SIZE2_BASE_IDX                                                                        1
#define regUVD_RB_RPTR2                                                                                 0x00b2
#define regUVD_RB_RPTR2_BASE_IDX                                                                        1
#define regUVD_RB_WPTR2                                                                                 0x00b3
#define regUVD_RB_WPTR2_BASE_IDX                                                                        1
#define regUVD_RB_BASE_LO3                                                                              0x00b4
#define regUVD_RB_BASE_LO3_BASE_IDX                                                                     1
#define regUVD_RB_BASE_HI3                                                                              0x00b5
#define regUVD_RB_BASE_HI3_BASE_IDX                                                                     1
#define regUVD_RB_SIZE3                                                                                 0x00b6
#define regUVD_RB_SIZE3_BASE_IDX                                                                        1
#define regUVD_RB_RPTR3                                                                                 0x00b7
#define regUVD_RB_RPTR3_BASE_IDX                                                                        1
#define regUVD_RB_WPTR3                                                                                 0x00b8
#define regUVD_RB_WPTR3_BASE_IDX                                                                        1
#define regUVD_RB_BASE_LO4                                                                              0x00b9
#define regUVD_RB_BASE_LO4_BASE_IDX                                                                     1
#define regUVD_RB_BASE_HI4                                                                              0x00ba
#define regUVD_RB_BASE_HI4_BASE_IDX                                                                     1
#define regUVD_RB_SIZE4                                                                                 0x00bb
#define regUVD_RB_SIZE4_BASE_IDX                                                                        1
#define regUVD_RB_RPTR4                                                                                 0x00bc
#define regUVD_RB_RPTR4_BASE_IDX                                                                        1
#define regUVD_RB_WPTR4                                                                                 0x00bd
#define regUVD_RB_WPTR4_BASE_IDX                                                                        1
#define regUVD_OUT_RB_BASE_LO                                                                           0x00be
#define regUVD_OUT_RB_BASE_LO_BASE_IDX                                                                  1
#define regUVD_OUT_RB_BASE_HI                                                                           0x00bf
#define regUVD_OUT_RB_BASE_HI_BASE_IDX                                                                  1
#define regUVD_OUT_RB_SIZE                                                                              0x00c0
#define regUVD_OUT_RB_SIZE_BASE_IDX                                                                     1
#define regUVD_OUT_RB_RPTR                                                                              0x00c1
#define regUVD_OUT_RB_RPTR_BASE_IDX                                                                     1
#define regUVD_OUT_RB_WPTR                                                                              0x00c2
#define regUVD_OUT_RB_WPTR_BASE_IDX                                                                     1
#define regUVD_IOV_MAILBOX                                                                              0x00c4
#define regUVD_IOV_MAILBOX_BASE_IDX                                                                     1
#define regUVD_IOV_MAILBOX_RESP                                                                         0x00c5
#define regUVD_IOV_MAILBOX_RESP_BASE_IDX                                                                1
#define regUVD_RB_ARB_CTRL                                                                              0x00c6
#define regUVD_RB_ARB_CTRL_BASE_IDX                                                                     1
#define regUVD_CTX_INDEX                                                                                0x00c7
#define regUVD_CTX_INDEX_BASE_IDX                                                                       1
#define regUVD_CTX_DATA                                                                                 0x00c8
#define regUVD_CTX_DATA_BASE_IDX                                                                        1
#define regUVD_CXW_WR                                                                                   0x00c9
#define regUVD_CXW_WR_BASE_IDX                                                                          1
#define regUVD_CXW_WR_INT_ID                                                                            0x00ca
#define regUVD_CXW_WR_INT_ID_BASE_IDX                                                                   1
#define regUVD_CXW_WR_INT_CTX_ID                                                                        0x00cb
#define regUVD_CXW_WR_INT_CTX_ID_BASE_IDX                                                               1
#define regUVD_CXW_INT_ID                                                                               0x00cc
#define regUVD_CXW_INT_ID_BASE_IDX                                                                      1
#define regUVD_MPEG2_ERROR                                                                              0x00cd
#define regUVD_MPEG2_ERROR_BASE_IDX                                                                     1
#define regUVD_TOP_CTRL                                                                                 0x00cf
#define regUVD_TOP_CTRL_BASE_IDX                                                                        1
#define regUVD_YBASE                                                                                    0x00d0
#define regUVD_YBASE_BASE_IDX                                                                           1
#define regUVD_UVBASE                                                                                   0x00d1
#define regUVD_UVBASE_BASE_IDX                                                                          1
#define regUVD_PITCH                                                                                    0x00d2
#define regUVD_PITCH_BASE_IDX                                                                           1
#define regUVD_WIDTH                                                                                    0x00d3
#define regUVD_WIDTH_BASE_IDX                                                                           1
#define regUVD_HEIGHT                                                                                   0x00d4
#define regUVD_HEIGHT_BASE_IDX                                                                          1
#define regUVD_PICCOUNT                                                                                 0x00d5
#define regUVD_PICCOUNT_BASE_IDX                                                                        1
#define regUVD_MPRD_INITIAL_XY                                                                          0x00d6
#define regUVD_MPRD_INITIAL_XY_BASE_IDX                                                                 1
#define regUVD_MPEG2_CTRL                                                                               0x00d7
#define regUVD_MPEG2_CTRL_BASE_IDX                                                                      1
#define regUVD_MB_CTL_BUF_BASE                                                                          0x00d8
#define regUVD_MB_CTL_BUF_BASE_BASE_IDX                                                                 1
#define regUVD_PIC_CTL_BUF_BASE                                                                         0x00d9
#define regUVD_PIC_CTL_BUF_BASE_BASE_IDX                                                                1
#define regUVD_DXVA_BUF_SIZE                                                                            0x00da
#define regUVD_DXVA_BUF_SIZE_BASE_IDX                                                                   1
#define regUVD_SCRATCH_NP                                                                               0x00db
#define regUVD_SCRATCH_NP_BASE_IDX                                                                      1
#define regUVD_CLK_SWT_HANDSHAKE                                                                        0x00dc
#define regUVD_CLK_SWT_HANDSHAKE_BASE_IDX                                                               1
#define regUVD_VERSION                                                                                  0x00dd
#define regUVD_VERSION_BASE_IDX                                                                         1
#define regUVD_GP_SCRATCH0                                                                              0x00de
#define regUVD_GP_SCRATCH0_BASE_IDX                                                                     1
#define regUVD_GP_SCRATCH1                                                                              0x00df
#define regUVD_GP_SCRATCH1_BASE_IDX                                                                     1
#define regUVD_GP_SCRATCH2                                                                              0x00e0
#define regUVD_GP_SCRATCH2_BASE_IDX                                                                     1
#define regUVD_GP_SCRATCH3                                                                              0x00e1
#define regUVD_GP_SCRATCH3_BASE_IDX                                                                     1
#define regUVD_GP_SCRATCH4                                                                              0x00e2
#define regUVD_GP_SCRATCH4_BASE_IDX                                                                     1
#define regUVD_GP_SCRATCH5                                                                              0x00e3
#define regUVD_GP_SCRATCH5_BASE_IDX                                                                     1
#define regUVD_GP_SCRATCH6                                                                              0x00e4
#define regUVD_GP_SCRATCH6_BASE_IDX                                                                     1
#define regUVD_GP_SCRATCH7                                                                              0x00e5
#define regUVD_GP_SCRATCH7_BASE_IDX                                                                     1
#define regUVD_GP_SCRATCH8                                                                              0x00e6
#define regUVD_GP_SCRATCH8_BASE_IDX                                                                     1
#define regUVD_GP_SCRATCH9                                                                              0x00e7
#define regUVD_GP_SCRATCH9_BASE_IDX                                                                     1
#define regUVD_GP_SCRATCH10                                                                             0x00e8
#define regUVD_GP_SCRATCH10_BASE_IDX                                                                    1
#define regUVD_GP_SCRATCH11                                                                             0x00e9
#define regUVD_GP_SCRATCH11_BASE_IDX                                                                    1
#define regUVD_GP_SCRATCH12                                                                             0x00ea
#define regUVD_GP_SCRATCH12_BASE_IDX                                                                    1
#define regUVD_GP_SCRATCH13                                                                             0x00eb
#define regUVD_GP_SCRATCH13_BASE_IDX                                                                    1
#define regUVD_GP_SCRATCH14                                                                             0x00ec
#define regUVD_GP_SCRATCH14_BASE_IDX                                                                    1
#define regUVD_GP_SCRATCH15                                                                             0x00ed
#define regUVD_GP_SCRATCH15_BASE_IDX                                                                    1
#define regUVD_GP_SCRATCH16                                                                             0x00ee
#define regUVD_GP_SCRATCH16_BASE_IDX                                                                    1
#define regUVD_GP_SCRATCH17                                                                             0x00ef
#define regUVD_GP_SCRATCH17_BASE_IDX                                                                    1
#define regUVD_GP_SCRATCH18                                                                             0x00f0
#define regUVD_GP_SCRATCH18_BASE_IDX                                                                    1
#define regUVD_GP_SCRATCH19                                                                             0x00f1
#define regUVD_GP_SCRATCH19_BASE_IDX                                                                    1
#define regUVD_GP_SCRATCH20                                                                             0x00f2
#define regUVD_GP_SCRATCH20_BASE_IDX                                                                    1
#define regUVD_GP_SCRATCH21                                                                             0x00f3
#define regUVD_GP_SCRATCH21_BASE_IDX                                                                    1
#define regUVD_GP_SCRATCH22                                                                             0x00f4
#define regUVD_GP_SCRATCH22_BASE_IDX                                                                    1
#define regUVD_GP_SCRATCH23                                                                             0x00f5
#define regUVD_GP_SCRATCH23_BASE_IDX                                                                    1


#endif
