#
# $Id: reports.t,v 1.9 1993/06/15 21:19:09 mh Exp $
#
proc putlines {fout lst} {
    foreach ln $lst {
	puts $fout $ln
    }
}
proc putfld {fout f tag {prefix ""}} {
    upvar 1 $f flds
    set data [string trimright [string trim $flds($tag) " \t"] "\n"]
    if {"$prefix" == ""} {
	set prefix [string trimright [string trimleft $tag >] :]
    }
    puts $fout "${prefix}:%" nonewline
    puts $fout "T{\n.na"
    puts $fout $data
    puts $fout ".ad\nT}"
}
proc endtbl {fout} {
    putlines $fout { {.TE} }
}
proc starttbl {fout} {
    putlines $fout { {.sp} {.sp} {.TS} {box, expand, tab(%);} }
}
proc heading {fout s} {
    putlines $fout [list $s _]
}
proc freeform_text {fout f tag {prefix ""}} {
    upvar 1 $f flds
    if {![info exists flds($tag)]} {
	return
    }
    set data [string trimright [string trim $flds($tag) " \t"] "\n"]
    if {"$prefix" == ""} {
	set prefix [string trimright [string trimleft $tag >] :]
    }
    starttbl $fout
    putlines $fout [list {lp12 .} $prefix]
    endtbl $fout

    putlines $fout { {.sp} {.nf} }
    puts $fout $data
    putlines $fout { {.fi} }
}

proc formatfullpr {fin fout} {
    parsepr $fin flds

    ###################################
    starttbl $fout
    putlines $fout [list {cp12 s s.} {Problem Report} [exec date] {.TE} ]

    ###################################
    starttbl $fout
    putlines $fout {
	{cp12 s s}
	{lp10w(1i) lw(4i) s.}
    }
    heading $fout Identification
    putfld $fout flds {>Number} {Gnats bug No.}
    putfld $fout flds {>Category} {Problem Category}
    putfld $fout flds {>Release}
    putfld $fout flds {>Originator}
    putfld $fout flds {>Arrival-Date}
    putfld $fout flds {>Organization}
    endtbl $fout

    ###################################
    starttbl $fout
    putlines $fout {
	{cp12 s s}
	{lp10w(1i) lw(4i) s.}
    }
    heading $fout {Problem Definition}
    putfld $fout flds {>Class} {Problem Class/Type}
    putfld $fout flds {>Priority}
    putfld $fout flds {>Synopsis}
    putfld $fout flds {>Environment}
    putfld $fout flds {>Description}
    endtbl $fout

    freeform_text $fout flds {>How-To-Repeat}
    freeform_text $fout flds {>Audit-Trail}
    freeform_text $fout flds {>X-Journal}
    freeform_text $fout flds {>Unformatted}
}

proc fullreport {prid} {
    global TkGnats
    set fin [open "|query-pr --full $prid" "r"]
    set fout [open "|groff -t -ms | $TkGnats(PSPrintSpooler)" "w"]
    formatfullpr $fin $fout
    close $fin
    close $fout
}

proc summary_report {fname {preview "no"}} {
    global Query TkGnats

    # set fin [open "|query-pr $q_str --summary" "r"]
    set fin [open "$fname" r]
    if {"$preview" != "no"} {
	set previewfile /tmp/tkq.ps.$TkGnats(LogName)
	set fout [open "|groff -t -ms > $previewfile" w]
	# set fout [open "|cat > /tmp/gout" w]
    } else {
	set fout [open "|groff -t -ms | $TkGnats(PSPrintSpooler)" "w"]
    }

    # title section
    putlines $fout {
	{.\" title section}
	{.TL}
	{Problem Report Summary}
	{.sp 1}
    }
    puts $fout "[exec date]"

    # format section
    putlines $fout {
	{.ds CF \\n(mo / \\n(dy / \\n(yr}
	{.sp 4}
	{.TS H}
	{box;}
	{L|L|L|L|L|L|Lw(2.5i)}
	{L|L|L|L|L|L|Lw(2.5i).}
    }

    # table heading
    putlines $fout {
	"No\tResp\tCategory\tState\tSeverity\tPriority\tSynopsis"
	{=}
	{.TH}
    }

    while {[gets $fin ln]>=0} {

# no          resp            cat     state      severity    prio    synopsis
set Query(exp) \
{([ ]+[0-9]+)[ ]+([^ ]+)[ ]+([^ ]+)[ ]+([^ ]+)[ ]+([^ ]+)[ ]+([^ ]+)[ ]+(.*)}

	regexp $Query(exp) $ln junk no resp cat state prio severity synopsis

	case $cat "_*" {
	    continue
	}

	puts $fout \
	    "$no\t$resp\t$cat\t$state\t$severity\t$prio" nonewline

	puts $fout "\tT{\n.na\n$synopsis\n.ad\nT}"
	puts $fout "_"
	workingMsg
    }
    # trailer
    puts $fout ".TE"

    close $fin
    close $fout
    if {"$preview" != "no"} {
	exec sh -c \
	 "[format $TkGnats(PSPreviewer) $previewfile]\;rm -f $previewfile"  &
	schedule_reap
    }
}
