/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.Util;

class SwitchCmd
implements Command {
    private static final String[] validCmds = new String[]{"-exact", "-glob", "-regexp", "--"};
    private static final int EXACT = 0;
    private static final int GLOB = 1;
    private static final int REGEXP = 2;
    private static final int LAST = 3;

    public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        TclObject[] tclObjectArray2 = null;
        int n = 0;
        int n2 = 1;
        while (n2 < tclObjectArray.length) {
            if (!tclObjectArray[n2].toString().startsWith("-")) break;
            int n3 = TclIndex.get((Interp)interp, (TclObject)tclObjectArray[n2], (String[])validCmds, (String)"option", (int)1);
            if (n3 == 3) {
                ++n2;
                break;
            }
            if (n3 > 3) {
                throw new TclException(interp, "SwitchCmd.cmdProc: bad option " + n3 + " index to validCmds");
            }
            n = n3;
            ++n2;
        }
        if (tclObjectArray.length - n2 < 2) {
            throw new TclNumArgsException(interp, 1, tclObjectArray, "?switches? string pattern body ... ?default body?");
        }
        String string = tclObjectArray[n2].toString();
        if (tclObjectArray.length - ++n2 == 1) {
            tclObjectArray2 = TclList.getElements(interp, tclObjectArray[n2]);
            n2 = 0;
        } else {
            tclObjectArray2 = tclObjectArray;
        }
        while (n2 < tclObjectArray2.length) {
            if (n2 == tclObjectArray2.length - 1) {
                throw new TclException(interp, "extra switch pattern with no body");
            }
            boolean bl = false;
            String string2 = tclObjectArray2[n2].toString();
            if (n2 == tclObjectArray2.length - 2 && string2.equals("default")) {
                bl = true;
            } else {
                switch (n) {
                    case 0: {
                        bl = string.equals(string2);
                        break;
                    }
                    case 1: {
                        bl = Util.stringMatch(string, string2);
                        break;
                    }
                    case 2: {
                        TclObject tclObject = tclObjectArray2[n2];
                        boolean bl2 = bl = Util.regexMatcher != null ? Util.regexMatcher.match(interp, string, tclObject.toString()) : false;
                    }
                }
            }
            if (bl) {
                int n4 = n2 + 1;
                while (true) {
                    if (n4 >= tclObjectArray2.length) {
                        throw new TclException(interp, "no body specified for pattern \"" + tclObjectArray2[n2] + "\"");
                    }
                    if (!tclObjectArray2[n4].toString().equals("-")) break;
                    n4 += 2;
                }
                try {
                    interp.eval(tclObjectArray2[n4], 0);
                    return;
                }
                catch (TclException tclException) {
                    if (tclException.getCompletionCode() == 1) {
                        interp.addErrorInfo("\n    (\"" + tclObjectArray2[n2] + "\" arm line " + interp.errorLine + ")");
                    }
                    throw tclException;
                }
            }
            n2 += 2;
        }
    }

    SwitchCmd() {
    }
}

