       PROGRAM KINETICS16

C      PROGRAM SHUNONG GRAD KINETICS16
C Zone Electrophoresis of two interacting solutes in a gradient 
C of polyacrylamide
C Diffusion coefficient corrected
C 1 designates monomer; 2, dimer

      IMPLICIT REAL*8 (A-H,O-Z)

      real *8 t1,t2,tsecnd
      COMMON C(14285,2,2),X(14285),V(14285,2),DEFF(14285,2),GZERO(2),
     [       Y(14285),GEL(14285),PM(2),DLAMBDA(14285,2)

C     call mttimes
      t1 = tsecnd()

      IT=42000
C     IT=420

      N=14285
C     N=20
      NP=N-1
      NPP=N-2
      NSEG=287
C     NSEG=9

      L=1
      LN=2

      DX=0.7E-03
      DT=5.0E-01

      GZERO(1)=.5E-05
      GZERO(2)=.5E-05

      RK1=34.0E00
      RK2=5.0E-01*RK1*GZERO(1)**2/GZERO(2)

      T=0.0E00

      CALL FILLUP(N,DX,NSEG,L,LN)
      CALL VELOCITY(DT,DX,N)
      CALL OUT(T,N,L,NP,DT,DX)

      RK1=RK1*DT
      RK2=RK2*DT

      DO 1 I=1,IT
       C(2,1,LN)=C(2,1,L)+DLAMBDA(2,1)*(C(3,1,L)-C(2,1,L))-
     [   V(2,1)*C(2,1,L)-RK1*C(2,1,L)**2+2.0E00*RK2*C(2,2,L)

       C(2,2,LN)=C(2,2,L)+DLAMBDA(2,2)*(C(3,2,L)-C(2,2,L))-
     [   V(2,2)*C(2,2,L)+5.0E-01*RK1*C(2,1,L)**2-RK2*C(2,2,L)

       DO 3 J=3,NPP

        C(J,1,LN)=C(J,1,L)+DLAMBDA(J,1)*(C(J+1,1,L)-C(J,1,L))-
     [    DLAMBDA(J-1,1)*(C(J,1,L)-C(J-1,1,L))-V(J,1)*C(J,1,L)+
     [    V(J-1,1)*C(J-1,1,L)-RK1*C(J,1,L)**2+2.0E00*RK2*C(J,2,L)

        C(J,2,LN)=C(J,2,L)+DLAMBDA(J,2)*(C(J+1,2,L)-C(J,2,L))-
     [    DLAMBDA(J-1,2)*(C(J,2,L)-C(J-1,2,L))-V(J,2)*C(J,2,L)+
     [    V(J-1,2)*C(J-1,2,L)+5.0E-01*RK1*C(J,1,L)**2-RK2*C(J,2,L)

   3   CONTINUE

       C(NP,1,LN)=C(NP,1,L)-DLAMBDA(NP,1)*C(NP,1,L)-DLAMBDA(NPP,1)
     [ *(C(NP,1,L)-C(NPP,1,L))-V(NP,1)*C(NP,1,L)+V(NPP,1)*C(NPP,1,L)
     [ -RK1*C(NP,1,L)**2+2.0E00*RK2*C(NP,2,L)

       C(NP,2,LN)=C(NP,2,L)-DLAMBDA(NP,2)*C(NP,2,L)-DLAMBDA(NPP,2)
     [ *(C(NP,2,L)-C(NPP,2,L))-V(NP,2)*C(NP,2,L)+V(NPP,2)*C(NPP,2,L)
     [ +5.0E-01*RK1*C(NP,1,L)**2-RK2*C(NP,2,L)

       T=DBLE(I)*DT

       LSAVE=L
       L=LN
       LN=LSAVE

   1  CONTINUE

      CALL OUT(T,N,L,NP,DT,DX)
C     call mttimes
      t2 = tsecnd()
      print *, t2-t1
      STOP
      END

      SUBROUTINE FILLUP(N,DX,NSEG,L,LN)
      IMPLICIT REAL*8 (A-H,O-Z)
      COMMON C(14285,2,2),X(14285),V(14285,2),DEFF(14285,2),GZERO(2)
     [       ,Y(14285),GEL(14285),PM(2),DLAMBDA(14285,2)

      X(1)=0.0E00
      Y(1)=0.0E00

      DO 1 J=2,N
       X(J)=DBLE(J-1)*DX
       Y(J)=X(J)-5.0E-01*DX
   1  CONTINUE

      DO 2 M=1,2
       DO 3 J=1,N
        C(J,M,L)=0.0E00
        C(J,M,LN)=0.0E00
   3   CONTINUE

       DO 4 J=2,NSEG
        C(J,M,L)=GZERO(M)
        C(J,M,LN)=GZERO(M)
   4   CONTINUE
   2  CONTINUE

      RETURN
      END

      SUBROUTINE VELOCITY(DT,DX,N)
      IMPLICIT REAL*8 (A-H,O-Z)
      COMMON C(14285,2,2),X(14285),V(14285,2),DEFF(14285,2),GZERO(2),
     [       Y(14285),GEL(14285),PM(2),DLAMBDA(14285,2)

      GEL(1)=1.0E01

      V(1,1)=6.0E-04
      V(1,2)=5.0E-04

      PM(1)=-6.9018E-02
      PM(2)=-0.10799

      DEFF(1,1)=2.1E-07
      DEFF(1,2)=1.67E-07

      DO 1 I=2,N
       GEL(I)=GEL(I-1)+0.7E-03

       V(I,1)=V(1,1)*10**(PM(1)*X(I))
       V(I,2)=V(1,2)*10**(PM(2)*X(I))

       DEFF(I,1)=DEFF(1,1)-5.0E-01*DX*V(I,1)+5.0E-01*DT*(V(I,1)**2)
       DEFF(I,2)=DEFF(1,2)-5.0E-01*DX*V(I,2)+5.0E-01*DT*(V(I,2)**2)
   1  CONTINUE

      DO 2 I=1,N
       V(I,1)=V(I,1)*DT/DX
       V(I,2)=V(I,2)*DT/DX

       DLAMBDA(I,1)=DEFF(I,1)*DT/(DX**2)
       DLAMBDA(I,2)=DEFF(I,2)*DT/(DX**2)

   2  CONTINUE

      RETURN
      END

      SUBROUTINE OUT(T,N,L,NP,DT,DX)
      IMPLICIT REAL*8 (A-H,O-Z)
      COMMON C(14285,2,2),X(14285),V(14285,2),DEFF(14285,2),GZERO(2),
     [       Y(14285),GEL(14285),PM(2),DDLAMBDA(14285,2)
      SAVE SIGSQMI,YMEANMI,SIGSQM2I,YMEANM2I

C     print *, '*** EDIT *** ', T

      SUM1M=0.0E00
      SUM2M=0.0E00
      SUM3M=0.0E00
      SUM1M2=0.0E00
      SUM2M2=0.0E00
      SUM3M2=0.0E00  

      DO 1 J=2,NP
        YSQ=Y(J)**2
        SUM1M=SUM1M+C(J,1,L)
        SUM2M=SUM2M+Y(J)*C(J,1,L)
        SUM3M=SUM3M+YSQ*C(J,1,L)
        SUM1M2=SUM1M2+C(J,2,L)
        SUM2M2=SUM2M2+Y(J)*C(J,2,L)
        SUM3M2=SUM3M2+YSQ*C(J,2,L)
   1  CONTINUE

      YMEANM=SUM2M/SUM1M
      SIGSQM=SUM3M/SUM1M-YMEANM**2
      SIGM=SQRT(SIGSQM)
      YMEANM2=SUM2M2/SUM1M2
      SIGSQM2=SUM3M2/SUM1M2-YMEANM2**2
      SIGM2=SQRT(SIGSQM2)

      IF(T.EQ.0.0E00) THEN
       SIGSQMI=SIGSQM
       YMEANMI=YMEANM
       SIGSQM2I=SIGSQM2
       YMEANM2I=YMEANM2
      END IF

C     print *, YMEANM
C     print *, SIGSQM
C     print *, SIGM
C     print *, SUM1M
C     print *, YMEANM2
C     print *, SIGSQM2
C     print *, SIGM2
C     print *, SUM1M2

      IF(T.GT.0.0E00) THEN
        DIFM=5.0E-01*(SIGSQM-SIGSQMI)/T
        VELOCITYM=(YMEANM-YMEANMI)/T
        DIFM2=5.0E-01*(SIGSQM2-SIGSQM2I)/T
        VELOCITYM2=(YMEANM2-YMEANM2I)/T
C       print *, DIFM
C       print *, VELOCITYM
C       print *, DIFM2
C       print *, VELOCITYM2
C     ELSE
C print *, 0.0
C print *, 0.0
C print *, 0.0
C print *, 0.0
      END IF

      RETURN
      END
