
(* We have commented out package commands from this file. *)

(* Copyright 1989 Wolfram Research Inc., V1.2 *)

		(**  Graphics with Polyhedra  **)

(* by Roman Maeder *)


(* BeginPackage["Graphics`Polyhedra`"] *)

(* Platonic solids *)

Polyhedron::usage = "Polyhedron[name] gives a Graphics3D
	representing the specified solid centered at the origin
	and with unit distance to the midpoints of the edges.
	Polyhedron[name, center, size] uses the given center
	and size."

Vertices::usage = "Vertices[name] gives a list of the vertex coordinates
	for the named solid."

Faces::usage = "Faces[name] gives a list of the faces
	for the named solid.
	Each face is a list of the numbers of the vertices that
	comprise that face."

Polyhedra::usage = "Polyhedra gives a list of the known polyhedra."

Icosahedron::usage =
	"Icosahedron[(center:{0,0,0}, (scale:1))] gives a Graphics3D
	representing an icosahedron with specified center 
	position and scale."

Dodecahedron::usage =
	"Dodecahedron[(center:{0,0,0}, (scale:1))] gives a Graphics3D
	representing a dodecahedron with specified center
	position and scale."

Octahedron::usage =
	"Octahedron[(center:{0,0,0}, (scale:1))] gives a Graphics3D
	representing an octahedron with specified center
	position and scale."

Cube::usage =
	"Cube[(center:{0,0,0}, (scale:1))] gives a Graphics3D
	representing a cube with specified center
	position and scale."

Tetrahedron::usage =
	"Tetrahedron[(center:{0,0,0}, (scale:1))] gives a Graphics3D
	representing a tetrahedron with specified center
	position and scale."

(* Stellations *)

Stellate::usage =
	"Stellate[expr, (ratio:2)] replaces
	each polygon in expr by a pyramid with the polygon as its base.
	Stellation ratios < 1 give concave figures."

Polyhedra = {Dodecahedron, Icosahedron, Octahedron, Hexahedron, Tetrahedron,
	     Cube}

(* Begin["`Private`"] *)

Polyhedron[name_Symbol, pos_:{0.0,0.0,0.0}, scale_:1.0] := 
    Block[{vertices = Vertices[name],
           faces = Faces[name]},
	Graphics3D[ Polygon /@
		Map[scale # + pos &, (vertices[[#]]&) /@ faces, {2}] ]
    ]	/; MemberQ[Polyhedra, name]

Dodecahedron /: Faces[Dodecahedron] =
     {{3, 1, 2, 5, 6}, {12, 11, 5, 2, 7}, {17, 13, 6, 5, 11}, 
      {14, 9, 3, 6, 13}, {10, 4, 1, 3, 9}, {8, 7, 2, 1, 4}, 
      {4, 10, 16, 15, 8}, {9, 14, 19, 16, 10}, {13, 17, 20, 19, 14}, 
      {11, 12, 18, 20, 17}, {7, 8, 15, 18, 12}, {18, 15, 16, 19, 20}}

Dodecahedron /: Vertices[Dodecahedron] =
  {{0.1171133902139618, -1.000511576276664, -0.3621589273242113}, 
   {-0.2984036824225265, -0.5817988070943417, -0.847563231579627}, 
   {0.7957196239318588, -0.6599726122576239, -0.2777850442631916}, 
   {-0.2354424399154574, -0.995440477478119, 0.3155362956874772}, 
   {0.1233988775001608, 0.01751887980296279, -1.063185706833948}, 
   {0.7996042687105845, -0.03079518881785797, -0.7110434210240867}, 
   {-0.907763186347153, -0.3179489854175332, -0.4698643668832807}, 
   {-0.868850998503861, -0.5735935968779865, 0.2489706732667203}, 
   {0.862565511217654, -0.4444368592016375, 0.4520561062430151}, 
   {0.2252723078505214, -0.6517674020412752, 0.81874886058316}, 
   {-0.2252723078505258, 0.6517674020412736, -0.818748860583157}, 
   {-0.862565511217653, 0.4444368592016384, -0.4520561062430158}, 
   {0.868850998503857, 0.5735935968779876, -0.2489706732667215}, 
   {0.907763186347152, 0.317948985417531, 0.469864366883284}, 
   {-0.7996042687105915, 0.03079518881786086, 0.7110434210240858}, 
   {-0.1233988775001686, -0.01751887980296174, 1.063185706833949}, 
   {0.2354424399154601, 0.99544047747812, -0.315536295687476}, 
   {-0.7957196239318574, 0.6599726122576284, 0.2777850442631883}, 
   {0.2984036824225249, 0.5817988070943394, 0.847563231579629}, 
   {-0.1171133902139571, 1.000511576276665, 0.3621589273242109}}

Icosahedron /: Faces[Icosahedron] =
     {{1, 2, 6}, {1, 3, 2}, {1, 4, 3}, {1, 5, 4}, {1, 6, 5}, {2, 3, 11}, 
      {2, 10, 6}, {2, 11, 10}, {3, 4, 12}, {3, 12, 11}, {4, 5, 8}, 
      {4, 8, 12}, {5, 6, 9}, {5, 9, 8}, {6, 10, 9}, {7, 8, 9}, {7, 9, 10}, 
      {7, 10, 11}, {7, 11, 12}, {7, 12, 8}}

Icosahedron /: Vertices[Icosahedron] =
  {{0.4249358858193742, -0.6234212590752522, -0.901521749427252}, 
   {-0.5999406907417391, 0.05914133178387721, -1.009227188986324}, 
   {0.4980672603913731, 0.6101449500603583, -0.872707378430782}, 
   {1.170388006823068, -0.06734654200022822, -0.0873067158600265}, 
   {0.4878971283264427, -1.037062929459035, 0.2615777778398508}, 
   {-0.606226178027942, -0.958889124295748, -0.3082004094765843}, 
   {-0.4249358858193759, 0.6234212590752533, 0.90152174942725}, 
   {0.5999406907417364, -0.05914133178387813, 1.009227188986327}, 
   {-0.4980672603913764, -0.6101449500603557, 0.87270737843078}, 
   {-1.170388006823072, 0.0673465420002311, 0.0873067158600247}, 
   {-0.4878971283264417, 1.037062929459036, -0.2615777778398516}, 
   {0.606226178027942, 0.958889124295747, 0.3082004094765856}}

Octahedron /: Faces[Octahedron] =
     {{1, 2, 3}, {1, 3, 5}, {1, 5, 6}, {1, 6, 2},
      {2, 6, 4}, {2, 4, 3}, {4, 6, 5}, {3, 4, 5}}

Octahedron /: Vertices[Octahedron] = N[ Sqrt[2]
     {{0, 0, 1}, {1, 0, 0}, {0, 1, 0},
      {0, 0, -1}, {-1, 0, 0}, {0, -1, 0}} ]

Hexahedron /: Faces[Hexahedron] =
     {{1, 2, 3, 4}, {1, 4, 6, 7}, {1, 7, 8, 2},
      {2, 8, 5, 3}, {5, 8, 7, 6}, {3, 5, 6, 4}}

Hexahedron /: Vertices[Hexahedron] = N[ Sqrt[2]/2
     {{1, 1, 1}, {-1, 1, 1}, {-1, -1, 1}, {1, -1, 1},
      {-1, -1, -1}, {1, -1, -1}, {1, 1, -1}, {-1, 1, -1}} ]

Cube/: Faces[Cube] := Faces[Hexahedron]
Cube/: Vertices[Cube] := Vertices[Hexahedron]

Tetrahedron /: Faces[Tetrahedron] =
     {{1, 2, 3}, {1, 3, 4}, {1, 4, 2}, {2, 4, 3}}

Tetrahedron /: Vertices[Tetrahedron] = N[
     {{0, 0, 3^(1/2)}, {0, (2*2^(1/2)*3^(1/2))/3, -3^(1/2)/3}, 
      {-2^(1/2), -(2^(1/2)*3^(1/2))/3, -3^(1/2)/3}, 
      {2^(1/2), -(2^(1/2)*3^(1/2))/3, -3^(1/2)/3}} ]

(* Compatibility with V1.1 Polyhedra.m *)

Icosahedron[opts___] := Polyhedron[Icosahedron, opts][[1]]

Dodecahedron[opts___] := Polyhedron[Dodecahedron, opts][[1]]

Octahedron[opts___] := Polyhedron[Octahedron, opts][[1]]

Cube[opts___] := Polyhedron[Cube, opts][[1]]

Tetrahedron[opts___] := Polyhedron[Tetrahedron, opts][[1]]


StellateFace[face_List, k_] :=
	Block[ { apex,  n = Length[face], i } ,
		apex = N [ k Apply[Plus, face] / n ] ;
		Table[ Polygon[ {apex, face[[i]], face[[ Mod[i, n] + 1 ]] }
			      ],
		     {i, n} ]
	]
	
Stellate[poly_, k_?NumberQ] := 
	Flatten [ poly /. Polygon[x_] :> StellateFace[x, k]  ]

Stellate[poly_] := Stellate[poly, 2.]

(* End[]
EndPackage[] *)
