(*^
*)
GastropodShellMorphometrics[genus_, genusaperture_, phases_] := 
Module[{l, gat, gae, triples, i, midpoints, norms, hradii, vradii, shelledge, 
centredistance, height, diameter, spireindex}, 
l = ReadGastropodShellParameters @ phases; 
gat = GastropodApertureTrajectoryParameters[genus, phases, l]; 
gae = GastropodApertureExpansionParameters[genusaperture, phases, l]; 
triples = Flatten[ 
		Table[ 
			GastropodApertureTrajectory @@ gat[[i]], 
			{i, 1, phases} 
		], 
		1 
	]; 
midpoints = .5 (Drop[triples, 1] + Drop[triples, -1]); 
norms = Norm @ Drop[#, -1]& /@ midpoints; 
hradii = Drop[ 
		Flatten @ Table[ 
			#[[{1}]]& /@ (GastropodApertureExpansion @@ gae[[i]]), 
			{i, 1, phases} 
		], 
	-1 
	]; 
vradii = 	Flatten @ Table[ 
			#[[{2}]]& /@ (GastropodApertureExpansion @@ gae[[i]]), 
			{i, 1, phases} 
		]; 
shelledge = norms + hradii; 
centredistance = Last[First @ triples - Last @ triples]; 
height = centredistance + First @ vradii + Last @ vradii; 
diameter = Plus @@ Take[Sort[shelledge, Greater], 2]; 
spireindex = height / diameter; 
{height, diameter, spireindex}  
] 
 


(*


^*)