/* vb.h */

/*
 * Mesa 3-D graphics library
 * Version:  1.2
 * Copyright (C) 1995  Brian Paul  (brianp@ssec.wisc.edu)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


/*
$Id: vb.h,v 1.5 1995/06/20 16:19:54 brianp Exp $

$Log: vb.h,v $
 * Revision 1.5  1995/06/20  16:19:54  brianp
 * unconditionally include integer win coord arrays
 *
 * Revision 1.4  1995/06/15  19:37:28  brianp
 * added integer window coords arrays, an experiment
 *
 * Revision 1.3  1995/06/02  13:55:34  brianp
 * changed from MAX_VERTICES to VB_MAX and VB_SIZE
 *
 * Revision 1.2  1995/05/22  20:59:34  brianp
 * Release 1.2
 *
 * Revision 1.1  1995/03/24  15:32:17  brianp
 * Initial revision
 *
 */


/*
 * Vertex buffer:  vertices from glVertex* are accumulated here until
 * the buffer is full or glEnd() is called.  Then the buffer is flushed
 * (rendered) and reset.
 */


#ifndef VB_H
#define VB_H


#include "GL/gl.h"
#include "config.h"



/* Flush VB when this number of vertices is accumulated:  (a multiple of 12) */
#define VB_MAX 252

/* Arrays must also accomodate new vertices from clipping: */
#define VB_SIZE  (VB_MAX + 2 * (6 + MAX_CLIP_PLANES))


/*
 * Vertex buffer (not saved/restored on context switches)
 */
struct vertex_buffer {
	GLfloat Eye[VB_SIZE][4];	/* Eye coords */
	GLfloat Clip[VB_SIZE][4];	/* Clip coords */
	GLfloat Win[VB_SIZE][3];	/* Window coords */
	/*NEW*/
	GLint WinX[VB_SIZE];	/* Scaled integer window coords */
	GLint WinY[VB_SIZE];
	GLint WinZ[VB_SIZE];

	GLfloat Fcolor[VB_SIZE][4];	/* Front colors */
	GLfloat Bcolor[VB_SIZE][4];	/* Back colors */
	GLfloat (*Color)[4];		/* == Fcolor or Bcolor */
	GLfloat	Findex[VB_SIZE];	/* Front indexes */
	GLfloat	Bindex[VB_SIZE];	/* Back indexes */
	GLfloat *Index;			/* == Findex or Bindex */
	GLboolean Edgeflag[VB_SIZE];	/* Edge flag */
	GLfloat Vs[VB_SIZE];		/* Texture S */
	GLfloat Vt[VB_SIZE];		/* Texture T */
	GLuint Count;			/* Number of vertexes */
	GLuint Free;			/* Next empty position for clipping */
	GLuint Flushes;			/* Number of flushes */
};



extern struct vertex_buffer VB;


#endif

