 /*
  * Khoros: $Id: run_ovlay.c,v 1.1 1991/05/10 15:59:48 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: run_ovlay.c,v 1.1 1991/05/10 15:59:48 khoros Exp $";
#endif

 /*
  * $Log: run_ovlay.c,v $
 * Revision 1.1  1991/05/10  15:59:48  khoros
 * Initial revision
 *
  */ 



/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 *
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "xvforms.h"
#include "xprism3.h"


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>	    file name: run_ovlay.c
   >>>>               
   >>>>   description: drives the overlays subform
   >>>>              
   >>>>      routines:
   >>>>			xvo_strcpy
   >>>> 		run_xvoverlay
   >>>> 		run_ovfile
   >>>> 		run_text
   >>>> 		run_circle
   >>>> 		run_rectangle
   >>>> 		run_line
   >>>> 		run_polygon
   >>>>              
   >>>> modifications:
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */



/********************************************************
*
*  Routine Name:  xvo_strcpy
*
*       Purpose:  This is a convenience routine.  The overlay
*		  object driver routines use this routine to
*		  copy strings.  The problem is the string being
*		  return from the forms is null which causes xvf_strcpy
*		  to core dump.
*
*		  xvo_strcpy returns a copy of the string, unless null
*		  then it return NULL.  This will cause check_object()
*		  to complain about the incorrect field. 
*
*         Input:
*
*        Output:
*
*     Called By:  local overlay object drivers
*
*   Written By:  Mark Young
*
********************************************************/

char	*xvo_strcpy(string)

char	*string;
{
	if (string == NULL)
	   return(NULL);
	else
	   return(xvf_strcpy(string));
}



/********************************************************
*
*  Routine Name:  run_xvoverlay
*
*       Purpose:  drives the subform 'xvoverlay'
*		  Called after the user clicks on an action
*		  button on one of the "Overlay" subform's panes.
*
*         Input:  form - pointer to the form tree 
*		  xvoverlay_info  -information structure for subform 'xvoverlay'
*        Output:
*
*     Called By:  run_vdisplay()
*
*   Written By:  Danielle Argiro and Mark Young
*
********************************************************/

extern XObject *edit_obj;

run_xvoverlay(form, xvoverlay_info)

xvf_form *form;
Master_xvoverlay *xvoverlay_info;
{
	Widget	    widget = canvas;
	char	    *mesg;
	XObject	    *object;

	/*
         * get the form information structure indicating
         * selections & and input provided by the user
         */
	_xvf_get_xvoverlay(form, xvoverlay_info);

	if (xvoverlay_info->quit)
	    xvf_change_active(form, false);

	else if (gwin == NULL)
        {
            mesg = xvf_strcpy("Please use the 'Plot' subform to create a graphics workspace\n");
             xvf_error_wait(mesg, "run_overlays", NULL);
             free(mesg);
             return;
        }

	/*
	 * user clicked on subform action button 'delete'
	 */
	else if (xvoverlay_info->delete)
	{
	   if (edit_obj == NULL)
	   {
	      mesg = xvf_strcpy("No object selected for deletion!");
	      xvf_error_wait(mesg, "run_xvoverlay", NULL);
	      free(mesg); return;
	   }
	   obj_list = delete_object(widget, obj_list, edit_obj);
	   edit_obj = NULL;
	}
	else if (xvoverlay_info->copy)
	{
	   if (edit_obj == NULL)
	   {
	      mesg = xvf_strcpy("No object selected to copy!");
	      xvf_error_wait(mesg, "run_xvoverlay", NULL);
	      free(mesg); return;
	   }

	   if ((object = copy_object(widget, edit_obj)))
	   {
	      obj_list = insert_object(widget, obj_list, object);
	      edit_obj = object;
	   }
	}
	else if (xvoverlay_info->raise)
	{
	   if (edit_obj == NULL)
	   {
	      mesg = xvf_strcpy("No object selected to raise!");
	      xvf_error_wait(mesg, "run_xvoverlay", NULL);
	      free(mesg); return;
	   }

	   obj_list = raise_object(widget, obj_list, edit_obj);
	}
	else if (xvoverlay_info->lower)
	{
	   if (edit_obj == NULL)
	   {
	      mesg = xvf_strcpy("No object selected to lower!");
	      xvf_error_wait(mesg, "run_xvoverlay", NULL);
	      free(mesg); return;
	   }

	   obj_list = lower_object(widget, obj_list, edit_obj);
	}

	/*
	 * action came from the 'file' pane
	 */
	else if (xvoverlay_info->ovfile_selected)
	    run_ovfile(form, xvoverlay_info->ovfile, widget);

	/*
	 * action came from the 'text' pane
	 */
	else if (xvoverlay_info->text_selected)
	    run_text(form, xvoverlay_info->text, widget);

	/*
	 * action came from the 'circle' pane
	 */
	else if (xvoverlay_info->circle_selected)
	    run_circle(form, xvoverlay_info->circle, widget);

	/*
	 * action came from the 'rectangle' pane
	 */
	else if (xvoverlay_info->rectangle_selected)
	    run_rectangle(form, xvoverlay_info->rectangle, widget);

	/*
	 * action came from the 'line' pane
	 */
	else if (xvoverlay_info->line_selected)
	    run_line(form, xvoverlay_info->line, widget);

	/*
	 * action came from the 'polygon' pane
	 */
	else if (xvoverlay_info->polygon_selected)
	    run_polygon(form, xvoverlay_info->polygon, widget);

}   /* end run_xvoverlay */



/********************************************************
*
*  Routine Name:  run_ovfile
*
*       Purpose:  drives the pane 'file'
*                 Called after the user clicks on "GET OVERLAY" or
*		  "SAVE OVERLAY", gets or saves the specified overlays
*		  from the filename given.
*
*         Input:  form - pointer to the form tree 
*		  file_info  - information structure for pane 'file'
*        Output:  
*
*     Called By:  run_xvoverlay()
*
*   Written By:  Danielle Argiro and Mark Young
*
********************************************************/


run_ovfile(form, file_info, widget)

xvf_form *form;
xvoverlay_ovfile *file_info;
Widget	 widget;
{
	char		*filename, temp[512];
	XObject		*tmp_list;

	/*
         * get the form information structure indicating
         * selections & and input provided by the user
         */
	_xvf_get_ovfile(form, file_info);

	/*
	 * user clicked on pane action button 'get_input'
	 */
	if (file_info->ov_input_selected)
	{
	   filename = vfullpath(file_info->ov_input, global_indir, NULL);
	   if (tmp_list = read_overlays(widget, filename))
	      obj_list = tmp_list;
	   sprintf(temp, "Overlays read from file '%s'", filename);
	   xvf_error_wait(temp, "run_overlays", NULL);
	   free(filename);

	}
	else if (file_info->ov_output_selected)
	{
	   filename = vfullpath(file_info->ov_output, global_outdir, NULL);
	   write_overlays(filename, obj_list);
	   sprintf(temp, "Overlays written to file '%s'", filename);
	   xvf_error_wait(temp, "run_overlays", NULL);
	   free(filename);
	}
	else
	   return;
}



/********************************************************
*
*  Routine Name:  run_text
*
*       Purpose:  drives the pane 'text'
*                 Called after the user clicks on "CREATE TEXT" or
*                 "CHANGE TEXT", creates a circle overlay.
*
*         Input:  form - pointer to the form tree 
*		  text_info  - information structure for pane 'text'
*        Output:  action of the application program
*
*     Called By:  run_xvoverlay()
*
*   Written By:  Danielle Argiro and Mark Young 
*
********************************************************/


run_text(form, text_info, widget)

xvf_form *form;
xvoverlay_text *text_info;
Widget	 widget;
{
	XObject *object;

	/*
         * get the form information structure indicating
         * selections & and input provided by the user
         */
	_xvf_get_text(form, text_info);

	/*
	 * user clicked on pane action button 'create'
	 */
	if (text_info->create)
	{
	   if ((object = create_object(TEXT)) == NULL)
              return;
	}
	else
	   return;

	object->color = xvo_strcpy(text_info->color);
	object->text = xvo_strcpy(text_info->text);
	object->font = xvo_strcpy(text_info->font);
	object->points[0].x = text_info->x;
	object->points[0].y = text_info->y;
	place_object(widget, object, text_info->place_val);
}



/********************************************************
*
*  Routine Name:  run_circle
*
*       Purpose:  drives the pane 'circle'
*                 Called after the user clicks on "CREATE CIRCLE" or
*                 "CHANGE CIRCLE" creates a circle overlay.
*
*         Input:  form - pointer to the form tree 
*		  circle_info  - information structure for pane 'circle'
*        Output:  action of the application program
*
*     Called By:  run_xvoverlay()
*
*   Written By:  Danielle Argiro and Mark Young 
*
********************************************************/


run_circle(form, circle_info, widget)

xvf_form *form;
xvoverlay_circle *circle_info;
Widget	 widget;
{
	XObject *object;

	/*
         * get the form information structure indicating
         * selections & and input provided by the user
         */
	_xvf_get_circle(form, circle_info);

	/*
	 * user clicked on pane action button 'create'
	 */
	if (circle_info->create)
	{
	   if ((object = create_object(CIRCLE)) == NULL)
              return;
	}
	else
	   return;

	object->color    = xvo_strcpy(circle_info->color);
	object->isfilled = circle_info->filled;
	object->line_width  = circle_info->width;
	object->points[0].x = circle_info->x;
	object->points[0].y = circle_info->y;
	object->points[1].x = circle_info->x_edge;
	object->points[1].y = circle_info->y_edge;
	place_object(widget, object, circle_info->place_val);
}



/********************************************************
*
*  Routine Name:  run_rectangle
*
*       Purpose:  drives the pane 'rectangle'
*                 Called after the user clicks on "CREATE RECTANGLE" or
*                 "CHANGE RECTANGLE" creates a rectangle overlay.
*
*         Input:  form - pointer to the form tree 
*		  rectangle_info  - information structure for pane 'rectangle'
*        Output:  action of the application program
*
*     Called By:  run_xvoverlay()
*
*   Written By:  Danielle Argiro and Mark Young 
*
********************************************************/


run_rectangle(form, rectangle_info, widget)

xvf_form *form;
xvoverlay_rectangle *rectangle_info;
Widget	 widget;
{
	XObject *object;

	/*
         * get the form information structure indicating
         * selections & and input provided by the user
         */
	_xvf_get_rectangle(form, rectangle_info);

	/*
	 * user clicked on pane action button 'create'
	 */
	if (rectangle_info->create)
	{
	   if ((object = create_object(RECTANGLE)) == NULL)
              return;
	}
	else
	   return;

	object->color    = xvo_strcpy(rectangle_info->color);
	object->isfilled = rectangle_info->filled;
	object->line_width  = rectangle_info->width;
	object->points[0].x = rectangle_info->x;
	object->points[0].y = rectangle_info->y;
	object->points[1].x = rectangle_info->x_corner;
	object->points[1].y = rectangle_info->y_corner;
	place_object(widget, object, rectangle_info->place_val);
}



/********************************************************
*
*  Routine Name:  run_line
*
*       Purpose:  drives the pane 'line'
*                 Called after the user clicks on "CREATE LINE" or
*                 "CHANGE LINE" creates a line overlay.
*
*         Input:  form - pointer to the form tree 
*		  line_info  - information structure for pane 'line'
*        Output:  action of the application program
*
*     Called By:  run_xvoverlay()
*
*   Written By:  Danielle Argiro and Mark Young 
*
********************************************************/


run_line(form, line_info, widget)

xvf_form *form;
xvoverlay_line *line_info;
Widget	 widget;
{
	XObject *object;

	/*
         * get the form information structure indicating
         * selections & and input provided by the user
         */
	_xvf_get_line(form, line_info);

	/*
	 * user clicked on pane action button 'create'
	 */
	if (line_info->create)
	{
	   if ((object = create_object(LINE)) == NULL)
              return;
	}
	else
	   return;

	object->color = xvo_strcpy(line_info->color);
	object->line_width  = line_info->width;
	object->points[0].x = line_info->x;
	object->points[0].y = line_info->y;
	object->points[1].x = line_info->x_end;
	object->points[1].y = line_info->y_end;
	place_object(widget, object, line_info->place_val);
}



/********************************************************
*
*  Routine Name:  run_polygon
*
*       Purpose:  drives the pane 'polygon'
*                 Called after the user clicks on "CREATE POLYGON" or
*                 "CHANGE POLYGON" creates a polygon overlay.
*
*         Input:  form - pointer to the form tree 
*		  polygon_info  - information structure for pane 'polygon'
*        Output:  action of the application program
*
*     Called By:  run_xvoverlay()
*
*   Written By:  Danielle Argiro and Mark Young 
*
********************************************************/


run_polygon(form, polygon_info, widget)

xvf_form *form;
xvoverlay_polygon *polygon_info;
Widget	 widget;
{
	XObject *object;

	/*
         * get the form information structure indicating
         * selections & and input provided by the user
         */
	_xvf_get_polygon(form, polygon_info);

	/*
	 * user clicked on pane action button 'create'
	 */
	if (polygon_info->create)
	{
	   if ((object = create_object(POLYGON)) == NULL)
              return;
	}
	else
	   return;

	object->color = xvo_strcpy(polygon_info->color);
	object->line_width = polygon_info->width;
	object->isfilled   = polygon_info->filled;
	place_object(widget, object, MOUSE);
}


