 /*
  * Khoros: $Id: lconductor.c,v 1.2 1991/12/18 09:07:32 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lconductor.c,v 1.2 1991/12/18 09:07:32 dkhoros Exp $";
#endif

 /*
  * $Log: lconductor.c,v $
 * Revision 1.2  1991/12/18  09:07:32  dkhoros
 * HellPatch3
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lconductor.c
 >>>>
 >>>>      Program Name: conductor
 >>>>
 >>>> Date Last Updated: Tue Apr  2 15:11:12 1991 
 >>>>
 >>>>          Routines: lconductor - the library call for conductor
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "xvinclude.h"


/* -library_includes */
#include "conductor.h"
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lconductor - library call for conductor
*
* Purpose:
*
* Input:
*    
*    filename -    name of the database file filename
*    levels -      1, 2, or 3: the level of extraction
*    gen_drivers - flag indicating whether or not to generate the
*    
*    
* Output:
*    
*    generated in the user's local '.' directory
*    
*    
*
* Written By: Danielle Argiro
*    
*    
****************************************************************/


/* -library_def */

int
lconductor(filename, levels, gen_drivers)
char *filename;
int  levels;
int  gen_drivers;

/* -library_def_end */

/* -library_code */
{
        FILE   *file;
        char   *fullpath;
        char **database; 
        int    line_num;
        int    db_size;

        xvf_display = NULL;

        /*
         *  make sure the .form file exists and can be opened
         */
        fullpath = vfullpath(filename, NULL, NULL);
        if (!(file = fopen(fullpath, "r")))
        {
           printf("conductor: Error: unable to open '%s' to read database", 
                   filename);
           return(false);
        }

        /*
         *  read the database out of the .form file 
         */
        database = xvf_read_database(file, &line_num, &db_size);
        if (database == NULL)
        {
           fclose(file);
           return(false);
        }

        /*
         *  print out user information comments
         */
        printf("\n\nconductor:\n");
        printf("\nReady to generate form_info.h, \n");
        printf("form_init.c, ");
        
        if (gen_drivers == true)
           printf("form_info.c, and form_drv.c\n\n\n");
        else 
           printf("and form_info.c\n\n\n");

        /*
         *  generate the form information structure in file "form_info.h"
         */
        if (!(cnd_gen_form_struct(database)))
            return(false); 

        /*
         *  generate the form initialization code in file "form_init.c"
         */
        if (!(cnd_gen_init_forminfo(database)))
            return(false);  
        
        /*
         *  generate the form extraction code in file "form_info.c"
         */
        if (!(cnd_gen_get_forminfo(database, levels, line_num)))
            return(false);  

        /*
         *  if requested, generate the driver in file "form_drv.c"
         */
        if (gen_drivers == 1)
            cnd_gen_driver(database, levels, fullpath);

        fclose(file);
        return(true);
        
}
/* -library_code_end */
