 /*
  * Khoros: $Id: vhisto.c,v 1.1 1991/05/10 15:49:29 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vhisto.c,v 1.1 1991/05/10 15:49:29 khoros Exp $";
#endif

 /*
  * $Log: vhisto.c,v $
 * Revision 1.1  1991/05/10  15:49:29  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vhisto.c
 >>>>
 >>>>      Program Name: vhisto
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Finds the histogram of the gray-levels  of  a  real,  single
 >>>>	band, non-bit image.
 >>>>	
 >>>>	
 >>>>            Author: Ramiro Jordan, Marcelo Teran
 >>>>
 >>>> Date Last Updated: Tue Mar  5 22:33:03 1991
 >>>>
 >>>>          Routines: main- the main program for vhisto
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vhisto.h"


/****************************************************************
 *
 * Routine Name:  main program for vhisto
 *
 *       Input:  
 *        -i  input image 
 *        -o  output ASCII file 
 *
 *
 *        [-m] mask image
 *        [-l] lower bound 
 *        [-u] upper bound 
 *        [-n] number of bins  (value > 0)
 *        [-t] If True Take Log of Data Before Histogramming
 *        [-p] If True Output Histogram in Percent
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
    struct xvimage *image, *mimage, *readimage();
    float *hist;
    int  i;
    float z;
    FILE *fp;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
    if (check_args()) exit(1);

    image = readimage(vhisto->i_file);
    if (image == NULL) exit(1);    /* Quit if bad image */
    if (vhisto->m_flag)
      {
        mimage = readimage(vhisto->m_file);
        if (mimage == NULL) exit(1);
      }

    CHECKINPUT(program,image);  /* Verify input image */

    if (vhisto->m_flag)
      {
        MATCHINPUT(program,image,mimage); /* Verify match */
      }

    hist = (float *)malloc(vhisto->n_int*sizeof(float));
    if (hist == NULL)
      {
        (void) fprintf(stderr,"vhisto: Unable to allocate histogram array\n");
        exit(1);
      }
/* -main_before_lib_call_end */

/* -main_library_call */
    if(! lvhisto(image,hist,vhisto->l_float,vhisto->u_float,vhisto->n_int,
                 vhisto->m_flag,mimage,vhisto->t_logic,vhisto->p_logic))
    {
        (void) fprintf(stderr, "lvhisto Failed\n");
        exit(1);
    }
/* -main_library_call_end */

/* -main_after_lib_call */
    fp = fopen(vhisto->o_file,"w");
    if(fp == NULL)
    {
        (void) fprintf(stderr,"Open file failed\n");
        exit(1);
    }

    z = (vhisto->u_float-vhisto->l_float)/vhisto->n_int;
    for (i=0; i<vhisto->n_int; i++)
    {
        (void) fprintf(fp,"%g\t%g\n",i*z+vhisto->l_float,hist[i]);
    }

    fclose(fp);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vhisto 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vhisto :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tFinds the histogram of the gray-levels  of  a  real,  single\n");
	fprintf(stderr, "\tband, non-bit image.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input image  (infile)\n");
	fprintf(stderr,"\t-o  output ASCII file  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-m]  mask image (infile) [null]\n");
	fprintf(stderr,"\t[-l]  lower bound (float) [0]\n");
	fprintf(stderr,"\t[-u]  upper bound (float) [256]\n");
	fprintf(stderr,"\t[-n]  number of bins (integer, > 0) [256]\n");
	fprintf(stderr,"\t[-t]  If True Take Log of Data Before Histogramming (boolean) [false]\n");
	fprintf(stderr,"\t[-p]  If True Output Histogram in Percent (boolean) [false]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vhisto\n");
	fprintf(stderr, "\t[-U] Gives the usage for vhisto\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vhisto.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vhisto.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vhisto
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input image \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) output ASCII file \n        {outfile}: "; 
char	*m_pstr = 
	"\nEnter: (m) mask image \n        {infile}: "; 
char	*l_pstr = 
	"\nEnter: (l) lower bound \n        {float [0.000000] }: "; 
char	*u_pstr = 
	"\nEnter: (u) upper bound \n        {float [256.000000] }: "; 
char	*n_pstr = 
	"\nEnter: (n) number of bins \n        {integer, > 0 [256] }: "; 
char	*t_pstr = 
	"\nEnter: (t) If True Take Log of Data Before Histogramming \n        {boolean, (y/n)  [no] }: "; 
char	*p_pstr = 
	"\nEnter: (p) If True Output Histogram in Percent \n        {boolean, (y/n)  [no] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vhisto", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vhisto.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vhisto: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vhisto.ans");
		}

	     }

	}

	/*
	 * allocate the vhisto structure
	 */
	vhisto = (vhisto_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vhisto_struct));

	/*
	 * get required arguments for vhisto
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vhisto->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(vhisto->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vhisto->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    vhisto->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(vhisto->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vhisto->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vhisto->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vhisto->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vhisto->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vhisto->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vhisto
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vhisto->m_flag = vget_infile(fid, prompt_flag,
	"-m", m_pstr, &(vhisto->m_file))
;

	vhisto->l_flag = vget_float(fid, prompt_flag,
	"-l", l_pstr, &(vhisto->l_float),
	0.000000, 0.000000, 0.000000);

	vhisto->u_flag = vget_float(fid, prompt_flag,
	"-u", u_pstr, &(vhisto->u_float),
	256.000000, 0.000000, 0.000000);

	vhisto->n_flag = vget_int(fid, prompt_flag,
	"-n", n_pstr, &(vhisto->n_int),
	256, 2, 2);

	vhisto->t_flag = vget_logic(fid, prompt_flag,
	"-t", t_pstr, &(vhisto->t_logic), 0);

	vhisto->p_flag = vget_logic(fid, prompt_flag,
	"-p", p_pstr, &(vhisto->p_logic), 0);


}



