 /*
  * Khoros: $Id: lvdrf.c,v 1.1 1991/05/10 15:41:54 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvdrf.c,v 1.1 1991/05/10 15:41:54 khoros Exp $";
#endif

 /*
  * $Log: lvdrf.c,v $
 * Revision 1.1  1991/05/10  15:41:54  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvdrf.c
 >>>>
 >>>>      Program Name: vdrf
 >>>>
 >>>> Date Last Updated: Tue Mar  5 22:29:04 1991 
 >>>>
 >>>>          Routines: lvdrf - the library call for vdrf
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvdrf - library call for vdrf
*
* Purpose:
*    
*    Optimal filter for Edge Detection.
*    
*    
* Input:
*    
*    image          xvimage structure, must be of  data  storage  type
*                   Byte, single band without map.
*    
*    a1             First coefficient of the exponential filter.
*    
*    a1             Second coefficient of the exponential filter.
*    
*    window         size of the window  for  the  adaptative  gradient
*                   algorithm.
*    
*    t1             defines the first Hysteresis Threshold.
*    
*    t2             defines the second Hysteresis Threshold.
*    
*    Len            defines the minimum number of pixels for a segment
*                   to be valided.
*    
*    
* Output:
*    
*    image          Holds the result.
*    
*    
*
* Written By: Pascal ADAM
*    
*    Created by Pascal ADAM from source given by Pr  CASTAN  IRIT
*    TOULOUSE on Mon Jul  2 16:50:07 MDT 1990.
*    
*    
****************************************************************/


/* -library_def */
int 
lvdrf(image,a1,a2,t1,t2,l,w)

struct xvimage *image;
int t1, t2, l,w ;
float a1,a2;
/* -library_def_end */

/* -library_code */
{
int mx,my,dim;
unsigned char *ima;
unsigned char *im1,*im2,*im3,*imi,*imo;
int i;
void expfilter(),gradadp(),threshold();

   ima = (unsigned char *) image -> imagedata;
   dim = (int)image -> col_size * (int)image -> row_size;
   mx  = (int)image -> row_size;
   my  = (int)image -> col_size; 
 
   a1=1-a1; a2=1-a2;

   /* Dynamic alloc for *t1, *t2 and *t3.                  */
   im1=(unsigned char*)malloc(dim*sizeof(unsigned char));
   im2=(unsigned char*)malloc(dim*sizeof(unsigned char));
   im3=(unsigned char*)malloc(dim*sizeof(unsigned char));

   if ((im1 == NULL) || (im2 == NULL) || (im3 == NULL)) 
   {
      (void) fprintf(stderr,"lvdrf: insufficient memory available\n");
      return(0);
    }


   imo=(unsigned char *)ima;
   imi=im1;

   for (i=0; i<dim; i++) *imi++= *imo++;


   /* filtering the image by the exponential filter.*/
   expfilter(a1,mx,my,dim,im1,im2);
   expfilter(a2,mx,my,dim,im2,im3);

   /* calculate the difference between input and output of filter,  */
   /* and then the BLI                                             */
   imo=im3;

   for (imi=im2; imi<im2+dim; imi++)
   {
      if ((int) *imo - (int) *imi >=0) *imo++ = 1;
      else *imo++ = 0;
   }

   /* search the zero-crossings of Laplacian, and calculate gradient */
   /* on these points by the adaptative gradient method.             */
   gradadp(mx,my,dim,w,im1,im3,im2);

   /* image segmentation by the hysteretic threshold.      */
   threshold(im2,im3,mx,my,dim,t1,t2,l);

   free(image -> imagedata);
   image -> imagedata = (char *)im3;

   free(im1);
   free(im2);

   return(1);
      }
/* -library_code_end */
