 /*
  * Khoros: $Id: lvconj.c,v 1.1 1991/05/10 15:41:54 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvconj.c,v 1.1 1991/05/10 15:41:54 khoros Exp $";
#endif

 /*
  * $Log: lvconj.c,v $
 * Revision 1.1  1991/05/10  15:41:54  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvconj.c
 >>>>
 >>>>      Program Name: vconj
 >>>>
 >>>> Date Last Updated: Sat Mar 23 23:30:33 1991 
 >>>>
 >>>>          Routines: lvconj - the library call for vconj
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvconj - library call for vconj
*
* Purpose:
*
* Input:
*    
*         f1 -- xvimage strcuture
*    
*    
* Output:
*    
*         f1 -- holds the result of the multiply operation. The output
*         data type is the same as the input data type.
*         f1 is used for both the input xvimage structure and the out-
*         put  result  xvimage structure.  This is done to save space,
*         but you must be careful not to overwrite important data.
*    
*    
*
* Written By: Shirley Lee
*    
*    Feb 27-91 JW/SL Added support for double complex images.
*    
*    
****************************************************************/


/* -library_def */
int
lvconj(f1)
struct xvimage *f1;
/* -library_def_end */

/* -library_code */
{
    int i,j,rows,bands,cols;
    float *p1;
    double *d1;
    char *malloc();

    if (f1->data_storage_type != VFF_TYP_COMPLEX && 
        f1->data_storage_type != VFF_TYP_DCOMPLEX) 
    {
      return(1);
    }

    rows = f1->col_size;
    cols = f1->row_size;
    bands = f1->num_data_bands;

    /* Take the conjugate of input image */
    if(f1->data_storage_type == VFF_TYP_COMPLEX)
    {
       p1 = (float *)(f1->imagedata);
       for (i=0; i<cols*rows*bands; i++)
          {
            *(p1+1) *= -1.0;
            p1 += 2;
          }
    }
    else
    {
       d1 = (double *)(f1->imagedata);
       for (i=0; i<cols*rows*bands; i++)
          {
            *(d1+1) *= -1.0;
            d1 += 2;
          }
    }


    return(1);
}
/* -library_code_end */
