 /*
  * Khoros: $Id: big2viff.c,v 1.1 1991/05/10 15:52:36 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: big2viff.c,v 1.1 1991/05/10 15:52:36 khoros Exp $";
#endif

 /*
  * $Log: big2viff.c,v $
 * Revision 1.1  1991/05/10  15:52:36  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: big2viff.c
 >>>>
 >>>>      Program Name: big2viff
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Converts a BIG file format to the VIFF image file format.
 >>>>	
 >>>>	
 >>>>            Author: Tom Sauer
 >>>>
 >>>> Date Last Updated: Sat Mar  2 14:17:13 1991
 >>>>
 >>>>          Routines: main- the main program for big2viff
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "big2viff.h"


/****************************************************************
 *
 * Routine Name:  main program for big2viff
 *
 *       Input:  
 *          -i  input BIG data file 
 *          -o  resulting output image (viff file) 
 *          -c  lets user chose color space model
 *		0 (no model),
 *		1 (choose ntscRGB model),
 *		15 (choose genericRGB model),
 *		7 (choose cieRGB model),
 *		2 (choose ntscCMY model),
 *		3 (choose ntscYIQ model),
 *		4 (choose HSV model),
 *		5 (choose HLS model),
 *		6 (choose IHS model),
 *		8 (choose cieXYZ model),
 *		9 (choose cieUVW model),
 *		10 (choose cieucsUVW model),
 *		11 (choose cieucsSOW model),
 *		12 (choose cieucsLab model),
 *		or 14 (choose GENERIC model)
 *		 
 *
 *
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage *viff_image;
struct big *read_big(), *big_image;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
    if (check_args()) exit(1);

    READINPUT (big_image);
/* -main_before_lib_call_end */

/* -main_library_call */
    if (!lbig2viff (big_image, &viff_image, big2viff -> c_toggle)) {
        (void) fprintf (stderr, "lbig2viff Failed\n");
        exit (1);
    }
/* -main_library_call_end */

/* -main_after_lib_call */
    writeimage (big2viff -> o_file, viff_image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for big2viff 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "big2viff :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tConverts a BIG file format to the VIFF image file format.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input BIG data file  (infile)\n");
	fprintf(stderr,"\t-o  resulting output image (viff file)  (outfile)\n");
	fprintf(stderr, "\t-c  ");
	fprintf(stderr, "lets user chose color space model\n  ");
	fprintf(stderr, "\t\t0  (no model),\n");
	fprintf(stderr, "\t\t1  (choose ntscRGB model),\n");
	fprintf(stderr, "\t\t15  (choose genericRGB model),\n");
	fprintf(stderr, "\t\t7  (choose cieRGB model),\n");
	fprintf(stderr, "\t\t2  (choose ntscCMY model),\n");
	fprintf(stderr, "\t\t3  (choose ntscYIQ model),\n");
	fprintf(stderr, "\t\t4  (choose HSV model),\n");
	fprintf(stderr, "\t\t5  (choose HLS model),\n");
	fprintf(stderr, "\t\t6  (choose IHS model),\n");
	fprintf(stderr, "\t\t8  (choose cieXYZ model),\n");
	fprintf(stderr, "\t\t9  (choose cieUVW model),\n");
	fprintf(stderr, "\t\t10  (choose cieucsUVW model),\n");
	fprintf(stderr, "\t\t11  (choose cieucsSOW model),\n");
	fprintf(stderr, "\t\t12  (choose cieucsLab model),\n");
	fprintf(stderr, "\t\tor 14  (choose GENERIC model)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for big2viff\n");
	fprintf(stderr, "\t[-U] Gives the usage for big2viff\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called big2viff.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses big2viff.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for big2viff
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input BIG data file \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) resulting output image (viff file) \n        {outfile}: "; 
char	*c_pstr = "\nEnter: (c) lets user chose color space model -- \n      \t\t0 (no model)\n\t\t1 (choose ntscRGB model)\n\t\t15 (choose genericRGB model)\n\t\t7 (choose cieRGB model)\n\t\t2 (choose ntscCMY model)\n\t\t3 (choose ntscYIQ model)\n\t\t4 (choose HSV model)\n\t\t5 (choose HLS model)\n\t\t6 (choose IHS model)\n\t\t8 (choose cieXYZ model)\n\t\t9 (choose cieUVW model)\n\t\t10 (choose cieucsUVW model)\n\t\t11 (choose cieucsSOW model)\n\t\t12 (choose cieucsLab model)\n\t\tor 14 (choose GENERIC model)\n     : "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "big2viff", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "big2viff.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "big2viff: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "big2viff.ans");
		}

	     }

	}

	/*
	 * allocate the big2viff structure
	 */
	big2viff = (big2viff_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (big2viff_struct));

	/*
	 * get required arguments for big2viff
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(big2viff->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(big2viff->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(big2viff->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    big2viff->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(big2viff->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(big2viff->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(big2viff->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(big2viff->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    big2viff->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(big2viff->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}


	/*
	 * get required toggles for big2viff
	 */
	if (prompt_flag == TRUE)
	{
	    ok = FALSE;
	    while(!ok)
	    {
		big2viff->c_flag = vget_int(fid, prompt_flag,
		"-c", c_pstr, &(big2viff->c_toggle),
		15, 0, 0);

		if (((big2viff->c_toggle == 0 ) || 
		     (big2viff->c_toggle == 1 ) || 
		     (big2viff->c_toggle == 15 ) || 
		     (big2viff->c_toggle == 7 ) || 
		     (big2viff->c_toggle == 2 ) || 
		     (big2viff->c_toggle == 3 ) || 
		     (big2viff->c_toggle == 4 ) || 
		     (big2viff->c_toggle == 5 ) || 
		     (big2viff->c_toggle == 6 ) || 
		     (big2viff->c_toggle == 8 ) || 
		     (big2viff->c_toggle == 9 ) || 
		     (big2viff->c_toggle == 10 ) || 
		     (big2viff->c_toggle == 11 ) || 
		     (big2viff->c_toggle == 12 ) || 
		     (big2viff->c_toggle == 14 )) &&
		     (big2viff->c_flag))
		      ok = TRUE;
		else
		{
		    fprintf(stderr, "\nc is a required argument.\n");
		}
	    }
	}
	else
	{
		big2viff->c_flag = vget_int(fid, prompt_flag,
		"-c", c_pstr, &(big2viff->c_toggle),
		15, 0, 0);

		if (((big2viff->c_toggle != 0 ) && 
		     (big2viff->c_toggle != 1 ) && 
		     (big2viff->c_toggle != 15 ) && 
		     (big2viff->c_toggle != 7 ) && 
		     (big2viff->c_toggle != 2 ) && 
		     (big2viff->c_toggle != 3 ) && 
		     (big2viff->c_toggle != 4 ) && 
		     (big2viff->c_toggle != 5 ) && 
		     (big2viff->c_toggle != 6 ) && 
		     (big2viff->c_toggle != 8 ) && 
		     (big2viff->c_toggle != 9 ) && 
		     (big2viff->c_toggle != 10 ) && 
		     (big2viff->c_toggle != 11 ) && 
		     (big2viff->c_toggle != 12 ) && 
		     (big2viff->c_toggle != 14 )) ||
		     (!(big2viff->c_flag)))
		{
		    fprintf(stderr, "c is a required argument.\n");
		    fprintf(stderr, "\n");
		    gw_usage();
		    exit(0);
		}
	}


}



