 /*
  * Khoros: $Id: dmirror.c,v 1.2 1992/03/20 23:32:29 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: dmirror.c,v 1.2 1992/03/20 23:32:29 dkhoros Exp $";
#endif

 /*
  * $Log: dmirror.c,v $
 * Revision 1.2  1992/03/20  23:32:29  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: dmirror.c
 >>>>
 >>>>      Program Name: dmirror
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	1D Create Mirror of Data. Points added to the  left  of  the
 >>>>	first data point.
 >>>>	
 >>>>	

 >>>>            Author: Donna Koechner, Ramiro Jordan
 >>>>
 >>>> Date Last Updated: Wed Feb 19 09:40:21 1992
 >>>>
 >>>>          Routines: main- the main program for dmirror
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "dmirror.h"


/****************************************************************
 *
 * Routine Name:  main program for dmirror
 *
 *       Input:  
 *         -i  input data file (xviff file) 
 *         -o  resulting output file (xviff file) 
 *
 *
 *         [-p] complex data: create conjugate[t] or exact[f] mirror
 *         [-d] data processing direction (0 = down vectors, 1 = across bands)
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage  *image, *readimage();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
if (check_args())
{
  fprintf(stderr, "%s: Illegal arguments on command line.\n", program);
  exit(1);
}

READIMAGE(image) ;
CHECKTYPE(program, image) ;
CHECKINPUT(program, image) ;

if (dmirror->p_logic && (image->data_storage_type != VFF_TYP_COMPLEX))
{
  dmirror->p_logic = 0;
}

/* -main_before_lib_call_end */

/* -main_library_call */
if(! ldmirror ( image, dmirror->p_logic, dmirror->d_logic ) )
{
  (void) fprintf(stderr, "ldmirror Failed\n");
  exit(1);
}
/* -main_library_call_end */

/* -main_after_lib_call */
writeimage(dmirror->o_file,image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for dmirror 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "dmirror :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t1D Create Mirror of Data. Points added to the  left  of  the\n");
	fprintf(stderr, "\tfirst data point.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input data file (xviff file)  (infile)\n");
	fprintf(stderr,"\t-o  resulting output file (xviff file)  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-p]  complex data: create conjugate[t] or exact[f] mirror (boolean) [true]\n");
	fprintf(stderr,"\t[-d]  data processing direction (0 = down vectors, 1 = across bands) (boolean) [true]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for dmirror\n");
	fprintf(stderr, "\t[-U] Gives the usage for dmirror\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called dmirror.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses dmirror.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for dmirror
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input data file (xviff file) \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) resulting output file (xviff file) \n        {outfile}: "; 
char	*p_pstr = 
	"\nEnter: (p) complex data: create conjugate[t] or exact[f] mirror \n        {boolean, (y/n)  [yes] }: "; 
char	*d_pstr = 
	"\nEnter: (d) data processing direction (0 = down vectors, 1 = across bands) \n        {boolean, (y/n)  [yes] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "dmirror", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "dmirror.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "dmirror: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "dmirror.ans");
		}

	     }

	}

	/*
	 * allocate the dmirror structure
	 */
	dmirror = (dmirror_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (dmirror_struct));

	/*
	 * get required arguments for dmirror
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(dmirror->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(dmirror->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(dmirror->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    dmirror->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(dmirror->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(dmirror->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(dmirror->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(dmirror->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    dmirror->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(dmirror->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for dmirror
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	dmirror->p_flag = vget_logic(fid, prompt_flag,
	"-p", p_pstr, &(dmirror->p_logic), 1);

	dmirror->d_flag = vget_logic(fid, prompt_flag,
	"-d", d_pstr, &(dmirror->d_logic), 1);


}



