 /*
  * Khoros: $Id: dgwindow.h,v 1.3 1992/03/20 23:17:53 dkhoros Exp $
  */

 /*
  * $Log: dgwindow.h,v $
 * Revision 1.3  1992/03/20  23:17:53  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: dgwindow.h
 >>>>            Author: Jeremy Worley
 >>>> Date Last Updated: Thu Mar  5 12:02:10 1992
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _dgwindow_h_
#define _dgwindow_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program;	/* a pointer to the program name argv[0] */
int	ac;

/****************************************************************
*
*                    dgwindow Argument Structure
*
****************************************************************/

typedef struct _dgwindow  {

/*
 *  resulting output file (xviff file) (Required outfile)
 */
char	*o_file;	/* resulting output file (xviff file) FILENAME */
int	 o_flag;	/* resulting output file (xviff file) FLAG */

/*
 *  trigger input (Optional infile)
 */
char	*trigger_file;	/* trigger input FILENAME */
int	 trigger_flag;	/* trigger input FLAG */

/*
 *  number of signals to generate (Optional integer)
 */
int	 s_int; 	/* number of signals to generate INT */
int	 s_flag;	/* number of signals to generate FLAG */

/*
 *  number of elements per signal (Optional integer)
 */
int	 p_int; 	/* number of elements per signal INT */
int	 p_flag;	/* number of elements per signal FLAG */

/*
 *  desired THETA parameter for Kaiser window (Optional float)
 */
float	 k_float;	/* desired THETA parameter for Kaiser window FLOAT */
int	 k_flag;   	/* desired THETA parameter for Kaiser window FLAG */

/*
 *  desired damping parameter for Exponential window (Optional float)
 */
float	 e_float;	/* desired damping parameter for Exponential window FLOAT */
int	 e_flag;   	/* desired damping parameter for Exponential window FLAG */

/*
 *  desired window width for User defined window (Optional integer)
 */
int	 b_int; 	/* desired window width for User defined window INT */
int	 b_flag;	/* desired window width for User defined window FLAG */

/*
 *  data processing direction (0 = down vectors, 1 = across bands) (Optional logical)
 */
int	 d_logic;	/* data processing direction (0 = down vectors, 1 = across bands) LOGIC */
int	 d_flag;  	/* data processing direction (0 = down vectors, 1 = across bands) FLAG */

/*
 * windowed output file to be created (Optional integer toggle - )
 */
int	 w_toggle;		/* windowed output file to be created INT TOGGLE */
int	 w_flag;		/* windowed output file to be created FLAG */

/*
 * lets user choose data type of image (Optional string toggle - )
 */
char	*t_toggle;		/* lets user choose data type of image STRING TOGGLE */
int	 t_flag;		/* lets user choose data type of image FLAG */

}  dgwindow_struct;

dgwindow_struct *dgwindow;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
/* -include_macros_end */

#endif
