 /*
  * Khoros: $Id: dgexpon.c,v 1.3 1992/03/20 23:18:13 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: dgexpon.c,v 1.3 1992/03/20 23:18:13 dkhoros Exp $";
#endif

 /*
  * $Log: dgexpon.c,v $
 * Revision 1.3  1992/03/20  23:18:13  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: dgexpon.c
 >>>>
 >>>>      Program Name: dgexpon
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Creates a exponential distributed noise data set.
 >>>>	
 >>>>	

 >>>>            Author: Jeremy Worley
 >>>>
 >>>> Date Last Updated: Sat Feb 15 16:29:09 1992
 >>>>
 >>>>          Routines: main- the main program for dgexpon
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "dgexpon.h"


/****************************************************************
 *
 * Routine Name:  main program for dgexpon
 *
 *       Input:  
 *         -o  resulting image 
 *
 *
 *         [-i] input value file (xviff file)
 *         [-trigger] trigger input
 *         [-s] number of vectors  (value > 0)
 *         [-n] number of points  (value > 0)
 *         [-v] variance  (value >= 0.0)
 *         [-d] data processing direction (0 = down vectors, 1 = across bands)
 *         [-t] lets user choose data type of image
 *		'float' (select data type),
 *		 or 'complex' (choose data type)
 *		   [default = float] 
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */

struct xvimage *image=NULL, *kernel=NULL, *readimage();
int type;

/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
  if(check_args())exit(1);
  if(!vget_type(&type,dgexpon->t_toggle)){
     fprintf(stderr,"dgexpon:  Invalid data type specified\n");
     exit(1);
  }

/*
** load kernel if necessary
*/

  if (dgexpon->i_flag) {
    image = readimage(dgexpon->i_file);
    if(image == NULL)
    {
      (void)fprintf(stderr,"dgexpon:  Value file could not be read!\n");
      exit(1);
    }
  }

/* -main_before_lib_call_end */

/* -main_library_call */

  if(!ldgexpon(&image,dgexpon->s_int,dgexpon->n_int,
             dgexpon->v_float,type, dgexpon->d_logic)){
    (void)fprintf(stderr, "ldgexpon Failed\n");
    exit(1);
  }


/* -main_library_call_end */

/* -main_after_lib_call */
writeimage(dgexpon->o_file,image);

/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for dgexpon 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "dgexpon :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tCreates a exponential distributed noise data set.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
fprintf(stderr,"\nThe -t option will accept input in either of two forms:\n");
fprintf(stderr,"  an alphabetic representation, i.e. 'float' or 'complex',\n");
fprintf(stderr,"  or a numeric representation, such as 4 for real.\n");
/* -usage_additions_end */

	fprintf(stderr,"\t-o  resulting image  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-i]  input value file (xviff file) (infile) [null]\n");
	fprintf(stderr,"\t[-trigger]  trigger input (infile) [null]\n");
	fprintf(stderr,"\t[-s]  number of vectors (integer, > 0) [1]\n");
	fprintf(stderr,"\t[-n]  number of points (integer, > 0) [256]\n");
	fprintf(stderr,"\t[-v]  variance (float, >= 0.0) [1]\n");
	fprintf(stderr,"\t[-d]  data processing direction (0 = down vectors, 1 = across bands) (boolean) [true]\n");
	fprintf(stderr, "\t[-t]  lets user choose data type of image\n");
	fprintf(stderr, "\t\t'float'  (select data type),\n");
	fprintf(stderr, "\t\t or 'complex'  (choose data type)\n");
	fprintf(stderr, "\t\t[default = float]\n");
	fprintf(stderr, "\n");	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for dgexpon\n");
	fprintf(stderr, "\t[-U] Gives the usage for dgexpon\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called dgexpon.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses dgexpon.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for dgexpon
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*o_pstr = 
	"\nEnter: (o) resulting image \n        {outfile}: "; 
char	*i_pstr = 
	"\nEnter: (i) input value file (xviff file) \n        {infile}: "; 
char	*trigger_pstr = 
	"\nEnter: (trigger) trigger input \n        {infile}: "; 
char	*s_pstr = 
	"\nEnter: (s) number of vectors \n        {integer, > 0 [1] }: "; 
char	*n_pstr = 
	"\nEnter: (n) number of points \n        {integer, > 0 [256] }: "; 
char	*v_pstr = 
	"\nEnter: (v) variance \n        {float, >= 0.0 [1.000000] }: "; 
char	*d_pstr = 
	"\nEnter: (d) data processing direction (0 = down vectors, 1 = across bands) \n        {boolean, (y/n)  [yes] }: "; 
char	*t_pstr = "\nEnter: (t) lets user choose data type of image -- \n      \t\t'float' (select data type)\n\t\tor 'complex' (choose data type)\n  [float]:  "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "dgexpon", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "dgexpon.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "dgexpon: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "dgexpon.ans");
		}

	     }

	}

	/*
	 * allocate the dgexpon structure
	 */
	dgexpon = (dgexpon_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (dgexpon_struct));

	/*
	 * get required arguments for dgexpon
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(dgexpon->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(dgexpon->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(dgexpon->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    dgexpon->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(dgexpon->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for dgexpon
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	dgexpon->i_flag = vget_infile(fid, prompt_flag,
	"-i", i_pstr, &(dgexpon->i_file))
;

	dgexpon->trigger_flag = vget_infile(fid, prompt_flag,
	"-trigger", trigger_pstr, &(dgexpon->trigger_file))
;

	dgexpon->s_flag = vget_int(fid, prompt_flag,
	"-s", s_pstr, &(dgexpon->s_int),
	1, 2, 2);

	dgexpon->n_flag = vget_int(fid, prompt_flag,
	"-n", n_pstr, &(dgexpon->n_int),
	256, 2, 2);

	dgexpon->v_flag = vget_float(fid, prompt_flag,
	"-v", v_pstr, &(dgexpon->v_float),
	1.000000, 1.000000, 1.000000);

	dgexpon->d_flag = vget_logic(fid, prompt_flag,
	"-d", d_pstr, &(dgexpon->d_logic), 1);


	/*
	 * get optional toggles for dgexpon
	 */
	if (prompt_flag == TRUE)
	{
	    ok = FALSE;
	    while(!ok)
	    {
		dgexpon->t_flag = vget_string(fid, prompt_flag,
		"-t", t_pstr, &(dgexpon->t_toggle),
		"float");

		if (((strcmp(dgexpon->t_toggle, "float") == 0)) || 
		     ((strcmp(dgexpon->t_toggle, "complex") == 0)))
		      ok = TRUE;
		else
		{
		}
	    }
	}
	else
	{
		dgexpon->t_flag = vget_string(fid, prompt_flag,
		"-t", t_pstr, &(dgexpon->t_toggle),
		"float");

		if (((strcmp(dgexpon->t_toggle, "float") != 0)) && 
		     ((strcmp(dgexpon->t_toggle, "complex") != 0)))
		{
		    fprintf(stderr, "\n");
		    gw_usage();
		    exit(0);
		}
	}


}



