 /*
  * Khoros: $Id: proper_enc.c,v 1.1 1991/05/10 15:40:47 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: proper_enc.c,v 1.1 1991/05/10 15:40:47 khoros Exp $";
#endif

 /*
  * $Log: proper_enc.c,v $
 * Revision 1.1  1991/05/10  15:40:47  khoros
 * Initial revision
 *
  */ 

/*
#
# FILE NAME:	proper_enc.c
# 
# AUTHORS:	Tom Sauer, John Rasure
#               Modified from code done origianlly by Marcelo Teran
# 
# DATE:		2/6/89
# 
# DESCRIPTION:	Contains module proper_encode_scheme().
# 
# MODIFICATIONS:
#		John Rasure modified error messages.
#		Sat Jun  2 23:37:39 MDT 1990
# 
# ROUTINES:	proper_encode_scheme()
#		
*/

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.

 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */

#include "vinclude.h"	  


/**************************************************************
*
* MODULE NAME: 	proper_encode_scheme()
*
*     PURPOSE:	Check to see if a viff data has the correct
*               encoding scheme.
*
*       INPUT:  prog 	- program name
*		*image	- viff data
*		type	- desired encoding scheme
*		exit_flag
*
*      OUTPUT:  If exit_flag is true and match fails, an error 
*          	message is printed.
*      		If exit_flag is false and match fails, return(0).
*
*       USAGE:	If exit_flag is set, The routine will print out an
*		error message and then exit().  In this case, the
*		function should be declared (void).  If exit_flag
*               is not set (equal 0) then the function should be
*		declared int.
*
*
**************************************************************/
proper_encode_scheme(prog,image,type,exit_flag)
char  *prog;
struct xvimage *image;
unsigned long type;
int exit_flag;
{
   if(image->data_encode_scheme != type) {
      if (exit_flag == TRUE) {
         (void) fprintf(stderr, "\nError in program %s: \n",prog);
         (void) fprintf(stderr, 
"The encoding or compression shceme used on the viff data file is incorrect.\n");
         switch(type){
            case VFF_DES_RAW :
               (void) fprintf(stderr, "Data encoding scheme should be VFF_DES_RAW\n");
               exit(1);
               break;
            case VFF_DES_COMPRESS :
               (void) fprintf(stderr, "Data encoding scheme should be VFF_DES_COMPRESS\n");
               exit(1);
               break;
            case VFF_DES_RLE :
               (void) fprintf(stderr, "Data encoding scheme should be VFF_DES_RLE\n");
               exit(1);
               break;
            case VFF_DES_ADPCM :
               (void) fprintf(stderr, "Data encoding scheme should be VFF_DES_ADPCM\n");
               exit(1);
               break;
            case VFF_DES_CCITT :
               (void) fprintf(stderr, "Data encoding scheme should be VFF_DES_CCITT\n");
               exit(1);
               break;
            case VFF_DES_TRANSFORM :
               (void) fprintf(stderr, "Data encoding scheme should be VFF_DES_TRANSFORM\n");
               exit(1);
               break;
            case VFF_DES_GENERIC :
               (void) fprintf(stderr, "Data encoding scheme should be VFF_DES_GENERIC\n");
               exit(1);
               break;
            default :
               (void) fprintf(stderr, "Data encoding scheme is unknown.\n");
               exit(1);
               break;
	 }
      }
      else return(0);
   }
return(1);
}
