 /*
  * Khoros: $Id: matchsize.c,v 1.1 1991/05/10 15:40:47 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: matchsize.c,v 1.1 1991/05/10 15:40:47 khoros Exp $";
#endif

 /*
  * $Log: matchsize.c,v $
 * Revision 1.1  1991/05/10  15:40:47  khoros
 * Initial revision
 *
  */ 

/*
#
# FILE NAME:	matchsize.c
# 
# AUTHORS:	Tom Sauer, Marcelo Teran, John Rasure
# 
# DATE:		2/6/89
# 
# DESCRIPTION:	Contains module matchsize().
# 
# MODIFICATIONS:
#		John Rasure modified error messages.
#		Sun Jun  3 00:40:25 MDT 1990
# 
# ROUTINES:	matchsize()
#		
*/

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.

 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */

#include "vinclude.h"	  


/**************************************************************
*
* MODULE NAME: 	matchsize()
*
*     PURPOSE:	Check to see if two viff data structures are the same size. 
*
*       INPUT:  prog 	- program name
*		*img1	- viff data structure one
*		*img2	- viff data structure two
*		exit_flag
*
*      OUTPUT:  If exit_flag is true and match fails, an error 
*          	message is printed.
*      		If exit_flag is false and match fails, return(0).
*
*       USAGE:	If exit_flag is set, The routine will print out an
*		error message and then exit().  In this case, the
*		function should be declared (void).  If exit_flag
*               is not set (equal 0) then the function should be
*		declared int.
*
*
**************************************************************/

matchsize(prog,img1,img2,exit_flag)
char *prog;
struct xvimage *img1,*img2;
int exit_flag;
{
    if( ! (img1->col_size==img2->col_size && img1->row_size==img2->row_size) ){
	if (exit_flag == TRUE) {
		(void) fprintf(stderr,"\nError in program %s.\n",prog);
		(void) fprintf(stderr,
"The viff data structures are of different sizes.\n");
		(void) fprintf(stderr,
"The number of rows and columns is different between the two viff files.\n");
		(void) fprintf(stderr,
"The viff files can be resized with other programs.\n");
		exit(1);
	}
	else return(0);
    }
return(1);
}
