/* which.c: check to see if a file is executable.

   This function is isolated from the rest because of #include trouble with
   ANSI compilers.

   This function was originally written with Maarten Litmaath's which.c as
   a template, but was changed in order to accomodate the possibility of
   rc's running setuid or the possibility of executing files not in the
   primary group. Much of this function has been re-vamped by Paul Haahr.
*/

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/param.h>

#define M_USR 0700
#define M_GRP 0070
#define M_OTH 0007
#define X_ALL 0111

#ifndef NULL
#define NULL 0
#endif

typedef struct List {
	char *w;
	char *m;
	struct List *n;
} List;

#ifndef hpux
extern int stat(char *, struct stat *);
#endif
extern int geteuid(void);
extern int getegid(void);
extern int getgroups(int, int *);
extern char *strcpy(char *, char *);
extern char *strcat(char *, char *);
extern int strlen(char *);

extern List *varlookup(char *);
extern void *ealloc(int);
extern void efree(void *);

static int initialized = 0;
static int uid, gid, ngroups, gidset[NGROUPS];

static int ingidset(int gid) {
	int i;
	for (i = 0; i < ngroups; i++)
		if (gid == gidset[i])
			return 1;
	return 0;
}

static int rc_access(char *path) {
	struct stat st;
	int mask;

	if (stat(path, &st) != 0)
		return -1;

	mask = X_ALL;

	if (uid != 0) {
		if (uid == st.st_uid)
			mask &= M_USR;
		else if (gid = st.st_gid || ingidset(st.st_gid))
			mask &= M_GRP;
		else
			mask &= M_OTH;
	}
	if ((st.st_mode & S_IFMT) != S_IFREG || (st.st_mode & mask) != mask)
		return -1;
	else
		return 0;
}

char *which(char *name) {
	List *path;
	static char *test = NULL;
	static int testlen = 0;
	int len;

	if (name == NULL)	/* no filename? can happen with "> foo" as a command */
		return NULL;

	if (!initialized) {
		initialized = 1;
		uid = geteuid();
		gid = getegid();
		ngroups = getgroups(NGROUPS, gidset);
	}

	if (name[0] == '/'	/* absolute path name */
        || (name[0] == '.'
	    && (name[1] == '/'
            || (name[1] == '.' && name[2] == '/'))))
		if (rc_access(name) == 0)
			return name;
		else
			return NULL;

	len = strlen(name);
	for (path = varlookup("path");path != NULL; path = path->n) {
		int need = strlen(path->w) + len + 2;
		if (testlen < need) {
			efree(test);
			test = ealloc(need);
			testlen = need;
		}
		if (*path->w == '\0') {
			strcpy(test, name);
		} else {
			strcpy(test, path->w);
			strcat(test, "/");
			strcat(test, name);
		}

		if (rc_access(test) == 0)
			return test;
	}
	return NULL;
}
