/* redir.c: code for opening files and piping heredocs after fork but before exec. */

#include "rc.h"
#include "lex.h"
#include "glom.h"
#include "glob.h"
#include "open.h"
#include "exec.h"
#include "utils.h"

void doredirs() {
	List *fname;
	int fd, pid, p[2];
	Rq *r = redirq;

	while(r) {
		switch(r->r->type) {
		default:
			fprint(2,"%d: bad node in doredirs\n", r->r->type);
			exit(1);
		case rREDIR:
			if (r->r->u[0].i == HERESTRING) {
				fname = flatten(glom(r->r->u[2].p)); /* fname is really a string */
				if (fname == NULL) {
					close(r->r->u[1].i); /* feature? */
					break;
				}
				if (pipe(p) < 0) {
					fprint(2, "couldn't pipe");
					exit(1);
				}
				if ((pid = fork()) < 0) {
					fprint(2, "couldn't fork");
					exit(1);
				}
				if (pid == 0) { /* child writes to pipe */
					close(p[0]);
					writeall(p[1], fname->w, strlen(fname->w));
					exit(0);
				}
				close(p[1]);
				if (dup2(p[0], r->r->u[1].i) < 0) {
					uerror("dup");
					exit(1);
				}
				close(p[0]);
			} else {
				fname = glob(glom(r->r->u[2].p));
				if (fname == NULL) {
					fprint(2,"null filename in redirection?\n");
					exit(1);
				}
				if (fname->n != NULL) {
					fprint(2,"multi-word filename in redirection\n");
					exit(1);
				}
				switch (r->r->u[0].i) {
				case CREATE: case APPEND: case FROM:
					fd = rc_open(fname->w, r->r->u[0].i);
					break;
				default:
					fprint(2,"doredirs: this can't happen\n");
					exit(1);
					return; /* Keeps gcc -Wall happy */
				}
				if (fd < 0) {
					uerror(fname->w);
					exit(1);
				}
				if (dup2(fd, r->r->u[1].i) < 0) {
					uerror("dup");
					exit(1);
				}
				close(fd);
			}
			break;
		case rDUP:
			if (r->r->u[2].i == -1)
				close(r->r->u[1].i);
			else if (dup2(r->r->u[2].i, r->r->u[1].i) < 0) {
				uerror("dup");
				exit(1);
			}
		}
		r = r->n;
	}
}
