/* nalloc.c: a simple single-arena allocator for command-line-lifetime allocation */

#include "rc.h"
#include "utils.h"
#include "nalloc.h"

typedef struct Block Block;

static struct Block {
	int used;
	int size;
	char *mem;
	Block *n;
} *fl, *ul;

#define alignto(m, n)   (m + n - 1) & ~(n - 1)
#define BLOCKSIZE 4096		/* must be power of 2 to work with alignto */

static void getblock(int n) {
	Block *r, *p;

	for (r = fl, p = NULL; r != NULL; p = r, r = r->n)
		if (n <= r->size)
			break;

	if (r != NULL) {
		if (p != NULL)
			p->n = r->n;
		else
			fl = r->n;
	} else {
		r = enew(Block);
		r->mem = ealloc(alignto(n, BLOCKSIZE));
		r->size = alignto(n, BLOCKSIZE);
	}

	r->used = 0;
	r->n = ul;
	ul = r;
}

void *nalloc(int n) {
	char *ret;

        n = alignto(n, sizeof (ALIGN_T));

	if (ul == NULL || n + ul->used >= ul->size)
		getblock(n);

	ret = ul->mem + ul->used;
	ul->used += n;
	return ret;
}

void nfree() {
	Block *r;

	if (ul == NULL)
		return;

	for (r = ul; r->n != NULL; r = r->n)
		;

	r->n = fl;
	fl = ul;
	ul = NULL;
}
