/* main.c: handles initialization of rc and command line options */

#include "rc.h"
#include "utils.h"
#include "input.h"
#include "nalloc.h"
#include "hash.h"
#include "lex.h"
#include "open.h"
#include "jmp.h"
#include "tree.h"
#include "glom.h"

boolean dashee, dashvee, dashex;
boolean interactive, toplevinteractive, atthetop;
enum posns posn = TOPLEV;
int shell_pid;
char *PS2 = "", *dollarzero;
Node *star;

void main(int argc, char *argv[], char *envp[]) {
	char *r, *dashsee[2], pid[8];
	boolean dashell, dashdee, push;
	List *path;
	int fd;
	jmp_buf mainbuf;

	dashee = dashell = dashvee = dashex = dashdee = FALSE;
	dashsee[0] = NULL;
	dollarzero = *argv;

	if (**argv == '-')
		dashell = TRUE;

	for (argv++; *argv != NULL && **argv == '-'; argv++)
		for (r = *argv + 1; *r; r++)
			switch (*r) {
			case 'l':
				dashell = TRUE;
				break;
			case 'e':
				dashee = TRUE;
				break;
			case 'i':
				interactive = TRUE;
				break;
			case 'v':
				dashvee = TRUE;
				break;
			case 'x':
				dashex = TRUE;
				break;
			case 'd':
				dashdee = TRUE;
				break;
			case 'c':
				dashsee[0] = *++argv;
				dashsee[1] = NULL;
				if (*dashsee == NULL) {
					fprint(2,"null command on -c\n");
					exit(1);
				}
				argv++;
				interactive = FALSE;
				goto quitopts;
			default:
				fprint(2,"bad option: '%c'\n", *r);
				exit(1);
			}

	if (!interactive)
		interactive = isatty(0);

	if (*argv != NULL)
		interactive = FALSE;

	toplevinteractive = interactive;
	setsigvectors(interactive, dashdee);

quitopts: /* initialize environment and variables etc. */

	star = treecpy(newnode(VAR,newnode(rWORD,"*",NULL)));
	inithash();
	varassign("prompt",word("; ",NULL), FALSE);
	path = append(word(".",NULL),append(word("/bin",NULL),append(word("/usr/bin",NULL),word("/usr/ucb",NULL))));
	varassign("path",path, FALSE);
	alias("path",path, FALSE);
	varassign("ifs",append(word(" ",NULL),append(word("\t",NULL),word("\n",NULL))), FALSE);
	shell_pid = getpid();
	sprint(pid,"%d", shell_pid);
	varassign("pid",word(pid,NULL), FALSE);
	initenv(envp);
	initinput();
	varrm("*", FALSE); /* A precautionary measure; don't want to set $* from the environment */

	if (dashell) {
		jb = (jmp_buf *) mainbuf;
		atthetop = 0;
		push = interactive;
		interactive = FALSE;
		fd = rc_open(concat(varlookup("home"),word("/.rcrc",NULL))->w, FROM);
		if (setjmp(mainbuf) == 0) { /* return here on errors in .rcrc */
			if (fd >= 0) {
				pushinput(FD, &fd);
				doit();
			}
		}
		interactive = push;
	}

	atthetop = 1;

	if (dashsee[0] != NULL) {	/* input from the -c flag? */
		if (*argv != NULL)
			arrayassign("*", argv, FALSE);
		pushinput(STRING, dashsee);
	} else if (*argv != NULL) {	/* else from a file? */
		if (**argv == '\0') {
			fprint(2,"null filename\n");
			rc_exit(1);
		}
		dollarzero = *argv++;
		fd = rc_open(dollarzero, FROM);
		if (fd < 0) {
			uerror(dollarzero);
			rc_exit(1);
		}
		arrayassign("*", argv, FALSE);
		pushinput(FD, &fd);
	} else {			/* else stdin */
		fd = 0;
		pushinput(FD, &fd);
	}

	doit();
	rc_exit(0);
}
