/* list.c: routines for manipulating the List type */

#include "rc.h"
#include "utils.h"

/*
   These list routines assign meta values of null to the resulting lists;
   it is impossible to glob with the value of a variable unless this value
   is rescanned with eval---therefore it is safe to throw away the meta-ness
   of the list.
*/

void listfree(List *p) {
	if (p == NULL)
		return;
	listfree(p->n);
	efree(p->w);
	efree(p);
}

List *listcpy(List *s) {
	List *r;

	if (s == NULL)
		return NULL;

	r = ealloc(sizeof(List));
	r->w = ecpy(s->w);
	r->m = NULL;
	r->n = listcpy(s->n);

	return r;
}

int listlen(List *s) {
	int size;

	for (size = 0; s != NULL; s = s->n)
		size += strlen(s->w) + 2;

	return size;
}

int listnel(List *s) {
	int nel;

	for (nel = 0; s != NULL; s = s->n)
		nel++;

	return nel;
}
