;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                                                                         ;;;
;;;  define-record and variant-case macros for SCM4a14                      ;;;
;;;                                                                         ;;;
;;;  Hacked from Brent Benson's macros for MIT Scheme, hacked from          ;;;
;;;  Jeff Alexander's and ShinnDer Li's macro's for PC Scheme               ;;;
;;;                                                                         ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define gensym
  (let ((n 0))
    (lambda ()
      (set! n (add1 n))
      (string->symbol (string-append ".g." (number->string n) ".")))))

(define add1 1+)

(define error/define-record-or-variant-case
  (lambda args
    (for-each (lambda (x) (display x) (display " ")) args)
    (newline)
    (error "Error from define-record or variant-case.")))

(define every?     ; In MacScheme, this definition can be deleted.
  (lambda (pred ls)
    (if (null? ls)
        #t
        (and (pred (car ls)) (every? pred (cdr ls))))))

(define all-true? every?) 
(define null-ended-list? list?)

(define-macro (define-record record-name record-fields)
    (if (and (symbol? record-name)
             (null-ended-list? record-fields)
             (all-true? symbol? record-fields))
        (let* ((vec-sym (gensym))
               (name (symbol->string record-name))
               (name? (string->symbol (string-append name "?"))))
          (letrec
            ((loop
               (lambda (fields i)
                 (cond ((null? fields) '())
                       ((member (car fields) (cdr fields))
                        (error/define-record-or-variant-case
                          "define-record syntax error:"
                          (string-append name ",")
                          "duplicate field:"
                          (car fields))) 
                       (#t
                         (let* ((accessor
                                 (string-append
				  name
				  "->"
				  (symbol->string (car fields))))
				(settor 
				 (string-append accessor "!")))
                           (cons
			    `(define ,(string->symbol accessor)
			       (lambda (obj)
				 (if (,name? obj)
				     (vector-ref obj ,i)
				     (error/define-record-or-variant-case
				      ,accessor ": bad record" obj))))
			    (cons
			     `(define ,(string->symbol settor)
				(lambda (obj val)
				  (if (,name? obj)
				      (vector-set! obj ,i val)
				      (error/define-record-or-variant-case
				       ,settor ": bad record" obj))))
			     (loop (cdr fields) (add1 i))))))))))
            `(begin
               ,@(loop record-fields 1)
               (define ,name?
                 (lambda (obj)
                   (and (vector? obj)
                        (= (vector-length obj) ,(+ 1 (length record-fields)))
                        (eq? (vector-ref obj 0) ',record-name))))
               (define ,(string->symbol
                          (string-append (symbol->string 'make-) name))
                 (let ((,vec-sym vector))
                   (lambda ,record-fields
                     (,vec-sym ',record-name ,@record-fields)))))))
        (error/define-record-or-variant-case
          "define-record syntax error:" record-name)))

(define-macro (variant-case record-var . clauses)
    (let ((var (gensym)))
      (letrec
        ((loop
          (lambda (clause)
            (cond
             ((null? clause)
              `((#t (error/define-record-or-variant-case
                      "no clause matches:" ,var))))
             ((eq? (caar clause) 'else)
              (if (not (null? (cdr clause)))
                  (error/define-record-or-variant-case
                    "variant-case syntax error: clauses after an else."
                    (cdr clause))
                  `((#t ,@(cdar clause)))))
             ((assoc (caar clause) (cdr clause))
              (error/define-record-or-variant-case
                "variant-case syntax error: duplicate clause:"
                (caar clause)))
             (else
              (let ((name (symbol->string (caar clause))))
                (cons
                 `((,(string->symbol (string-append name "?")) ,var)
                   (let ,(let-vars name (cadar clause))
                     ,@(cddar clause)))
                 (loop (cdr clause))))))))
         (let-vars
           (lambda (name fields)
             (cond
              ((null? fields) '())
              ((member (car fields) (cdr fields))
               (error/define-record-or-variant-case
                 "variant-case syntax error: duplicate field. record:"
                 (string-append name "," " field:") (car fields)))
              (#t
               (cons
                `(,(car fields)
                  (,(string->symbol
                     (string-append
                      name "->" (symbol->string (car fields))))
                   ,var))
                (let-vars name (cdr fields))))))))
        (if (and (all-true?
                  (lambda (clause)
                    (and (null-ended-list? clause)
                         (not (null? clause))
                         (symbol? (car clause))
                         (if (eq? (car clause) 'else)
                             (not (null? (cdr clause)))
                             (and (> (length clause) 2)
                                  (null-ended-list? (cadr clause))
                                  (all-true? symbol? (cadr clause))))))
                  clauses))
            `(let ((,var ,record-var))
                  (cond ,@(loop clauses)))
            (error/define-record-or-variant-case
              "variant-case syntax error:" record-var)))))
