functor TopdecLex(structure Tokens: Topdec_TOKENS
			   structure LexBasics: LEX_BASICS
			   structure LexUtils: LEX_UTILS
			     sharing type LexUtils.svalue = Tokens.svalue
				 and type LexUtils.token = Tokens.token
				 and type LexUtils.pos = LexBasics.pos
				 and type LexUtils.SourceReader
					  = LexBasics.SourceReader
			  )
	=
   struct
    structure UserDeclarations =
      struct
(* Lexical specification for Standard ML.		NICK, August 1990. *)

(*
$File: Parsing/Topdec.lex $
$Date: 1992/12/18 08:59:41 $
$Revision: 1.1 $
$Locker:  $
*)

  open Tokens
  type pos = LexBasics.pos
  type arg = LexUtils.LexArgument
  type lexresult = (svalue, LexBasics.pos) token
  fun eof _ = Tokens.EOF(LexBasics.DUMMY, LexBasics.DUMMY)
  val lParen = "(" and rParen = ")"

(* Something which returns a (pos * pos) for a token. This is what ML-Yacc
   works with, and we use it in the productions below. *)

  fun ofLength(arg, yypos, yytext) =
    let
      val yypos = yypos - 2
	(* If somebody can tell be why the yypos seems to be permanently
	   two characters ahead of where it should be, I'd be interested... *)

      val LexBasics.SOURCE_READER{positionFn, ...} =
	LexUtils.sourceReaderOf arg

      val lPos = positionFn yypos
      val rPos = positionFn(yypos + size yytext)
    in
      (lPos, rPos)
    end

  fun token0(tokFn, arg, yypos, yytext) =
        tokFn(ofLength(arg, yypos, yytext))

  and token1(tokFn, value, arg, yypos, yytext) =
	let
	  val (l, r) = ofLength(arg, yypos, yytext)
	in
	  tokFn(value, l, r)
	end

  fun positionOfStream(arg, yypos) =
    let
      val LexBasics.SOURCE_READER{positionFn, ...} =
	LexUtils.sourceReaderOf arg
    in
      positionFn yypos
    end

  fun error(arg, yypos, msg) =
    raise LexBasics.LEXICAL_ERROR(positionOfStream(arg, yypos), msg)

 (* addAsciiChar can fail, so we need to generate position info for it. *)
  fun addAsciiChar(arg, yypos, yytext) =
    LexUtils.addAsciiChar (positionOfStream(arg, yypos), yytext) arg
end (* end of user routines *)
exception LexError (* raised if illegal leaf action tried *)
structure Internal =
	struct

datatype yyfinstate = N of int
type statedata = {fin : yyfinstate list, trans: string}
(* transition & final state table *)
val tab = let
val s0 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s1 =
"\007\007\007\007\007\007\007\007\007\045\046\007\045\007\007\007\
\\007\007\007\007\007\007\007\007\007\007\007\007\007\007\007\007\
\\045\025\044\025\025\025\025\042\040\039\025\025\038\025\035\025\
\\033\033\033\033\033\033\033\033\033\033\025\032\025\025\025\025\
\\025\027\027\027\027\027\027\027\027\027\027\027\027\027\027\027\
\\027\027\027\027\027\027\027\027\027\027\027\031\025\030\025\029\
\\025\027\027\027\027\027\027\027\027\027\027\027\027\027\027\027\
\\027\027\027\027\027\027\027\027\027\027\027\026\025\024\008\007\
\\007"
val s3 =
"\047\047\047\047\047\047\047\047\047\047\062\047\047\047\047\047\
\\047\047\047\047\047\047\047\047\047\047\047\047\047\047\047\047\
\\047\047\061\047\047\047\047\047\047\047\047\047\047\047\047\047\
\\047\047\047\047\047\047\047\047\047\047\047\047\047\047\047\047\
\\047\047\047\047\047\047\047\047\047\047\047\047\047\047\047\047\
\\047\047\047\047\047\047\047\047\047\047\047\047\049\047\047\047\
\\047\047\047\047\047\047\047\047\047\047\047\047\047\047\047\047\
\\047\047\047\047\047\047\047\047\047\047\047\047\047\047\047\047\
\\047"
val s5 =
"\063\063\063\063\063\063\063\063\063\063\068\063\063\063\063\063\
\\063\063\063\063\063\063\063\063\063\063\063\063\063\063\063\063\
\\063\063\063\063\063\063\063\063\066\063\064\063\063\063\063\063\
\\063\063\063\063\063\063\063\063\063\063\063\063\063\063\063\063\
\\063\063\063\063\063\063\063\063\063\063\063\063\063\063\063\063\
\\063\063\063\063\063\063\063\063\063\063\063\063\063\063\063\063\
\\063\063\063\063\063\063\063\063\063\063\063\063\063\063\063\063\
\\063\063\063\063\063\063\063\063\063\063\063\063\063\063\063\063\
\\063"
val s8 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\009\000\009\009\009\009\000\000\000\009\009\000\009\010\009\
\\013\013\013\013\013\013\013\013\013\013\009\000\009\009\009\009\
\\009\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\009\000\009\000\
\\009\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\009\000\009\000\
\\000"
val s9 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\009\000\009\009\009\009\000\000\000\009\009\000\009\010\009\
\\000\000\000\000\000\000\000\000\000\000\009\000\009\009\009\009\
\\009\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\009\000\009\000\
\\009\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\009\000\009\000\
\\000"
val s10 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\011\000\011\011\011\011\000\000\000\011\011\000\011\000\011\
\\000\000\000\000\000\000\000\000\000\000\011\000\011\011\011\011\
\\011\012\012\012\012\012\012\012\012\012\012\012\012\012\012\012\
\\012\012\012\012\012\012\012\012\012\012\012\000\011\000\011\000\
\\011\012\012\012\012\012\012\012\012\012\012\012\012\012\012\012\
\\012\012\012\012\012\012\012\012\012\012\012\000\011\000\011\000\
\\000"
val s11 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\011\000\011\011\011\011\000\000\000\011\011\000\011\010\011\
\\000\000\000\000\000\000\000\000\000\000\011\000\011\011\011\011\
\\011\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\011\000\011\000\
\\011\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\011\000\011\000\
\\000"
val s12 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\012\000\000\000\000\000\000\010\000\
\\012\012\012\012\012\012\012\012\012\012\000\000\000\000\000\000\
\\000\012\012\012\012\012\012\012\012\012\012\012\012\012\012\012\
\\012\012\012\012\012\012\012\012\012\012\012\000\000\000\000\012\
\\000\012\012\012\012\012\012\012\012\012\012\012\012\012\012\012\
\\012\012\012\012\012\012\012\012\012\012\012\000\000\000\000\000\
\\000"
val s13 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\018\000\
\\013\013\013\013\013\013\013\013\013\013\000\000\000\000\000\000\
\\000\000\000\000\000\014\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s14 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\017\017\017\017\017\017\017\017\017\017\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\015\000\
\\000"
val s15 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\016\016\016\016\016\016\016\016\016\016\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s17 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\017\017\017\017\017\017\017\017\017\017\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s18 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\019\019\019\019\019\019\019\019\019\019\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s19 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\019\019\019\019\019\019\019\019\019\019\000\000\000\000\000\000\
\\000\000\000\000\000\020\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s20 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\023\023\023\023\023\023\023\023\023\023\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\021\000\
\\000"
val s21 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\022\022\022\022\022\022\022\022\022\022\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s23 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\023\023\023\023\023\023\023\023\023\023\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s27 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\028\000\000\000\000\000\000\010\000\
\\028\028\028\028\028\028\028\028\028\028\000\000\000\000\000\000\
\\000\028\028\028\028\028\028\028\028\028\028\028\028\028\028\028\
\\028\028\028\028\028\028\028\028\028\028\028\000\000\000\000\028\
\\000\028\028\028\028\028\028\028\028\028\028\028\028\028\028\028\
\\028\028\028\028\028\028\028\028\028\028\028\000\000\000\000\000\
\\000"
val s33 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\018\000\
\\034\034\034\034\034\034\034\034\034\034\000\000\000\000\000\000\
\\000\000\000\000\000\014\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s35 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\036\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s36 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\037\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s40 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\041\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s42 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\043\000\000\000\000\000\000\000\000\
\\043\043\043\043\043\043\043\043\043\043\000\000\000\000\000\000\
\\000\043\043\043\043\043\043\043\043\043\043\043\043\043\043\043\
\\043\043\043\043\043\043\043\043\043\043\043\000\000\000\000\043\
\\000\043\043\043\043\043\043\043\043\043\043\043\043\043\043\043\
\\043\043\043\043\043\043\043\043\043\043\043\000\000\000\000\000\
\\000"
val s45 =
"\000\000\000\000\000\000\000\000\000\046\046\000\046\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\046\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s47 =
"\048\048\048\048\048\048\048\048\048\048\000\048\048\048\048\048\
\\048\048\048\048\048\048\048\048\048\048\048\048\048\048\048\048\
\\048\048\000\048\048\048\048\048\048\048\048\048\048\048\048\048\
\\048\048\048\048\048\048\048\048\048\048\048\048\048\048\048\048\
\\048\048\048\048\048\048\048\048\048\048\048\048\048\048\048\048\
\\048\048\048\048\048\048\048\048\048\048\048\048\000\048\048\048\
\\048\048\048\048\048\048\048\048\048\048\048\048\048\048\048\048\
\\048\048\048\048\048\048\048\048\048\048\048\048\048\048\048\048\
\\048"
val s49 =
"\000\000\000\000\000\000\000\000\000\059\059\000\059\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\059\000\058\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\055\055\055\055\055\055\055\055\055\055\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\054\000\052\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\051\000\
\\000\000\000\000\050\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s52 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\053\053\053\053\053\053\053\053\053\053\053\053\053\053\053\053\
\\053\053\053\053\053\053\053\053\053\053\053\053\053\053\053\053\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s55 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\056\056\056\056\056\056\056\056\056\056\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s56 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\057\057\057\057\057\057\057\057\057\057\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s59 =
"\000\000\000\000\000\000\000\000\000\059\059\000\059\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\059\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\060\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s64 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\065\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s66 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\067\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
in Vector.fromList
[{fin = [], trans = s0},
{fin = [], trans = s1},
{fin = [], trans = s1},
{fin = [(N 109)], trans = s3},
{fin = [(N 109)], trans = s3},
{fin = [], trans = s5},
{fin = [], trans = s5},
{fin = [(N 153)], trans = s0},
{fin = [(N 12),(N 153)], trans = s8},
{fin = [(N 12)], trans = s9},
{fin = [], trans = s10},
{fin = [(N 39)], trans = s11},
{fin = [(N 39)], trans = s12},
{fin = [(N 96)], trans = s13},
{fin = [], trans = s14},
{fin = [], trans = s15},
{fin = [(N 87)], trans = s15},
{fin = [(N 87)], trans = s17},
{fin = [], trans = s18},
{fin = [(N 87)], trans = s19},
{fin = [], trans = s20},
{fin = [], trans = s21},
{fin = [(N 87)], trans = s21},
{fin = [(N 87)], trans = s23},
{fin = [(N 55),(N 153)], trans = s0},
{fin = [(N 12),(N 153)], trans = s9},
{fin = [(N 53),(N 153)], trans = s0},
{fin = [(N 9),(N 153)], trans = s27},
{fin = [(N 9)], trans = s27},
{fin = [(N 61),(N 153)], trans = s0},
{fin = [(N 51),(N 153)], trans = s0},
{fin = [(N 49),(N 153)], trans = s0},
{fin = [(N 59),(N 153)], trans = s0},
{fin = [(N 89),(N 92),(N 153)], trans = s33},
{fin = [(N 92)], trans = s33},
{fin = [(N 153)], trans = s35},
{fin = [], trans = s36},
{fin = [(N 43)], trans = s0},
{fin = [(N 57),(N 153)], trans = s0},
{fin = [(N 47),(N 153)], trans = s0},
{fin = [(N 45),(N 153)], trans = s40},
{fin = [(N 107)], trans = s0},
{fin = [(N 102),(N 153)], trans = s42},
{fin = [(N 102)], trans = s42},
{fin = [(N 104),(N 153)], trans = s0},
{fin = [(N 2),(N 153)], trans = s45},
{fin = [(N 2)], trans = s45},
{fin = [(N 109),(N 153)], trans = s47},
{fin = [(N 109)], trans = s47},
{fin = [(N 141),(N 153)], trans = s49},
{fin = [(N 121)], trans = s0},
{fin = [(N 124)], trans = s0},
{fin = [], trans = s52},
{fin = [(N 134)], trans = s0},
{fin = [(N 130)], trans = s0},
{fin = [], trans = s55},
{fin = [], trans = s56},
{fin = [(N 139)], trans = s0},
{fin = [(N 127)], trans = s0},
{fin = [], trans = s59},
{fin = [(N 118)], trans = s0},
{fin = [(N 111),(N 153)], trans = s0},
{fin = [(N 113)], trans = s0},
{fin = [(N 149),(N 153)], trans = s0},
{fin = [(N 149),(N 153)], trans = s64},
{fin = [(N 147)], trans = s0},
{fin = [(N 149),(N 153)], trans = s66},
{fin = [(N 144)], trans = s0},
{fin = [(N 151)], trans = s0}]
end
structure StartStates =
	struct
	datatype yystartstate = STARTSTATE of int

(* start state definitions *)

val C = STARTSTATE 5;
val INITIAL = STARTSTATE 1;
val S = STARTSTATE 3;

end
type result = UserDeclarations.lexresult
	exception LexerError (* raised if illegal leaf action tried *)
end

fun makeLexer yyinput = 
let 
	val yyb = ref "\n" 		(* buffer *)
	val yybl = ref 1		(*buffer length *)
	val yybufpos = ref 1		(* location of next character to use *)
	val yygone = ref 1		(* position in file of beginning of buffer *)
	val yydone = ref false		(* eof found yet? *)
	val yybegin = ref 1		(*Current 'start state' for lexer *)

	val YYBEGIN = fn (Internal.StartStates.STARTSTATE x) =>
		 yybegin := x

fun lex (yyarg as (arg: UserDeclarations.arg)) =
let fun continue() : Internal.result = 
  let fun scan (s,AcceptingLeaves : Internal.yyfinstate list list,l,i0) =
	let fun action (i,nil) = raise LexError
	| action (i,nil::l) = action (i-1,l)
	| action (i,(node::acts)::l) =
		case node of
		    Internal.N yyk => 
			(let val yytext = String.extract i0 i (!yyb)
			     val yypos = i0+ !yygone
			open UserDeclarations Internal.StartStates
 in (yybufpos := i; case yyk of 

			(* Application actions *)

  102 => (LexBasics.shifting "TYVAR(...)";
			    token1(TYVAR, yytext, arg, yypos, yytext)
			   )
| 104 => (YYBEGIN S; lex (LexUtils.clearString arg) ())
| 107 => (YYBEGIN C; lex (LexUtils.newComment arg) ())
| 109 => (lex (LexUtils.addChars yytext arg) ())
| 111 => (YYBEGIN INITIAL;
			    LexBasics.shifting "STRING(...)";
			    token1(STRING, LexUtils.asString arg,
				   arg, yypos, yytext
				  )
			   )
| 113 => (error(arg, yypos, "unclosed string");
			    YYBEGIN INITIAL;
			    LexBasics.shifting "STRING(bad)";
			    token1(STRING, "", arg, yypos, yytext)
			   )
| 118 => (continue())
| 12 => (token1(LexUtils.identifier, yytext,
				   arg, yypos, yytext
				  )
			   )
| 121 => (lex (LexUtils.addChars "\t" arg) ())
| 124 => (lex (LexUtils.addChars "\n" arg) ())
| 127 => (lex (LexUtils.addChars "\"" arg) ())
| 130 => (lex (LexUtils.addChars "\\" arg) ())
| 134 => (lex (LexUtils.addControlChar yytext arg) ())
| 139 => (lex (addAsciiChar(arg, yypos, yytext)) ())
| 141 => (error(arg, yypos, "illegal string escape");
			    continue()
			   )
| 144 => (lex (LexUtils.incComment arg) ())
| 147 => (case LexUtils.decComment arg
			      of (0, arg') => (YYBEGIN INITIAL; lex arg' ())
			       | (_, arg') => lex arg' ()
			    )
| 149 => (continue())
| 151 => (continue())
| 153 => (error(arg, yypos, "cannot lex \"" ^ yytext ^ "\"");
			    continue()
			   )
| 2 => (continue())
| 39 => (token1(if LexUtils.isQualStar yytext
				   then (LexBasics.shifting "QUAL_STAR";
					 QUAL_STAR
					)
				   else (LexBasics.shifting "QUAL_ID";
					 QUAL_ID
					),
				   LexUtils.asQualId yytext,
				   arg, yypos, yytext
				  )
			   )
| 43 => (token0(DOTDOTDOT, arg, yypos, yytext))
| 45 => (token0(LPAREN, arg, yypos, yytext))
| 47 => (token0(RPAREN, arg, yypos, yytext))
| 49 => (token0(LBRACKET, arg, yypos, yytext))
| 51 => (token0(RBRACKET, arg, yypos, yytext))
| 53 => (token0(LBRACE, arg, yypos, yytext))
| 55 => (token0(RBRACE, arg, yypos, yytext))
| 57 => (token0(COMMA, arg, yypos, yytext))
| 59 => (token0(SEMICOLON, arg, yypos, yytext))
| 61 => (token0(UNDERBAR, arg, yypos, yytext))
| 87 => (LexBasics.shifting "REAL(...)";
			    token1(REAL, LexUtils.asReal yytext,
				   arg, yypos, yytext
				  )
			   )
| 89 => (LexBasics.shifting "DIGIT(...)";
			    token1(DIGIT, LexUtils.asDigit yytext,
				   arg, yypos, yytext
				  )
			   )
| 9 => (token1(LexUtils.identifier, yytext,
				   arg, yypos, yytext
				  )
			   )
| 92 => (LexBasics.shifting "POSINT2(...)";
			    token1(POSINT2, LexUtils.asInteger yytext,
				   arg, yypos, yytext
				  )
			   )
| 96 => (LexBasics.shifting "NEGINT(...)";
			    token1(NEGINT, LexUtils.asInteger yytext,
				   arg, yypos, yytext
				  )
			   )
| _ => raise Internal.LexerError

		) end )

	val {fin,trans} = Vector.sub(Internal.tab, s)
	val NewAcceptingLeaves = fin::AcceptingLeaves
	in if l = !yybl then
	     if trans = #trans(Vector.sub(Internal.tab,0))
	       then action(l,NewAcceptingLeaves) else
	    let val newchars= if !yydone then "" else yyinput 1024
	    in if (size newchars)=0
		  then (yydone := true;
		        if (l=i0) then UserDeclarations.eof yyarg
		                  else action(l,NewAcceptingLeaves))
		  else (if i0=l then yyb := newchars
		     else yyb := String.extract i0 l (!yyb)^newchars;
		     yygone := !yygone+i0;
		     yybl := size (!yyb);
		     scan (s,AcceptingLeaves,l-i0,0))
	    end
	  else let val NewChar = String.ord(String.nth l (!yyb))
		val NewState = if NewChar<128 then String.ord(String.nth NewChar trans) else String.ord(String.nth 128 trans)
		in if NewState=0 then action(l,NewAcceptingLeaves)
		else scan(NewState,NewAcceptingLeaves,l+1,i0)
	end
	end
(*
	val start= if String.extract (!yybufpos-1) (!yypufpos) (!yyb)="\n"
then !yybegin+1 else !yybegin
*)
	in scan(!yybegin (* start *),nil,!yybufpos,!yybufpos)
    end
in continue end
  in lex
  end
end
