(* Much akin to the dynamic basis of the semantics document, but some of
   the entities are split into two. For example, the dynamic semantics
   maps variables to objects, where we have two mappings: variables->lvars
   and lvars->objects, since the lambda compiler sits in the middle. *)

(*
$File: Compiler/COMPILER_DYNAMIC_BASIS.sml $
$Date: 1992/09/17 14:17:43 $
$Revision: 1.1 $
$Locker:  $
*)

(*$COMPILER_DYNAMIC_BASIS: DYNAMIC_BASIS*)

signature COMPILER_DYNAMIC_BASIS =
  sig
    include DYNAMIC_BASIS		(* Must match this. It provides
					   the type Basis. *)

    type CEnv				(* compiler env: var->lvar *)
    type DEnv				(* dynamic env: lvar->object *)

    val mkBasis: CEnv * DEnv -> Basis
    val deBasis: Basis -> CEnv * DEnv

   (* MEMO:
      The printing entries (below) seem to be used in both DYNAMIC_BASIS
      realisations (MODULE_DYNOBJECT and COMPILER_DYNAMIC_BASIS), and
      should probably live in DYNAMIC_BASIS itself. *)

    type StringTree
    val layoutBasis: Basis -> StringTree

    type Report
    val reportBasis: Basis -> Report
  end;
