(* Type names - Definition v3 page 16 *)

(*
$File: Common/TyName.sml $
$Date: 1992/08/19 14:47:59 $
$Revision: 1.14 $
$Locker: birkedal $
*)

(*$TyName: TYCON TIMESTAMP FLAGS TYNAME*)
functor TyName(structure TyCon: TYCON
	       structure Timestamp: TIMESTAMP
	       structure Flags: FLAGS
	      ): TYNAME =
  struct
    type tycon = TyCon.tycon

    type TyName = {name: tycon, id: Timestamp.stamp,
		   arity: int, equality: bool
		  }

    fun freshTyName {name: tycon, arity: int, equality: bool} =
      {name=name, id=Timestamp.new(), arity=arity, equality=equality}

    val tyName_INT =
      freshTyName{name=TyCon.tycon_INT, arity=0, equality=true}
    and tyName_STRING =
      freshTyName{name=TyCon.tycon_STRING, arity=0, equality=true}
    and tyName_REAL =
      freshTyName{name=TyCon.tycon_REAL, arity=0, equality=true}
    and tyName_EXN =
      freshTyName{name=TyCon.tycon_EXN, arity=0, equality=false}
    and tyName_REF =
      freshTyName{name=TyCon.tycon_REF, arity=1, equality=true}
    and tyName_BOOL = 
      freshTyName{name=TyCon.tycon_BOOL, arity=0, equality=true}

    fun arity {name, id, arity, equality} = arity

    fun equality {name, id, arity, equality} = equality

    fun name {name, id, arity, equality} = name

    val pr_TyName: TyName -> string =
      if Flags.DEBUG_TYPES then
	fn {name, id, equality, ...} =>
	  let
	    val name  = TyCon.pr_TyCon name
	    val eq    = if equality then "E " else ""
	    val id    = Timestamp.print id
	  in
	    name ^ "(" ^ eq ^ id ^ ")"
	  end
      else
	fn {name, ...} =>
	  TyCon.pr_TyCon name
  end;
