/*
C
C  _______________________________________________________________
C
C*   Licence
C    =======
C
C    You may use or modify this code for your own non commercial
C    purposes for an unlimited time. 
C    In any case you should not deliver this code without a special 
C    permission of ZIB.
C    In case you intend to use the code commercially, we oblige you
C    to sign an according licence agreement with ZIB.
C
C
C  _______________________________________________________________
C
*/


#include <stdio.h>
#include <math.h>
#include <strings.h>
 
#include "kask.h"

#include "kaskcmd.h"
#include "kasktri.h"
#include "kaskgraph.h"

/* Achtung! Nur ueber den Daumen gepeilt */
#define PTTOINCH 0.0139
#define INCHTOPT 72.0
#define PTTOCM 0.0359
#define CMTOPT 27.8

#define MAXDRIVER 10

GRAPHIC *NewGraph();
DRIVER  *WdDriver();

static char *driverShort = "Window";
static char *driverName = "window";
static DRIVER **driver = nil;

static int AddDriver(driv)
  DRIVER *driv;
  {
	int k;

	if (driver==nil)
	  {
	    driver = (DRIVER**)ZIBAlloc((long)MAXDRIVER*sizeof(DRIVER*));
		if (driver==nil)
		  {
		    ZIBStdOut("Graph: not enough memory (AddDriver)\n");
			return false;
		  }
		for (k = 0; k<MAXDRIVER; k++) driver[k] = nil;
	  }
	for (k = 0; k<MAXDRIVER; k++) if (driver[k]==nil) break;
	if (k==MAXDRIVER) return false;
	driver[k] = driv;
	return true;
  }

static DRIVER *DelDriver(driv)
  DRIVER *driv;
  {
    int k;

	if (driver==nil)
	  {
	    driver = (DRIVER**)ZIBAlloc((long)MAXDRIVER*sizeof(DRIVER*));
		if (driver==nil)
		  {
		    ZIBStdOut("Graph: not enough memory (DelDriver)\n");
			return false;
		  }
		for (k = 0; k<MAXDRIVER; k++) driver[k] = nil;
	  }
	for (k = 0; k< MAXDRIVER; k++) if (driver[k]==driv) break;
	if (k==MAXDRIVER) return nil;
	driver[k] = nil;
	for (k = 0; k<MAXDRIVER; k++) if (driver[k]!=nil) break;
	if (k==MAXDRIVER) return nil;

	return driver[k];
  }

void AutomaticRedraw(triangP, solP, indexP, adjP)
  int triangP, solP, indexP, adjP;
  {
    int k;
	DRIVER *saveDriv = actDriver;
	GRAPHIC *saveGraph = actGraph;
	COMMAND stdCmd;
	char *namePointer[2];

	if (driver==nil) return;
	stdCmd.noOfPars = 0;
	stdCmd.no = 36;
	stdCmd.names = nil;
	stdCmd.pars = &(namePointer[0]);
	namePointer[0] = "Automatic";
	namePointer[1] = nil;

	for (k = 0; k< MAXDRIVER; k++)
	  {
	   actDriver = driver[k];
       if (actDriver==nil) continue;
       actGraph = actDriver->graph;
       if (actGraph==nil) continue;
       if (solP&&(actGraph->ddd))              { ShowGraph(&stdCmd); continue; }
       if (adjP&&(actGraph->layer))            { ShowGraph(&stdCmd); continue; }
       if (triangP&&(actGraph->triangulation)) { ShowGraph(&stdCmd); continue; }
       if (solP&&(actGraph->level))            { ShowGraph(&stdCmd); continue; }
       if (solP&&(actGraph->temperature))      { ShowGraph(&stdCmd); continue; }
       if (indexP&&(actGraph->index))          { ShowGraph(&stdCmd); continue; }
	  }
	actDriver = saveDriv;
	actGraph = saveGraph;
  }

static GRAPHIC *CopyGraph(graph)
  GRAPHIC *graph;
  {
    GRAPHIC *newGraph;
	int k;

    if (graph==nil) return NewGraph();
    newGraph = (GRAPHIC*) ZIBAlloc((long)sizeof(GRAPHIC));
	if (newGraph==nil) return nil;
	for (k=0; k<sizeof(GRAPHIC); k++)
	  ((char*)newGraph)[k] = ((char*)graph)[k];

	return newGraph;
  }

int Window(cmd)
  COMMAND *cmd;
  {
	int index, rc, k, alreadyNew = false;
	int topP = false, bottomP = false, leftP = false, rightP = false;
	char s1[256], s2[256], *tp;
	REAL hOffset, vOffset, width, height, aux;
	DRIVER *saveDriver = actDriver;
	double help1, help2;

	if (ParsCheck(cmd, 0, 99)) return false;

	if (actTriang==nil)
	  {
	    ZIBStdOut("Graph: no triangulation - no graphic\n");
		return false;
	  }

	if (actDriver==nil)
	  { actDriver = WdDriver(); alreadyNew = true; }
	else
	  {
		if ((actDriver->windowNo)<0)
		  { actDriver = WdDriver(); alreadyNew = true; }
	  }
	if (actDriver==nil) { actDriver = saveDriver; return false; }

	if ((cmd->noOfPars)==0)			/* informing */
	  {
	    sprintf(globBuf, "%s: current driver (%s) settings\n",
				driverShort, driverName);
		ZIBStdOut(globBuf);
		sprintf(&s1[0], "(%.2fcm,%.2fcm)",
				((actDriver->right)-(actDriver->left))*PTTOCM,
				((actDriver->bottom)-(actDriver->top))*PTTOCM);
		sprintf(&s2[0], "(%.2fcm,%.2fcm)",
				(actDriver->left)*PTTOCM, (actDriver->bottom)*PTTOCM);
		sprintf(globBuf, "%s:     picture size %s at %s\n",
				driverShort, &s1[0], &s2[0]);
		ZIBStdOut(globBuf);
		sprintf(&s1[0], "(%.2fcm,%.2fcm)",
				(actDriver->maxRight)*PTTOCM,
				(actDriver->maxBottom)*PTTOCM);
		sprintf(globBuf, "%s:     page size %s\n", driverShort, &s1[0]);
		ZIBStdOut(globBuf);
		sprintf(globBuf, "%s:     resolution %e\n", driverShort,
				actDriver->resolution);
		ZIBStdOut(globBuf);
		sprintf(globBuf, "%s:     font '%s'\n", driverShort,
				actDriver->fontName);
		ZIBStdOut(globBuf);
		sprintf(globBuf, "%s:     (file)name '%s'\n", driverShort,
				actDriver->fileName);
		ZIBStdOut(globBuf);
	  }
	else
	{
	for (k = 1; k<=(cmd->noOfPars); k++)
	  {
		tp = (cmd->pars)[k];
		index = CheckName(&tp, cmd->names, nameClass);
		if (index==-1)
		  {
		    sprintf(globBuf, "Graph: '%s' unknown parameter to %s\n",
					(cmd->pars)[k], (cmd->pars)[0]);
			ZIBStdOut(globBuf);
			return false;
		  }
		switch (index)
		{
		  case 0:						/* size */
	          if ((cmd->noOfPars)==k)
			    {
				  actDriver->top = actDriver->maxTop;
				  actDriver->right = actDriver->maxRight;
				}
			  else
				{
				  rc = sscanf((cmd->pars)[k+1], "(%le,%le)",
				  			  &help1, &help2);
						width  = help1;
						height = help2;
				  if (rc!=2)
				    {
					  sprintf(globBuf, "%s: syntax error reading size '%s'\n",
					  		  driverShort, (cmd->pars)[k+1]);
					  ZIBStdOut(globBuf);
					  return false;
					}
				  actDriver->right = actDriver->left+width*CMTOPT;
				  actDriver->top = actDriver->bottom-height*CMTOPT;
				  k++;
				}
			  break;
		  case 1:						/* origin */
	          if ((cmd->noOfPars)==k)
			    {
				  actDriver->bottom = actDriver->maxBottom;
				  actDriver->left = actDriver->maxLeft;
				}
			  else
				{
				  rc = sscanf((cmd->pars)[k+1], "(%le,%le)",
				  			  &help1, &help2);
						hOffset = help1;
						vOffset = help2;
				  if (rc!=2)
				    {
					  sprintf(globBuf, "%s: syntax error reading origin '%s'\n",
					  		  driverShort, (cmd->pars)[k+1]);
					  ZIBStdOut(globBuf);
					  return false;
					}
				  height = actDriver->top-actDriver->bottom;
				  width = actDriver->right-actDriver->left;
				  actDriver->bottom = vOffset*CMTOPT;
				  actDriver->left = hOffset*CMTOPT;
				  actDriver->top = actDriver->bottom+height;
				  actDriver->right = actDriver->left+width;
				  k++;
				}
			  break;
		  case 2:						/* font */
			  actDriver->fontName =
			  	(char*)ZIBAlloc((long)(strlen((cmd->pars)[k+1])+1));
			  if ((actDriver->fontName)==nil)
			    {
				  ZIBStdOut("Graph: not enough memory (fontName)\n",
				  		  driverName);
				  return false;
				}
			  strcpy(actDriver->fontName, (cmd->pars)[k+1]);
			  k++;
			  break;
		  case 3:						/* name */
			  actDriver->fileName =
			  	(char*)ZIBAlloc((long)(strlen((cmd->pars)[k+1])+1));
			  if ((actDriver->fileName)==nil)
			    {
				  ZIBStdOut("Graph: not enough memory (fileName)\n",
				  		  driverName);
				  return false;
				}
			  strcpy(actDriver->fileName, (cmd->pars)[k+1]);
			  k++;
			  break;
		  case 4:						/* top */
		      topP = true;
			  break;
		  case 5:						/* bottom */
		      bottomP = true;
			  break;
		  case 6:						/* left */
		      leftP = true;
			  break;
		  case 7:						/* right */
		      rightP = true;
			  break;
		  case 8:						/* new */
		      if (alreadyNew) break;
			  alreadyNew = true;
			  actDriver = WdDriver();
			  if (actDriver==nil)
			    { actDriver = saveDriver; break; }
			  break;
		  case 9:						/* close */
		      (actDriver->Close)();
			  actDriver = DelDriver(actDriver);
			  break;
		  case 10:						/* automatic */
		      actDriver->graph = CopyGraph(actGraph);
			  break;
		}
	  }
/* check window bounds and change left/right or top/bottom, if necessary */
    if ((actDriver->left) > (actDriver->right)) 
       {
        aux = (actDriver->left);
        (actDriver->left) = (actDriver->right);
        (actDriver->right) = aux;
       }
    if ((actDriver->left) < (actDriver->maxLeft)) 
        (actDriver->left) = (actDriver->maxLeft);
    if ((actDriver->right) > (actDriver->maxRight)) 
        (actDriver->right) = (actDriver->maxRight);
    if ((actDriver->maxBottom) > (actDriver->maxTop))
       {
        if ((actDriver->top) > (actDriver->bottom)) 
           {
            aux = (actDriver->top);
            (actDriver->top) = (actDriver->bottom);
            (actDriver->bottom) = aux;
           }
        if ((actDriver->top) < (actDriver->maxTop)) 
            (actDriver->top) = (actDriver->maxTop);
        if ((actDriver->bottom) > (actDriver->maxBottom)) 
            (actDriver->bottom) = (actDriver->maxBottom);
       }
    else
       {
        if ((actDriver->top) < (actDriver->bottom)) 
           {
            aux = (actDriver->top);
            (actDriver->top) = (actDriver->bottom);
            (actDriver->bottom) = aux;
           }
        if ((actDriver->top) > (actDriver->maxTop)) 
            (actDriver->top) = (actDriver->maxTop);
        if ((actDriver->bottom) < (actDriver->maxBottom)) 
            (actDriver->bottom) = (actDriver->maxBottom);
       }

	} /* end else(noOfPars==0) */
	if (topP)
	  {
	    actDriver->top = (actDriver->maxTop);
		actDriver->bottom = ((actDriver->maxBottom)-
		                     (actDriver->maxTop))*0.5;
	  }
	if (bottomP)
	  {
		actDriver->top = ((actDriver->maxBottom)-
		                  (actDriver->maxTop))*0.5;
	    actDriver->bottom = (actDriver->maxBottom);
	  }
	if (leftP)
	  {
	    actDriver->left = (actDriver->maxLeft);
		actDriver->right = ((actDriver->maxRight)-
		                    (actDriver->maxLeft))*0.5;
	  }
	if (rightP)
	  {
		actDriver->left = ((actDriver->maxRight)-
		                   (actDriver->maxLeft))*0.5;
	    actDriver->right = (actDriver->maxRight);
	  }
	if (actDriver==nil) { actDriver = saveDriver; return true; }
	if (alreadyNew) AddDriver(actDriver);
	if ((actDriver->OpenPort)()) return true;
	actDriver = saveDriver;
	return false;
  }
